AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.Draw2DCanvas.Layer", {
    /**
     * Add a figure to the canvas and spy on its `insertAfter()` methods.
     *
     * @param {draw2d.Figure} figure The figure.
     */
    addFigure: function (figure) {
        this.canvas.addFigure(figure);
        figure.shape && sinon.spy(figure.shape, "insertAfter");
        figure.svgNodes && sinon.spy(figure.svgNodes, "insertAfter");
    },

    /**
     * Create a new layer.
     *
     * @returns {JIRA.WorkflowDesigner.Draw2DCanvas.Layer} A new layer.
     */
    createLayer: function () {
        return new JIRA.WorkflowDesigner.Draw2DCanvas.Layer(this.canvas);
    },

    setup: function () {
        this.canvas = JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();
        this.layer = this.createLayer();
    }
});

test("addFigure() adds the figure to the canvas if necessary", function () {
    var addFigureSpy,
        figure = new draw2d.shape.basic.Rectangle(1, 1),
        otherLayer = this.createLayer();

    addFigureSpy = sinon.spy(this.canvas, "addFigure");
    this.layer.addFigure(figure);
    equal(addFigureSpy.callCount, 1, "Canvas#addFigure() is called when the figure isn't on the canvas");
    ok(addFigureSpy.args[0][0] === figure, "It was passed the correct figure");

    otherLayer.addFigure(figure);
    equal(addFigureSpy.callCount, 1, "Canvas#addFigure() isn't called when the figure is already on the canvas");
});

test("addFigure() inserts the figure after the topmost figure", function () {
    var circle = new draw2d.shape.basic.Circle(1),
        rectangle = new draw2d.shape.basic.Rectangle(1, 1);

    // Create the figures' shapes.
    this.addFigure(circle);
    this.addFigure(rectangle);

    // Add after the placeholder.
    this.layer.addFigure(circle);
    equal(circle.shape.insertAfter.callCount, 1, "Element#insertAfter() was called");
    ok(circle.shape.insertAfter.args[0][0] === this.layer._figures[0].shape, "It was passed the correct element");

    // Add after the topmost figure.
    this.layer.addFigure(rectangle);
    equal(rectangle.shape.insertAfter.callCount, 1, "Element#insertAfter() was called");
    ok(rectangle.shape.insertAfter.args[0][0] === circle.shape, "It was passed the correct element");
});

test("addFigure() supports set figures", function () {
    var circle = new draw2d.shape.basic.Circle(1),
        label = new draw2d.shape.basic.Label("Hello, world!"),
        rectangle = new draw2d.shape.basic.Rectangle(1, 1);

    // Create the figures' shapes.
    this.addFigure(circle);
    this.addFigure(label);
    this.addFigure(rectangle);

    this.layer.addFigure(circle);
    this.layer.addFigure(label);
    equal(label.svgNodes.insertAfter.callCount, 1, "Set#insertAfter() was called");
    ok(label.svgNodes.insertAfter.args[0][0] === circle.shape, "It was passed the correct element");
    ok(label.shape.next === label.svgNodes, "Correct node order was maintained");
});

test("addFigure() removes the figure from its current layer", function () {
    var figure = new draw2d.shape.basic.Rectangle(1, 1),
        otherLayer = this.createLayer(),
        removeFigureSpy = sinon.spy(this.layer, "removeFigure");

    this.layer.addFigure(figure);
    otherLayer.addFigure(figure);

    equal(removeFigureSpy.callCount, 1, "Layer#removeFigure() was called");
    ok(removeFigureSpy.args[0][0] === figure, "It was passed the correct figure");
});

test("Creates a placeholder figure on instantiation", function () {
    var addFigureSpy = sinon.spy(this.canvas, "addFigure");

    this.createLayer();
    equal(addFigureSpy.callCount, 1, "A figure was added to the canvas");
    ok(addFigureSpy.args[0][0] instanceof JIRA.WorkflowDesigner.Draw2DCanvas.LayerRootFigure,
            "It is a JIRA.WorkflowDesigner.Draw2DCanvas.LayerRootFigure");
});