AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.ActionsView",{createView:function(B){var A;A=new JIRA.WorkflowDesigner.ActionsView(_.extend({canvasModel:this.canvasModel,fullScreenButton:true,workflowModel:this.workflowModel},B));this.container.empty().append(A.render().el);return A},setup:function(){this.container=jQuery("#qunit-fixture");this.sandbox=sinon.sandbox.create();this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel();this.canvasModel=new JIRA.WorkflowDesigner.CanvasModel({},{workflowModel:this.workflowModel})},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});test("Add Status",function(){var A,C=_.extend({hide:sinon.stub(),show:sinon.stub()},JIRA.WorkflowDesigner.Backbone.Events),B=this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"AddStatusInlineDialogView").returns(C);this.createView();A=this.container.find(".add-status");A.click();equal(B.callCount,1,"An AddStatusInlineDialogView was created");ok(B.args[0][0].trigger[0]===this.container.find(".add-status")[0],"Its constructor was passed the correct arguments");equal(C.show.callCount,1,"The dialog was shown");A.addClass("active").click();equal(C.hide.callCount,1,"The dialog was hidden")});test("Add transition",function(){var B=this.createView(),C={show:sinon.spy()},A=this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"AddTransitionDialogView").returns(C),D;B.$(".add-transition").click();equal(A.callCount,1,"An AddTransitionDialogView was created");ok(A.args[0][0].workflowModel===this.workflowModel,"Its constructor was passed the correct arguments");equal(C.show.callCount,1,"The dialog was shown");D=A.args[0][0].transitionModel;ok(!D.has("source"),"The transition doesn't have a source set");ok(!D.has("target"),"The transition doesn't have a target set")});test("Add transition with a status selected",function(){var C=this.createView(),A=this.sandbox.spy(JIRA.WorkflowDesigner.Dialogs,"AddTransitionDialogView"),B=this.workflowModel.addStatus(),D;this.canvasModel.set("selectedModel",B);C.$(".add-transition").click();D=A.args[0][0].transitionModel;ok(D.get("source")===B,"The transition's source is the selected status");ok(D.get("target")===B,"The transition's target is the selected status")});test("Contains editing buttons in mutable mode",function(){this.createView();equal(this.container.find(".aui-toolbar2-primary").length,1,"Editing buttons are present")});test("Doesn't contain editing buttons in immutable mode",function(){this.createView({immutable:true});equal(this.container.find(".aui-toolbar2-primary").length,0,"Editing buttons are not present")});test("Entering and exiting full screen mode",function(){var B=this.createView(),D=this.container.find(".enter-full-screen"),F=D.tipsy(true),A=this.container.find(".exit-full-screen"),E=A.tipsy(true),C=sinon.spy(),G=sinon.spy();B.on("fullScreen:enter",C);B.on("fullScreen:exit",G);ok(!D.hasClass("hidden"),"Enter full screen button is visible initially");ok(F.enabled,"Enter full screen button tooltip is enabled");ok(A.hasClass("hidden"),"Exit full screen button is hidden initially");ok(!E.enabled,"Exit full screen button tooltip is disabled");D.click();ok(D.hasClass("hidden"),"Enter full screen button is hidden after entering full screen");ok(!F.enabled,"Enter full screen button tooltip is disabled");ok(!A.hasClass("hidden"),"Exit full screen button is visible after entering full screen");ok(E.enabled,"Exit full screen button tooltip is enabled");ok(C.calledOnce,"fullScreen:enter event triggered upon entering full screen");A.click();ok(!D.hasClass("hidden"),"Enter full screen button is visible after exiting full screen");ok(F.enabled,"Enter full screen button tooltip is enabled");ok(A.hasClass("hidden"),"Exit full screen button is hidden after exiting full screen");ok(!E.enabled,"Exit full screen button tooltip is disabled");ok(G.calledOnce,"fullScreen:exit event triggered upon exiting full screen")});test("Events are forwarded from the AddStatusInlineDialogView",function(){var C=_.extend({show:jQuery.noop},JIRA.WorkflowDesigner.Backbone.Events),B=sinon.spy(),A=sinon.spy();this.createView().on({"addStatus:done":B,"addStatus:submit":A});this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"AddStatusInlineDialogView").returns(C);this.container.find(".add-status").click();C.trigger("submit");equal(A.callCount,1,"An addStatus:submit event was triggered");C.trigger("done");equal(B.callCount,1,"An addStatus:done event was triggered")});test("Full screen mode can be disabled",function(){this.createView({fullScreenButton:false});equal(this.container.find(".full-screen-trigger").length,0,"No full screen triggers are present")});test('Toggling the "Show Transition Labels" checkbox updates CanvasModel',function(){var A;this.canvasModel.set("showTransitionLabels",false);this.createView();A=this.container.find("#show-transition-labels");ok(!A.is(":checked"),"Checkbox is rendered unchecked when the model attribute is false");this.canvasModel.set("showTransitionLabels",true);this.createView();A=this.container.find("#show-transition-labels");ok(A.is(":checked"),"Checkbox is rendered checked when the model attribute is true");A.attr("checked",true).trigger("change");ok(this.canvasModel.get("showTransitionLabels"),"The model property is true when checkbox is checked");A.attr("checked",false).trigger("change");ok(!this.canvasModel.get("showTransitionLabels"),"The model property is false when checkbox is not checked")});test("Last edited message not displayed when immutable",function(){var A;this.createView({immutable:true});this.sandbox.stub(JIRA.Users.LoggedInUser,"userName").returns("bob");this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date());A=this.container.find(".last-edited-message");ok(!A.length,"Last edited message should not be displayed.")});test("Last edited message displayed when both updateAuthor and updatedDate defined",function(){var A;this.createView();this.sandbox.stub(JIRA.Users.LoggedInUser,"userName").returns("bob");this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date());A=this.container.find(".last-edited-message");equal(A.text(),"Last edited by you, LLL","Last edited message should be displayed.")});test("Last edited message not displayed when lastUpdater defined and updatedDate not defined",function(){var A;this.createView();this.sandbox.stub(JIRA.Users.LoggedInUser,"userName").returns("bob");this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});A=this.container.find(".last-edited-message");ok(!A.length,"Last edited message should not be displayed.")});test("Last edited message not displayed when updateAuthor not defined and updatedDate defined",function(){var A;this.createView();this.sandbox.stub(JIRA.Users.LoggedInUser,"userName").returns("bob");this.workflowModel.set("updatedDate",new Date());A=this.container.find(".last-edited-message");ok(!A.length,"Last edited message should not be displayed.")});test("Last edited message not displayed when both updateAuthor and updatedDate not defined",function(){var A;this.createView();this.sandbox.stub(JIRA.Users.LoggedInUser,"userName").returns("bob");A=this.container.find(".last-edited-message");ok(!A.length,"Last edited message should not be displayed.")});test("'You' last edited message should be displayed if current user is same as last updater",function(){var A;this.createView();this.sandbox.stub(JIRA.Users.LoggedInUser,"userName").returns("bob");this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date());A=this.container.find(".last-edited-message");equal(A.text(),"Last edited by you, LLL","Last edited message should be displayed.")});test("'User' last edited message should be displayed if current user is not same as last updater",function(){var A;this.createView();this.sandbox.stub(JIRA.Users.LoggedInUser,"userName").returns("jim");this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date());A=this.container.find(".last-edited-message");equal(A.text(),"Last edited by Bob Dude, LLL","Last edited message should be displayed.")});test("Last edited message not updated when model updated",function(){this.createView();this.sandbox.stub(JIRA.Users.LoggedInUser,"userName").returns("bob");this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date(new Date().getTime()));equal(this.container.find(".last-edited-message").text(),"Last edited by you, LLL","Last edited message should be displayed.");this.workflowModel.set("updateAuthor",{userName:"jim",displayName:"Jim Man"});equal(this.container.find(".last-edited-message").text(),"Last edited by you, LLL","Last edited message should still be the same as before.")});