AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.TriangleFigure", {

    assertPathData: function (figure, expected) {
        var path = figure.getShapeElement()[0].attributes.d;
        var pathData = path.value;
        equal(pathData, expected,
            "The figure's SVG path data was correct");
    },

    setup: function () {
        this.canvas = JIRA.WorkflowDesigner.TestUtilities.testCanvasView().canvas;
    }
});

test("A TriangleFigure is created with the correct path", function () {
    var triangle = new JIRA.WorkflowDesigner.TriangleFigure();

    triangle.setDimension(100,100);

    this.canvas.addFigure(triangle);

    this.assertPathData(triangle, [
        "M0,50",
        "L100,0",
        "L100,100",
        "Z"
    ].join(""));
});