(function () {
    /**
     * Dialog
     *
     * @inner
     * @type {JIRA.WorkflowDesigner.Dialog}
     */
    var workflowDialog;

    AJS.namespace("JIRA.WorkflowDesigner.ProjectAdminWorkflows");

    /**
     * Code related to showing the new workflow designer on the project admin workflow pages.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.ProjectAdminWorkflows = {
        /**
         * Adds the new workflow designer to the project admin workflow page.
         * This gets appended in after the 'view as text' link.
         *
         * @param textModeLink The link to append the new link after.
         */
        replaceLink: function (existingLink, textModeLink) {
            var workflowName = textModeLink.data('workflowname');
            var diagramLink = this._addDiagramLink(existingLink, workflowName);
            diagramLink.click(function(e) {
                e.preventDefault();

                workflowDialog = new JIRA.WorkflowDesigner.Dialog({
                    id: "view-workflow-dialog-project-admin",
                    workflowId: function() {
                        return workflowName;
                    }
                });
                workflowDialog.show();
            });
        },

        /**
         * Add a "diagram" workflow mode link.
         *
         * @param existingLink The existing diagram mode link.
         * @param workflowName the workflow name to link to.
         * @return {jQuery} The new link.
         */
        _addDiagramLink: function (existingLink, workflowName) {
            var diagramLink = jQuery(JIRA.WorkflowDesigner.Templates.ProjectAdminWorkflows.link({workflowName: workflowName}));
            existingLink.replaceWith(diagramLink);
            return diagramLink;
        }
    };

    // Patch the projects admin workflows page when the workflow is ready.
    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, context, reason) {
        if (reason === JIRA.CONTENT_ADDED_REASON.workflowReady && JIRA.WorkflowDesigner.browserIsSupported()) {
            JIRA.WorkflowDesigner.ProjectAdminWorkflows.replaceLink(
                context.find(".project-config-workflow-diagram"), context.find(".project-config-workflow-text-link"));
        }
    });
}());