(function () {
    AJS.namespace("JIRA.WorkflowDesigner.InlineDialogSVGPositioner");

    /**
     * @namespace
     */
    JIRA.WorkflowDesigner.InlineDialogSVGPositioner = {
        /**
         * Position an inline dialog on an SVG element.
         *
         * @param {element} element The inline dialog's element.
         * @param {object} targetPosition
         * @param {element} targetPosition.target The element under which the inline dialog is to be positioned.
         * @param {object} mousePosition
         * @param {number} mousePosition.x
         * @param {number} mousePosition.y
         * @param {object} options The inline dialog's options.
         */
        calculatePosition: function (element, targetPosition, mousePosition, options) {
            var boundingBox,
                result,
                targetElement;

            // Create a dummy element with the same position and size as the target element.
            boundingBox = JIRA.WorkflowDesigner.SVGUtilities.getPageBoundingBox(targetPosition.target);
            targetElement = jQuery("<div/>").css({
                height: boundingBox.height,
                left: boundingBox.x,
                position: "absolute",
                top: boundingBox.y,
                width: boundingBox.width
            }).appendTo("body");

            result = AJS.InlineDialog.opts.calculatePositions(element, {target: targetElement}, mousePosition, options);
            targetElement.remove();
            return result;
        }
    };
}());