(function () {
    AJS.namespace("JIRA.WorkflowDesigner.Feedback");

    /**
     * @namespace
     */
    JIRA.WorkflowDesigner.Feedback = {
        /**
         * Initialises the issue collector for the given ID and trigger element.
         *
         * @param {jQuery} feedbackTrigger trigger element
         * @param {String} collectorId Issue Collector ID
         * @return {jQuery.Deferred} Deferred object that is resolved or rejected depending on the success of Issue Collector initialisation.
         */
        init: function(feedbackTrigger, collectorId) {
            var deferred = jQuery.Deferred();

            jQuery.ajax({
                url: "https://jira.atlassian.com/s/en_UKkdyw0-1988229788/6097/9/1.4.0-m2/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?collectorId=" + collectorId,
                type: "get",
                cache: true,
                dataType: "script",
                success: function() {
                    window.ATL_JQ_PAGE_PROPS = window.ATL_JQ_PAGE_PROPS || {};

                    window.ATL_JQ_PAGE_PROPS[collectorId] = {
                        "triggerFunction": function(showCollectorDialog) {
                            feedbackTrigger.click(function(e) {
                                e.preventDefault();

                                showCollectorDialog();
                            });
                        }
                    };

                    deferred.resolve();
                },
                error: function() {
                    deferred.reject();
                }
            });

            return deferred;
        }
    };
}());