(function () {
    AJS.namespace("JIRA.WorkflowDesigner.Draw2DUtilities");

    /**
     * Draw2d utility methods.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.Draw2DUtilities = {
        /**
         * Set the cursor property for the passed figure.
         *
         * @param {draw2d.Figure} figure Figure to set the cursor property for.
         * @param {string} cursor Cursor property value to set.
         */
        setCursor: function (figure, cursor) {
            var target = figure.svgNodes || figure.shape;
            target && target.attr("cursor", cursor);
        }
    };
}());