AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.Policy.Canvas.PanningSingleSelectionPolicy", {
    setup: function () {
        this.sandbox = sinon.sandbox.create();
        this.canvas = JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();
        this.policy = new JIRA.WorkflowDesigner.Policy.Canvas.PanningSingleSelectionPolicy(function() {
            return new draw2d.geo.Rectangle(0, 0, 100, 100);
        });
    },

    teardown: function () {
        JIRA.WorkflowDesigner.TestUtilities.removeDialogs();
        this.sandbox.restore();
    },

    assertViewBoxPanning: function (displacement, current, expected) {
        var mouseString = "(" + displacement.join(",") + ")",
            currentString = "(" + current.getX() + "," + current.getY() + ")",
            expectedString = "(" + expected.getX() + "," + expected.getY() + ")";

        //Using QUnit.equal() to get the diff in case of error
        equal(currentString, expectedString,
            "Displacing the mouse " + mouseString + " should move the viewport");

    }
});

test("onMouseDown() should hide the current inline dialog", function () {
    AJS.InlineDialog.current = {hide: this.sandbox.spy()};

    this.policy.onMouseDown(this.canvas, 0, 0);

    equal(AJS.InlineDialog.current.hide.callCount, 1, "The current inline dialog was hidden");
});

test("onMouseDrag() should pan the viewBox without hiding the workflow", function () {
    this.sandbox.stub(this.canvas, "getViewBox").returns(new draw2d.geo.Rectangle(-100, -100, 300, 300));
    this.sandbox.spy(this.canvas, "setViewBoxQuick");

    //Format [ [mouseDisplacement], [expectedViewBoxPosition] ]
    var testData = [
        // Small displacements
        [[  10,   10], [ -110,  -110]],
        [[   0,    0], [ -100,  -100]],
        [[ -10,  -10], [ -90,    -90]],
        [[  10,  -10], [ -110,   -90]],

        // Just in the limit, workflow 25% visible
        [[ 175,  175], [ -275,  -275]],
        [[-175, -175], [   75,    75]],

        // Off-limits, should hide the workflow
        [[ 200,  200], [ -275,  -275]],
        [[-200, -200], [   75,    75]]
    ];

    _.each(testData, function (test) {
        this.policy.onMouseDown(this.canvas, 0, 0);
        this.policy.onMouseDrag(this.canvas, test[0][0], test[0][1]);

        this.assertViewBoxPanning(
            test[0],
            this.canvas.setViewBoxQuick.lastCall.args[0],
            new draw2d.geo.Rectangle(test[1][0], test[1][1], 300, 300)
        );

    }, this);
});

test("onMouseDrag() should call Raphael's setViewBox when the interaction finish", function () {
    JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function (clock) {
        // Need to test this function through the prototype, as it will be bound and debounced on
        // JIRA.WorkflowDesigner.Draw2DCanvas constructor.
        this.sandbox.spy(JIRA.WorkflowDesigner.Draw2DCanvas.prototype, "setViewBox");

        var canvas = JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();
        this.sandbox.stub(canvas, "getViewBox").returns(new draw2d.geo.Rectangle(-100, -100, 300, 300));
        this.sandbox.spy(canvas, "setViewBoxQuick");

        this.policy.onMouseDown(canvas, 0, 0);
        this.policy.onMouseDrag(canvas, 10, 10);

        this.assertViewBoxPanning(
            [10, 10],
            canvas.setViewBoxQuick.lastCall.args[0],
            new draw2d.geo.Rectangle(-110, -110, 300, 300)
        );

        clock.tick(150);

        this.assertViewBoxPanning(
            [10, 10],
            JIRA.WorkflowDesigner.Draw2DCanvas.prototype.setViewBox.lastCall.args[0],
            new draw2d.geo.Rectangle(-110, -110, 300, 300)
        );
    }, this);
});