(function () {
    AJS.namespace("JIRA.WorkflowDesigner.Layout.Locator.PositionOnParentBoundsLocator");

    JIRA.WorkflowDesigner.Layout.Locator.PositionOnParentBoundsLocator = draw2d.layout.locator.Locator.extend(
    /** @lends JIRA.WorkflowDesigner.Layout.Locator.PositionOnParentBoundsLocator# */
    {
        /**
         * Initialise the locator.
         *
         * The child figure is positioned at the given side of the parent figure's bounds, at the position specified by
         * bias.
         *
         * @classdesc
         * A Draw2D locator that positions a figure at a fixed location on its parent bounds.
         *
         * For example, a figure could be positioned at x% horizontally on the top side of the parent figure.
         * @constructs
         * @extends draw2d.layout.locator.Locator
         * @param {object} options
         * @param {number} options.side Side to position the figure on, one of the JIRA.WorkflowDesigner.Direction values.
         * @param {number} options.bias The fraction of the side where the figure will be placed.
         * @param {draw2d.Figure} options.parent The parent figure.
         */
        init: function (options) {
            this._super(options.parent);

            this.side = options.side;
            this.bias = options.bias;
        },

        /**
         * Relocate a child figure.
         *
         * @param {number} index The child figure's index.
         * @param {draw2d.Figure} target The child figure.
         */
        relocate: function (index, target) {
            var parentBoundingBox = this.getParent().getBoundingBox(),
                direction = JIRA.WorkflowDesigner.Direction,
                x, y;

            if (this.side === direction.UP || this.side === direction.DOWN) {
                x = parentBoundingBox.getWidth() * this.bias;
                y = (this.side === direction.UP) ? 0 : parentBoundingBox.getHeight();
            } else if (this.side === direction.LEFT || this.side === direction.RIGHT) {
                y = parentBoundingBox.getHeight() * this.bias;
                x = (this.side === direction.LEFT) ? 0 : parentBoundingBox.getWidth();
            }

            target.setPosition(x, y);
        }
    });
}());