(function () {
    /**
     * Shortcut for JIRA.WorkflowDesigner.Vector2D
     * @inner
     * @type {function}
     */
    var Vector2D;

    AJS.namespace("JIRA.WorkflowDesigner.Layout.Connection.RoundedManhattanConnectionRouter");

    JIRA.WorkflowDesigner.Layout.Connection.RoundedManhattanConnectionRouter = draw2d.layout.connection.ManhattanConnectionRouter.extend(
    /** @lends JIRA.WorkflowDesigner.Layout.Connection.RoundedManhattanConnectionRouter.prototype */
    {
        /**
         * The connection's preferred corner radius.
         *
         * It may not be possible to use this radius when line segments are too short.
         *
         * @constant
         * @default
         * @type {number}
         */
        CORNER_RADIUS: 5,

        /**
         * Initialise the router.
         *
         * @constructs
         * @classdesc A Manhattan connection router with rounded corners.
         * @extends draw2d.layout.connection.ManhattanConnectionRouter
         */
        init: function () {
            this._super.apply(this, arguments);
            Vector2D = JIRA.WorkflowDesigner.Vector2D;
        },

        /**
         * Calculate and return the points of a connection.
         *
         * @param {draw2d.Connection} connection The connection.
         * @return {draw2d.geo.Point[]} The connection's points.
         * @private
         */
        _calculateConnectionPoints: function (connection) {
            this._route(
                connection,
                connection.getEndPoint(),
                connection.getTarget().getConnectionDirection(),
                connection.getStartPoint(),
                connection.getSource().getConnectionDirection()
            );

            return connection.getPoints().asArray();
        },

        /**
         * Get SVG path instructions for a point.
         *
         * @param {draw2d.geo.Point} point The point.
         * @param {number} index <tt>point</tt>'s position in the connection.
         * @param {draw2d.geo.Point[]} points All points in the connection.
         * @return {object[]} The SVG path instructions for <tt>point</tt>.
         * @private
         */
        _getPointInstructions: function (point, index, points) {
            var next = new Vector2D(point, points[index + 1] || point),
                prev = new Vector2D(point, points[index - 1] || point),
                radius;

            // The radius must be less than half the segment lengths so it doesn't overlap other corners.
            radius = Math.min(next.getLength() / 2, prev.getLength() / 2, this.CORNER_RADIUS);

            return [
                "L", point.add(prev.normalize().multiply(radius)).getComponents(),
                "S", point.getComponents(), point.add(next.normalize().multiply(radius)).getComponents()
            ];
        },

        /**
         * Route a connection and calculate its SVG path string.
         *
         * @param {draw2d.Connection} connection The connection.
         */
        route: function (connection) {
            var instance = this,
                points;

            function reduceInstructions(instructions, point, index, points) {
                return instructions.concat(instance._getPointInstructions(point, index, points));
            }

            points = this._calculateConnectionPoints(connection);
            connection.svgPathString = _.reduce(points, reduceInstructions, ["M", points[0].x, points[0].y]).join(" ");
        }
    });
}());