AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager", {
    setup: function () {
        this.addStatusURL = AJS.contextPath() + "/rest/workflowDesigner/latest/workflows/statuses";
        this.createStatusURL = AJS.contextPath() + "/rest/workflowDesigner/latest/workflows/statuses/create";
        this.sandbox = sinon.sandbox.create({useFakeServer: true});
        this.workflowDataReaderStub = this.sandbox.stub(JIRA.WorkflowDesigner.IO.WorkflowDataReader, "read");
        this.workflowStatusesAJAXManager = JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager;
    },

    teardown: function () {
        this.sandbox.restore();
    }
});

test("addStatus()", function () {
    var deferred,
        sentRequestBody,
        expectedRequestBody,
        response = {};

    deferred = this.workflowStatusesAJAXManager.addStatus({
        createGlobalTransition: true,
        statusId: "Open",
        workflowName: "Workflow"
    });

    this.workflowDataReaderStub.returns(response);
    this.sandbox.server.respondWith(this.addStatusURL, [200, {}, "{}"]);
    this.sandbox.server.respond();

    expectedRequestBody = {
        createGlobalTransition: "true",
        statusId: "Open",
        workflowName: "Workflow"
    };
    sentRequestBody = JIRA.WorkflowDesigner.TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
    deepEqual(sentRequestBody, expectedRequestBody, "The request's body was correct");

    equal(this.workflowDataReaderStub.callCount, 1, "The AJAX response was passed to WorkflowDataReader.read()");
    deepEqual(this.workflowDataReaderStub.args[0], [{}], "It was passed the correct arguments");

    equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    deferred.done(function (data) {
        ok(data === response, "It was resolved with the output of WorkflowDataReader.read()");
    });
});

test("addStatus() rejects the returned deferred on error", function () {
    var deferred;

    deferred = this.workflowStatusesAJAXManager.addStatus({
        createGlobalTransition: true,
        statusId: "Closed",
        workflowName: "Workflow"
    });

    this.sandbox.server.respondWith(this.addStatusURL, [400, {}, "No deal."]);
    this.sandbox.server.respond();

    equal(deferred.state(), "rejected", "The returned deferred was rejected");
    deferred.fail(function (errorMessage) {
        equal(errorMessage, "No deal.", "It was rejected with the error message.");
    });
});

test("createStatus() with create global transition flag", function () {
    var deferred,
        expectedRequestBody,
        response = {},
        sentRequestBody,
        statusesAJAXManagerResetSpy = this.sandbox.spy(JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager, "reset");

    this.sandbox.server.respondWith(AJS.contextPath() + "/rest/workflowDesigner/latest/workflows/statuses", [200, {}, ""]);
    this.sandbox.server.respond();

    deferred = this.workflowStatusesAJAXManager.createStatus({
        createGlobalTransition: true,
        description: "Description",
        name: "Status",
        statusCategoryId: "1",
        workflowName: "Workflow"
    });

    this.workflowDataReaderStub.returns(response);
    this.sandbox.server.respondWith(this.createStatusURL, [200, {}, "{}"]);
    this.sandbox.server.respond();

    sentRequestBody = JIRA.WorkflowDesigner.TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
    expectedRequestBody = {
        createGlobalTransition: "true",
        description: "Description",
        name: "Status",
        statusCategoryId: "1",
        workflowName: "Workflow"
    };
    deepEqual(sentRequestBody, expectedRequestBody, "The request body for create was correct.");

    equal(this.workflowDataReaderStub.callCount, 1, "The AJAX response was passed to WorkflowDataReader.read()");
    deepEqual(this.workflowDataReaderStub.args[0], [{}], "It was passed the correct arguments");

    equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    equal(statusesAJAXManagerResetSpy.callCount, 1, "StatusesAJAXManager.reset() was called");

    deferred.done(function (data) {
        ok(data === response, "It was resolved with the output of WorkflowDataReader.read()");
    });
});

test("createStatus() rejects the returned deferred on error", function () {
    var deferred;

    deferred = this.workflowStatusesAJAXManager.createStatus({
        description: "A plain old status.",
        name: "Status",
        workflowName: "Workflow"
    });

    this.sandbox.server.respondWith(this.createStatusURL, [400, {}, "No"]);
    this.sandbox.server.respond();

    equal(deferred.state(), "rejected", "The returned deferred was rejected");
    deferred.fail(function (errorMessage) {
        equal(errorMessage, "No", "It was rejected with the error message");
    });
});

test("removeStatus() resolves deferred result on success and has correct request body", function () {
    var deferred,
        expectedRequestBody,
        sentRequestBody;

    deferred = this.workflowStatusesAJAXManager.removeStatus({
        statusId: 100,
        workflowName: "Workflow"
    });

    this.sandbox.server.respondWith(AJS.contextPath() + "/rest/workflowDesigner/latest/workflows/statuses", [200, {}, ""]);
    this.sandbox.server.respond();

    expectedRequestBody = {
        statusId: "100",
        workflowName: "Workflow"
    };

    sentRequestBody = JIRA.WorkflowDesigner.TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
    deepEqual(sentRequestBody, expectedRequestBody, "The request body matches the arguments sent to identify a status for removal");

    equal(deferred.state(), "resolved", "The returned deferred was resolved.");
});

test("removeStatus() rejects the returned deferred on error", function () {
    var deferred;

    deferred = this.workflowStatusesAJAXManager.removeStatus({
        statusId: 100,
        workflowName: "Workflow"
    });

    JIRA.WorkflowDesigner.TestUtilities.respondWithErrorAndAssertRejected(
        deferred, "/rest/workflowDesigner/latest/workflows/statuses", this.sandbox.server);
});

test("updateStatus() resolves deferred result on success", function () {
    var actualRequestObject,
        deferred,
        expectedRequestObject;

    expectedRequestObject = {
        description: "New description!",
        name: "New Name",
        statusCategoryId: "1",
        statusId: "100",
        workflowName: "Workflow"
    };

    deferred = this.workflowStatusesAJAXManager.updateStatus({
        description: "New description!",
        name: "New Name",
        someUnknownParameter: true, // Shouldn't be sent
        statusCategoryId: "1",
        statusId: "100",
        workflowName: "Workflow"
    });

    this.sandbox.server.respondWith(AJS.contextPath() + "/rest/workflowDesigner/latest/workflows/statuses", [200, {}, ""]);
    this.sandbox.server.respond();

    actualRequestObject = JIRA.WorkflowDesigner.TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
    deepEqual(actualRequestObject, expectedRequestObject, "The request body for update was correct.");
    equal(deferred.state(), "resolved", "The returned deferred was resolved.");
});

test("updateStatus() rejects the returned deferred on error", function () {
    var deferred = this.workflowStatusesAJAXManager.updateStatus({
        transitionId: 100,
        name: "name",
        description: "description",
        workflowName: "Workflow"
    });

    JIRA.WorkflowDesigner.TestUtilities.respondWithErrorAndAssertRejected(
        deferred, "/rest/workflowDesigner/latest/workflows/statuses", this.sandbox.server);
});