(function () {
    var statusCategories;

    AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.StatusCategoriesAJAXManager");

    /**
     * Handles retrieving status categories via AJAX.
     *
     * @namespace
     * @extends JIRA.WorkflowDesigner.IO.AJAX.AJAXManager
     */
    JIRA.WorkflowDesigner.IO.AJAX.StatusCategoriesAJAXManager = _.extend({}, JIRA.WorkflowDesigner.IO.AJAX.AJAXManager,
        /** @lends JIRA.WorkflowDesigner.IO.AJAX.StatusCategoriesAJAXManager */
        {
            /**
             * Retrieve information about all status categories in the system.
             *
             * @return {jQuery.Deferred} A deferred that is resolved with status category data.
             */
            getStatusCategories: function () {
                var deferred = jQuery.Deferred(),
                    request;

                if (statusCategories) {
                    deferred.resolve(statusCategories);
                } else {
                    request = this._makeRequest({
                        dataType: "json",
                        url: AJS.contextPath() + "/rest/workflowDesigner/latest/statusCategories"
                    });

                    request.done(function (response) {
                        statusCategories = response;
                        deferred.resolve(statusCategories);
                    });

                    request.fail(function (response, status) {
                        deferred.reject(JIRA.WorkflowDesigner.IO.ErrorHandler.getErrorMessage(response, status));
                    });
                }

                return deferred.promise();
            },

            /**
             * Reset the manager, clearing its cache.
             */
            reset: function () {
                statusCategories = undefined;
            }
        });
}());