(function () {
    /**
     * Cache for screens
     *
     * @inner
     * @type {Object|undefined}
     */
    var screens;

    AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.ScreensAJAXManager");

    /**
     * Handles retrieving screens via AJAX.
     *
     * @namespace
     * @extends JIRA.WorkflowDesigner.IO.AJAX.AJAXManager
     */
    JIRA.WorkflowDesigner.IO.AJAX.ScreensAJAXManager = _.extend({}, JIRA.WorkflowDesigner.IO.AJAX.AJAXManager,
    /** @lends JIRA.WorkflowDesigner.IO.AJAX.ScreensAJAXManager */
    {
        /**
         * Retrieve information about all screens in the system.
         *
         * @return {jQuery.Deferred} A deferred that is resolved with screen data.
         */
        getScreens: function () {
            var deferred = jQuery.Deferred(),
                request;

            if (screens) {
                deferred.resolve(screens);
            } else {
                request = this._makeRequest({
                    dataType: "json",
                    url: AJS.contextPath() + "/rest/workflowDesigner/latest/screens"
                });

                request.done(function (response) {
                    screens = response;
                    deferred.resolve(screens);
                });

                request.fail(function (response, status) {
                    deferred.reject(JIRA.WorkflowDesigner.IO.ErrorHandler.getErrorMessage(response, status));
                });
            }

            return deferred.promise();
        },

        /**
         * Reset the manager, clearing its cache.
         */
        reset: function () {
            screens = undefined;
        }
    });
}());