AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.IO.LayoutAutoSaver",{createLayoutAutoSaver:function(){return new JIRA.WorkflowDesigner.IO.LayoutAutoSaver({window:this.window,workflowModel:this.workflowModel})},setup:function(){this.sandbox=sinon.sandbox.create();this.showErrorMessageStub=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage");this.saveStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager,"save");this.saveStub.returns(jQuery.Deferred().resolve());this.window={onbeforeunload:jQuery.noop};this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel()},teardown:function(){this.sandbox.restore()},triggerLayoutChangedEvent:function(){this.workflowModel.trigger("layoutChanged")}});test("Calls the error handler on failure",function(){JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function(A){this.createLayoutAutoSaver();this.saveStub.returns(jQuery.Deferred().reject());this.triggerLayoutChangedEvent();A.tick(1100);equal(this.showErrorMessageStub.callCount,1,"The error handler was called");equal(this.saveStub.callCount,1,"_save() was called")},this)});test("Saves when WorkflowModel triggers a layoutChanged event",function(){JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function(A){this.createLayoutAutoSaver();this.triggerLayoutChangedEvent();A.tick(1100);equal(this.showErrorMessageStub.callCount,0,"The error handler wasn't called");equal(this.saveStub.callCount,1,"_save() was called")},this)});test("Shows an 'unsaved changes' message",function(){JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function(A){var B;this.createLayoutAutoSaver();this.triggerLayoutChangedEvent();B=this.window.onbeforeunload;ok(jQuery.noop!==B&&_.isFunction(B),"window.onbeforeunload was set");A.tick(1100);equal(jQuery.noop,this.window.onbeforeunload,"The original window.onbeforeunload was restored")},this)});test("The 'unsaved changes' message is maintained through concurrent saves",function(){JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function(B){var A=jQuery.Deferred();this.createLayoutAutoSaver();this.saveStub.returns(A);this.triggerLayoutChangedEvent();B.tick(1100);equal(this.saveStub.callCount,1,"_save() was called");this.saveStub.returns(jQuery.Deferred().resolve());this.triggerLayoutChangedEvent();A.resolve();ok(jQuery.noop!==this.window.onbeforeunload,"The original window.onbeforeunload was not restored");B.tick(1100);equal(this.saveStub.callCount,2,"_save() was called");equal(jQuery.noop,this.window.onbeforeunload,"The original window.onbeforeunload was restored")},this)});test("The 'unsaved changes' message is not cleared if saving failed",function(){JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function(B){var A=jQuery.Deferred();this.saveStub.returns(A);this.createLayoutAutoSaver();this.triggerLayoutChangedEvent();B.tick(1100);A.reject();ok(jQuery.noop!==this.window.onbeforeunload,"The original window.onbeforeunload was not restored")},this)});test("Doesn't show an 'unsaved changes' message if it is disabled",function(){JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function(){JIRA.WorkflowDesigner.IO.LayoutAutoSaver.disableMessage();this.createLayoutAutoSaver();this.triggerLayoutChangedEvent();equal(jQuery.noop,this.window.onbeforeunload,"window.onbeforeunload was not set")},this)});test("destroy() removes the onbeforeunload handler",function(){var A;JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function(){A=this.createLayoutAutoSaver();this.saveStub.returns(jQuery.Deferred());this.triggerLayoutChangedEvent();A.destroy();equal(jQuery.noop,this.window.onbeforeunload,"The original window.onbeforeunload was restored");A=this.createLayoutAutoSaver();this.window.onbeforeunload=undefined;this.triggerLayoutChangedEvent();A.destroy();equal(undefined,this.window.onbeforeunload,"The original window.onbeforeunload was restored")},this)});