(function (Backbone) {
    /**
     * A collection of {@link JIRA.WorkflowDesigner.TransitionModel}s.
     *
     * @class JIRA.WorkflowDesigner.TransitionCollection
     * @extends Backbone.Collection
     */
    Backbone.define("JIRA.WorkflowDesigner.TransitionCollection", Backbone.Collection.extend(
    /** @lends JIRA.WorkflowDesigner.TransitionCollection# */
    {
        /**
         * The model class that the collection contains
         *
         * @param {object} attributes
         * @param {object} options
         * @returns {JIRA.WorkflowDesigner.TransitionModel}
         */
        model: function (attributes, options) {
            return new JIRA.WorkflowDesigner.TransitionModel(attributes, options);
        },

        /**
         * Returns the initial transition
         *
         * @returns {JIRA.WorkflowDesigner.TransitionModel} Initial transition
         */
        getInitial: function () {
            return this.find(function (transition) {
                return transition.isInitial();
            });
        }

    }));
}(JIRA.WorkflowDesigner.Backbone));