/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.util;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.web.bean.WorkflowConditionFormatBean;
import com.atlassian.jira.web.bean.WorkflowDescriptorInfo;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowAnnotationManager;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraAction;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraActionImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraCondition;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraConditionImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraConditions;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraConditionsImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraFunction;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraFunctionImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraResult;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraResultImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraStatusImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraStep;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraStepImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraValidator;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraValidatorImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraWorkflow;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraWorkflowImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexWorkflowObject;
import com.sysbliss.jira.plugins.workflow.model.WorkflowAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowConverter {
    private WorkflowConverter() {
    }

    public static FlexJiraWorkflow convertMinimalWorkflow(JiraWorkflow jiraWorkflow, WorkflowSchemeManager schemeManager) {
        FlexJiraWorkflowImpl fjw = new FlexJiraWorkflowImpl();
        fjw.setName(jiraWorkflow.getName());
        fjw.setDescription(jiraWorkflow.getDescription());
        fjw.setIsEditable(jiraWorkflow.isEditable());
        fjw.setHasDraftWorkflow(jiraWorkflow.hasDraftWorkflow());
        fjw.setIsActive(jiraWorkflow.isActive());
        fjw.setIsDraftWorkflow(jiraWorkflow.isDraftWorkflow());
        fjw.setIsSystemWorkflow(jiraWorkflow.isSystemWorkflow());
        fjw.setId(jiraWorkflow.getDescriptor().getId());
        fjw.setEntityId(jiraWorkflow.getDescriptor().getEntityId());
        boolean hasSchemes = false;
        Collection workflowSchemes = schemeManager.getSchemesForWorkflow(jiraWorkflow);
        if (workflowSchemes.size() > 0) {
            hasSchemes = true;
        }
        fjw.setHasSchemes(hasSchemes);
        return fjw;
    }

    public static FlexJiraWorkflow convertFullWorkflow(JiraWorkflow jiraWorkflow, WorkflowSchemeManager schemeManager, WorkflowAnnotationManager workflowAnnotationManager) {
        List<WorkflowAnnotation> annotations;
        FlexJiraWorkflow fjw = WorkflowConverter.convertMinimalWorkflow(jiraWorkflow, schemeManager);
        fjw.setInitialActions(WorkflowConverter.convertActions(jiraWorkflow.getDescriptor().getInitialActions()));
        fjw.setAllSteps(WorkflowConverter.convertSteps(jiraWorkflow.getDescriptor().getSteps(), jiraWorkflow));
        fjw.setUnlinkedStatuses(WorkflowConverter.convertUnlinkedStatuses(jiraWorkflow));
        fjw.setAllActions(WorkflowConverter.getAllActions(jiraWorkflow));
        fjw.setGlobalActions(WorkflowConverter.getGlobalActions(jiraWorkflow));
        try {
            annotations = workflowAnnotationManager.getAnnotationsForWorkflow(jiraWorkflow);
        }
        catch (Exception e) {
            annotations = new ArrayList<WorkflowAnnotation>();
        }
        fjw.setWorkflowAnnotations(annotations);
        fjw.setIsLoaded(true);
        return fjw;
    }

    private static List getAllActions(JiraWorkflow jiraWorkflow) {
        ArrayList<FlexJiraAction> allActions = new ArrayList<FlexJiraAction>();
        for (Object obj : jiraWorkflow.getAllActions()) {
            ActionDescriptor action = (ActionDescriptor)obj;
            allActions.add(WorkflowConverter.convertAction(action));
        }
        return allActions;
    }

    private static List getGlobalActions(JiraWorkflow jiraWorkflow) {
        ArrayList<FlexJiraAction> actions = new ArrayList<FlexJiraAction>();
        for (ActionDescriptor action : jiraWorkflow.getDescriptor().getGlobalActions()) {
            FlexJiraAction fjAction = WorkflowConverter.convertAction(action);
            actions.add(fjAction);
        }
        return actions;
    }

    private static List convertActions(List jiraActions) {
        ArrayList<FlexJiraAction> actions = new ArrayList<FlexJiraAction>();
        for (ActionDescriptor actionDescriptor : jiraActions) {
            FlexJiraAction action = WorkflowConverter.convertAction(actionDescriptor);
            actions.add(action);
        }
        return actions;
    }

    public static FlexJiraAction convertAction(ActionDescriptor actionDescriptor) {
        FlexJiraActionImpl action = new FlexJiraActionImpl();
        action.setId(actionDescriptor.getId());
        action.setEntityId(actionDescriptor.getEntityId());
        action.setName(actionDescriptor.getName());
        action.setLabel(actionDescriptor.getName() + " (" + actionDescriptor.getId() + ")");
        action.setIsCommon(actionDescriptor.isCommon());
        Map metaData = actionDescriptor.getMetaAttributes();
        String desc = (String)metaData.get("jira.description");
        action.setDescription(desc);
        FlexJiraResult unconditionalResult = WorkflowConverter.convertResult(actionDescriptor.getUnconditionalResult());
        action.setUnconditionalResult(unconditionalResult);
        action.setMetaAttributes(metaData);
        RestrictionDescriptor restriction = actionDescriptor.getRestriction();
        if (null != restriction) {
            action.setConditions(WorkflowConverter.convertConditions(actionDescriptor.getRestriction().getConditionsDescriptor()));
        }
        action.setView(actionDescriptor.getView());
        if (StringUtils.isNotBlank((String)actionDescriptor.getView())) {
            WorkflowActionsBean actionsBean = new WorkflowActionsBean();
            FieldScreen fieldScreen = actionsBean.getFieldScreenForView(actionDescriptor);
            action.setFieldScreenId(fieldScreen.getId().toString());
        } else {
            action.setFieldScreenId("");
        }
        action.setValidators(WorkflowConverter.convertValidators(actionDescriptor.getValidators()));
        return action;
    }

    private static FlexJiraResult convertResult(ResultDescriptor jiraResult) {
        FlexJiraResultImpl result = new FlexJiraResultImpl();
        result.setId(jiraResult.getId());
        result.setEntityId(jiraResult.getEntityId());
        result.setName(jiraResult.getDisplayName());
        result.setDescription("");
        result.setOldStatus(jiraResult.getOldStatus());
        result.setStatus(jiraResult.getStatus());
        result.setStepId(jiraResult.getStep());
        result.setPostFunctions(WorkflowConverter.convertFunctions(jiraResult.getPostFunctions()));
        return result;
    }

    private static List convertFunctions(List jiraFunctions) {
        ArrayList<FlexJiraFunction> functions = new ArrayList<FlexJiraFunction>();
        for (FunctionDescriptor functionDescriptor : jiraFunctions) {
            FlexJiraFunction function = WorkflowConverter.convertFunction(functionDescriptor);
            functions.add(function);
        }
        return functions;
    }

    private static FlexJiraFunction convertFunction(FunctionDescriptor jiraFunction) {
        FlexJiraFunctionImpl function = new FlexJiraFunctionImpl();
        function.setName(jiraFunction.getName());
        function.setType(jiraFunction.getType());
        function.setId(jiraFunction.getId());
        function.setEntityId(jiraFunction.getEntityId());
        function.setArgs(jiraFunction.getArgs());
        return function;
    }

    private static FlexJiraConditions convertConditions(ConditionsDescriptor jiraConditions) {
        FlexJiraConditionsImpl conditions = new FlexJiraConditionsImpl();
        if (null == jiraConditions) {
            return conditions;
        }
        conditions.setId(jiraConditions.getId());
        conditions.setType(jiraConditions.getType());
        ArrayList<FlexWorkflowObject> nestedConditions = new ArrayList<FlexWorkflowObject>();
        List nestedJiraConditions = jiraConditions.getConditions();
        for (Object o : nestedJiraConditions) {
            if (o instanceof ConditionDescriptor) {
                nestedConditions.add(WorkflowConverter.convertCondition((ConditionDescriptor)o));
                continue;
            }
            if (!(o instanceof ConditionsDescriptor)) continue;
            nestedConditions.add(WorkflowConverter.convertConditions((ConditionsDescriptor)o));
        }
        conditions.setConditions(nestedConditions);
        return conditions;
    }

    private static FlexJiraCondition convertCondition(ConditionDescriptor jiraCondition) {
        FlexJiraConditionImpl condition = new FlexJiraConditionImpl();
        condition.setId(jiraCondition.getId());
        condition.setEntityId(jiraCondition.getEntityId());
        condition.setName(jiraCondition.getName());
        condition.setType(jiraCondition.getType());
        condition.setArgs(jiraCondition.getArgs());
        WorkflowConditionFormatBean formatBean = new WorkflowConditionFormatBean();
        formatBean.setPluginType("workflow-condition");
        WorkflowDescriptorInfo info = formatBean.formatDescriptor((AbstractDescriptor)jiraCondition);
        condition.setDescription(info.getDescription());
        return condition;
    }

    private static List convertValidators(List jiraValidators) {
        ArrayList<FlexJiraValidator> validators = new ArrayList<FlexJiraValidator>();
        for (ValidatorDescriptor validatorDescriptor : jiraValidators) {
            FlexJiraValidator validator = WorkflowConverter.convertValidator(validatorDescriptor);
            validators.add(validator);
        }
        return validators;
    }

    private static FlexJiraValidator convertValidator(ValidatorDescriptor jiraValidator) {
        FlexJiraValidatorImpl validator = new FlexJiraValidatorImpl();
        validator.setName(jiraValidator.getName());
        validator.setType(jiraValidator.getType());
        validator.setId(jiraValidator.getId());
        validator.setEntityId(jiraValidator.getEntityId());
        validator.setArgs(jiraValidator.getArgs());
        return validator;
    }

    private static List convertSteps(List jiraSteps, JiraWorkflow jiraWorkflow) {
        ArrayList<FlexJiraStep> steps = new ArrayList<FlexJiraStep>();
        for (StepDescriptor stepDescriptor : jiraSteps) {
            FlexJiraStep step = WorkflowConverter.convertStep(stepDescriptor, jiraWorkflow);
            steps.add(step);
        }
        return steps;
    }

    public static FlexJiraStep convertStep(StepDescriptor jiraStep, JiraWorkflow jiraWorkflow) {
        FlexJiraStepImpl step = new FlexJiraStepImpl();
        step.setId(jiraStep.getId());
        step.setEntityId(jiraStep.getEntityId());
        step.setName(jiraStep.getName());
        step.setMetaAttributes(jiraStep.getMetaAttributes());
        Map metaData = jiraStep.getMetaAttributes();
        step.setLinkedStatus((String)metaData.get("jira.status.id"));
        List stepActions = WorkflowConverter.convertActions(jiraStep.getActions());
        step.setActions(stepActions);
        return step;
    }

    private static List convertUnlinkedStatuses(JiraWorkflow jiraWorkflow) {
        ArrayList<FlexJiraStatusImpl> ret = new ArrayList<FlexJiraStatusImpl>();
        ConstantsManager manager = ManagerFactory.getConstantsManager();
        ArrayList statusList = new ArrayList(manager.getStatusObjects());
        for (Status status : statusList) {
            GenericValue statusGV = status.getGenericValue();
            if (WorkflowConverter.isStatusLinked(statusGV, jiraWorkflow)) continue;
            FlexJiraStatusImpl fjs = new FlexJiraStatusImpl();
            fjs.setId(status.getId());
            fjs.setName(status.getName());
            fjs.setDescription(status.getDescription());
            fjs.setIconUrl(status.getIconUrl());
            ret.add(fjs);
        }
        return ret;
    }

    private static boolean isStatusLinked(GenericValue status, JiraWorkflow jiraWorkflow) {
        for (StepDescriptor stepDescriptor : jiraWorkflow.getDescriptor().getSteps()) {
            if (!status.getString("id").equals(stepDescriptor.getMetaAttributes().get("jira.status.id"))) continue;
            return true;
        }
        return false;
    }
}

