/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.service;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import com.sysbliss.jira.plugins.workflow.auth.UserTokenManager;
import com.sysbliss.jira.plugins.workflow.exception.FlexNoPermissionException;
import com.sysbliss.jira.plugins.workflow.exception.FlexNotLoggedInException;
import com.sysbliss.jira.plugins.workflow.exception.WorkflowDesignerServiceException;
import com.sysbliss.jira.plugins.workflow.manager.CachingWorkflowImageManagerImpl;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowAnnotationManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowImageManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraAction;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraDeleteActionRequest;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraDeleteRequest;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraFieldScreenImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraMetadataContainer;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraServerInfo;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraServerInfoImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraStatus;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraStatusImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraStep;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraUserPrefs;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraUserPrefsImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraWorkflow;
import com.sysbliss.jira.plugins.workflow.model.FlexJiraWorkflowImpl;
import com.sysbliss.jira.plugins.workflow.model.FlexWorkflowObject;
import com.sysbliss.jira.plugins.workflow.model.WorkflowAnnotation;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayout;
import com.sysbliss.jira.plugins.workflow.service.WorkflowDesignerService;
import com.sysbliss.jira.plugins.workflow.util.MetadataUtils;
import com.sysbliss.jira.plugins.workflow.util.StatusUtils;
import com.sysbliss.jira.plugins.workflow.util.WorkflowConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowDesignerServiceImpl
implements WorkflowDesignerService {
    private static Logger log = Logger.getLogger(WorkflowDesignerService.class);
    private final WorkflowManager workflowManager;
    private final WorkflowService workflowService;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final FieldScreenManager fieldScreenManager;
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final BuildUtilsInfo buildUtils;
    private final PluginAccessor pluginAccessor;
    private final WorkflowLayoutManager workflowLayoutManager;
    private final WorkflowImageManager workflowImageManager;
    private final WorkflowAnnotationManager workflowAnnotationManager;
    private final UserPropertyManager userPropertyManager;
    private final UserTokenManager userTokenManager;

    public WorkflowDesignerServiceImpl(WorkflowManager workflowManager, FieldScreenManager fieldScreenManager, PluginAccessor pluginAccessor, WorkflowService workflowService, WorkflowSchemeManager workflowSchemeManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, BuildUtilsInfo buildUtils, ConstantsManager constantsManager, WorkflowLayoutManager workflowLayoutManager, WorkflowImageManager workflowImageManager, WorkflowAnnotationManager workflowAnnotationManager, UserPropertyManager userPropertyManager, UserTokenManager userTokenManager) {
        this.workflowManager = workflowManager;
        this.workflowService = workflowService;
        this.workflowSchemeManager = workflowSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
        this.buildUtils = buildUtils;
        this.constantsManager = constantsManager;
        this.workflowLayoutManager = workflowLayoutManager;
        this.workflowImageManager = workflowImageManager;
        this.workflowAnnotationManager = workflowAnnotationManager;
        this.userPropertyManager = userPropertyManager;
        this.userTokenManager = userTokenManager;
    }

    @Override
    public String ping() {
        return "pingy";
    }

    @Override
    public String getUserSession() throws FlexNotLoggedInException {
        String token;
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (user == null) {
            throw new FlexNotLoggedInException("You must be logged into Jira to use this app.");
        }
        try {
            token = this.userTokenManager.createToken(user);
        }
        catch (Exception e) {
            throw new FlexNotLoggedInException("You must be logged into Jira to use this app.");
        }
        return token;
    }

    @Override
    public FlexJiraServerInfo getJiraServerInfo() {
        log.debug((Object)"getting server info");
        FlexJiraServerInfoImpl info = new FlexJiraServerInfoImpl();
        info.setIsEnterprise(true);
        info.setIsProfessional(false);
        info.setIsStandard(false);
        info.setVersion(this.buildUtils.getVersion());
        log.debug((Object)"returning server info");
        return info;
    }

    private void checkUser(String tokenToTest) throws FlexNotLoggedInException, FlexNoPermissionException {
        ApplicationUser user = StringUtils.isBlank((String)tokenToTest) ? this.jiraAuthenticationContext.getUser() : this.userTokenManager.getUserFromToken(tokenToTest);
        if (user == null) {
            throw new FlexNotLoggedInException("You must be logged into Jira to use this app.");
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            throw new FlexNoPermissionException("You must be an Administrator to use this app.");
        }
    }

    @Override
    public FlexJiraUserPrefs getUserPrefs(String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        this.checkUser(token);
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (user == null) {
            throw new WorkflowDesignerServiceException("You must be logged in.");
        }
        PropertySet pset = this.userPropertyManager.getPropertySet(user);
        Collection prefKeys = pset.getKeys("jira.meta.sysblissWD.");
        if (prefKeys.size() <= 0) {
            try {
                this.addDefaultUserPrefs(pset);
            }
            catch (Exception e) {
                throw new WorkflowDesignerServiceException(e);
            }
        }
        FlexJiraUserPrefsImpl prefs = new FlexJiraUserPrefsImpl();
        prefs.setUserKey(user.getKey());
        for (String prefKey : prefKeys) {
            String prefName = StringUtils.substringAfter((String)prefKey, (String)"jira.meta.sysblissWD.");
            if (prefName.equals("confirmDeleteSelection")) {
                prefs.setConfirmDeleteSelection(pset.getBoolean(prefKey));
                continue;
            }
            if (!prefName.equals("confirmDeleteWorkflow")) continue;
            prefs.setConfirmDeleteWorkflow(pset.getBoolean(prefKey));
        }
        return prefs;
    }

    void addDefaultUserPrefs(PropertySet props) {
        props.setBoolean("jira.meta.sysblissWD.confirmDeleteSelection", true);
        props.setBoolean("jira.meta.sysblissWD.confirmDeleteWorkflow", true);
    }

    @Override
    public List getWorkflows(String token) throws FlexNotLoggedInException, FlexNoPermissionException {
        this.checkUser(token);
        ArrayList<FlexJiraWorkflow> ret = new ArrayList<FlexJiraWorkflow>();
        for (JiraWorkflow jiraWorkflow : this.workflowManager.getWorkflows()) {
            FlexJiraWorkflow wfd = WorkflowConverter.convertMinimalWorkflow(jiraWorkflow, this.workflowSchemeManager);
            ret.add(wfd);
            JiraWorkflow draftWorkflow = this.workflowManager.getDraftWorkflow(jiraWorkflow.getName());
            if (draftWorkflow == null) continue;
            FlexJiraWorkflow dwfd = WorkflowConverter.convertMinimalWorkflow(draftWorkflow, this.workflowSchemeManager);
            ret.add(dwfd);
        }
        return ret;
    }

    @Override
    public FlexJiraWorkflow loadWorkflow(FlexJiraWorkflow fwd, String token) throws FlexNotLoggedInException, FlexNoPermissionException, WorkflowDesignerServiceException {
        this.checkUser(token);
        JiraWorkflow jiraWorkflow = this.getJiraWorkflow(fwd);
        FlexJiraWorkflow fjw = WorkflowConverter.convertFullWorkflow(jiraWorkflow, this.workflowSchemeManager, this.workflowAnnotationManager);
        return fjw;
    }

    @Override
    public List getAllStatuses(String token) throws FlexNotLoggedInException, FlexNoPermissionException {
        this.checkUser(token);
        ArrayList<FlexJiraStatusImpl> ret = new ArrayList<FlexJiraStatusImpl>();
        ArrayList statusList = new ArrayList(this.constantsManager.getStatusObjects());
        for (Status status : statusList) {
            FlexJiraStatusImpl fjs = new FlexJiraStatusImpl();
            fjs.setId(status.getId());
            fjs.setName(status.getName());
            fjs.setDescription(status.getDescription());
            fjs.setIconUrl(status.getIconUrl());
            fjs.setIsActive(StatusUtils.isActive(status.getGenericValue()));
            ret.add(fjs);
        }
        return ret;
    }

    @Override
    public FlexJiraStatus createNewStatus(String name, String desc, String iconUrl, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        GenericValue gv;
        this.checkUser(token);
        StatusUtils statusUtils = new StatusUtils();
        try {
            gv = statusUtils.addStatus(name, desc, iconUrl);
        }
        catch (GenericEntityException e) {
            throw new WorkflowDesignerServiceException(e);
        }
        FlexJiraStatusImpl fjs = new FlexJiraStatusImpl();
        fjs.setId(gv.getString("id"));
        fjs.setName(gv.getString("name"));
        fjs.setDescription(gv.getString("description"));
        fjs.setIconUrl(gv.getString("iconurl"));
        return fjs;
    }

    @Override
    public FlexJiraStatus deleteStatus(String id, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        GenericValue gv;
        this.checkUser(token);
        StatusUtils statusUtils = new StatusUtils();
        try {
            gv = statusUtils.deleteStatus(id);
        }
        catch (GenericEntityException e) {
            throw new WorkflowDesignerServiceException(e);
        }
        FlexJiraStatusImpl fjs = new FlexJiraStatusImpl();
        fjs.setId(gv.getString("id"));
        fjs.setName(gv.getString("name"));
        fjs.setDescription(gv.getString("description"));
        fjs.setIconUrl(gv.getString("iconurl"));
        return fjs;
    }

    @Override
    public FlexJiraStatus updateStatus(String id, String name, String desc, String iconUrl, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        GenericValue gv;
        this.checkUser(token);
        StatusUtils statusUtils = new StatusUtils();
        try {
            gv = statusUtils.updateStatus(id, name, desc, iconUrl);
        }
        catch (GenericEntityException e) {
            throw new WorkflowDesignerServiceException(e);
        }
        FlexJiraStatusImpl fjs = new FlexJiraStatusImpl();
        fjs.setId(gv.getString("id"));
        fjs.setName(gv.getString("name"));
        fjs.setDescription(gv.getString("description"));
        fjs.setIconUrl(gv.getString("iconurl"));
        return fjs;
    }

    @Override
    public List getFieldScreens(String token) throws FlexNotLoggedInException, FlexNoPermissionException {
        this.checkUser(token);
        ArrayList<FlexJiraFieldScreenImpl> ret = new ArrayList<FlexJiraFieldScreenImpl>();
        ArrayList screenList = new ArrayList(this.fieldScreenManager.getFieldScreens());
        for (FieldScreen screen : screenList) {
            FlexJiraFieldScreenImpl fjfs = new FlexJiraFieldScreenImpl();
            fjfs.setId(screen.getId().toString());
            fjfs.setName(screen.getName());
            ret.add(fjfs);
        }
        return ret;
    }

    @Override
    public FlexJiraWorkflow copyWorkflow(String newName, String newDesc, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraWorkflow newJiraWorkflow;
        this.checkUser(token);
        JiraWorkflow jw = this.getJiraWorkflow(fjw);
        try {
            newJiraWorkflow = this.workflowService.copyWorkflow(this.getJiraServiceContext(token), newName, newDesc, jw);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        return WorkflowConverter.convertFullWorkflow(newJiraWorkflow, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public FlexJiraWorkflow createDraftWorkflow(FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraWorkflow newJiraWorkflow;
        this.checkUser(token);
        try {
            newJiraWorkflow = this.workflowService.createDraftWorkflow(this.getJiraServiceContext(token), fjw.getName());
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        try {
            this.workflowLayoutManager.copyLayoutForDraftWorkflow(fjw.getName());
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Loading Saved Layout", e);
        }
        return WorkflowConverter.convertFullWorkflow(newJiraWorkflow, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public void deleteWorkflow(FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        this.checkUser(token);
        JiraWorkflow jw = this.getJiraWorkflow(fjw);
        if (jw.isDraftWorkflow()) {
            this.workflowManager.deleteDraftWorkflow(jw.getName());
            return;
        }
        if (jw.isEditable()) {
            Collection workflowSchemes = this.workflowSchemeManager.getSchemesForWorkflow(jw);
            if (workflowSchemes == null || workflowSchemes.isEmpty()) {
                this.workflowManager.deleteWorkflow(jw);
                return;
            }
            StringBuffer schemes = new StringBuffer();
            for (GenericValue schemeGV : workflowSchemes) {
                schemes.append('\'').append(schemeGV.getString("name")).append('\'').append(", ");
            }
            schemes.delete(schemes.length() - 2, schemes.length() - 1);
            throw new WorkflowDesignerServiceException(this.jiraAuthenticationContext.getI18nBean().getText("admin.errors.cannot.delete.this.workflow") + " " + schemes);
        }
    }

    @Override
    public FlexJiraWorkflow publishDraftWorkflow(FlexJiraWorkflow fjw, boolean enableBackup, String backupName, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        this.checkUser(token);
        try {
            if (enableBackup) {
                JiraWorkflow activeWorkflow = this.workflowService.getWorkflow(this.getJiraServiceContext(token), fjw.getName());
                this.workflowService.copyWorkflow(this.getJiraServiceContext(token), backupName, null, activeWorkflow);
            }
            JiraServiceContext context = this.getJiraServiceContext(token);
            this.workflowService.overwriteActiveWorkflow(context, fjw.getName());
            if (context.getErrorCollection().hasAnyErrors()) {
                Collection messages = context.getErrorCollection().getErrorMessages();
                Iterator it = messages.iterator();
                String msg = (String)it.next();
                throw new WorkflowDesignerServiceException(msg);
            }
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        JiraWorkflow parentWorkflow = this.workflowManager.getWorkflow(fjw.getName());
        return WorkflowConverter.convertFullWorkflow(parentWorkflow, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public FlexJiraWorkflow createNewWorkflow(String name, String desc, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        this.checkUser(token);
        ConfigurableJiraWorkflow newWorkflow = new ConfigurableJiraWorkflow(name, this.workflowManager);
        newWorkflow.setDescription(desc);
        try {
            this.workflowManager.createWorkflow(this.getJiraServiceContext(token).getLoggedInUser(), (JiraWorkflow)newWorkflow);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        JiraWorkflow jw = this.workflowManager.getWorkflow(name);
        return WorkflowConverter.convertFullWorkflow(jw, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public FlexJiraWorkflow addStep(FlexJiraStep fjs, FlexJiraWorkflow fjw, JWDLayout layout, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow jw = this.getJiraWorkflow(fjw);
        StepDescriptor newStep = DescriptorFactory.getFactory().createStepDescriptor();
        newStep.setName(fjs.getName());
        newStep.setId(WorkflowUtil.getNextId((List)jw.getDescriptor().getSteps()));
        newStep.getMetaAttributes().put("jira.status.id", fjs.getLinkedStatus());
        newStep.setParent((AbstractDescriptor)jw.getDescriptor());
        JiraWorkflow mutable = this.getMutableWorkflow(jw);
        mutable.getDescriptor().addStep(newStep);
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        try {
            this.saveLayout(mutable, layout);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Saving Layout", e);
        }
        return WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public Map addTransition(String name, String desc, String view, FlexJiraStep fjFromStep, FlexJiraStep fjToStep, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        StepDescriptor fromStep = mutable.getDescriptor().getStep(fjFromStep.getId());
        StepDescriptor toStep = mutable.getDescriptor().getStep(fjToStep.getId());
        ActionDescriptor action = DescriptorFactory.getFactory().createActionDescriptor();
        action.setId(mutable.getNextActionId());
        action.setName(name);
        action.getMetaAttributes().put("jira.description", desc);
        if (!StringUtils.isBlank((String)view)) {
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(new Long(view));
            action.setView("fieldscreen");
            action.getMetaAttributes().put("jira.fieldscreen.id", fieldScreen.getId().toString());
        } else {
            action.setView(null);
        }
        ResultDescriptor result = DescriptorFactory.getFactory().createResultDescriptor();
        action.setUnconditionalResult(result);
        result.setStep(toStep.getId());
        result.setOldStatus("Not Done");
        result.setStatus("Done");
        try {
            this.createDefaultPostFunctions(action);
            this.createDefaultRestriction(action);
        }
        catch (PluginParseException ppe) {
            throw new WorkflowDesignerServiceException(ppe);
        }
        action.setParent((AbstractDescriptor)fromStep);
        fromStep.getActions().add(action);
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        FlexJiraAction newAction = WorkflowConverter.convertAction(action);
        FlexJiraWorkflow newWorkflow = WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
        HashMap<String, FlexWorkflowObject> returnMap = new HashMap<String, FlexWorkflowObject>();
        returnMap.put("action", newAction);
        returnMap.put("workflow", newWorkflow);
        return returnMap;
    }

    @Override
    public Map addGlobalTransition(String name, String desc, int resultId, String view, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        ActionDescriptor action = DescriptorFactory.getFactory().createActionDescriptor();
        action.setId(mutable.getNextActionId());
        action.setName(name);
        action.getMetaAttributes().put("jira.description", desc);
        if (!StringUtils.isBlank((String)view)) {
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(new Long(view));
            action.setView("fieldscreen");
            action.getMetaAttributes().put("jira.fieldscreen.id", fieldScreen.getId().toString());
        } else {
            action.setView(null);
        }
        ResultDescriptor result = DescriptorFactory.getFactory().createResultDescriptor();
        action.setUnconditionalResult(result);
        result.setStep(resultId);
        result.setOldStatus("Not Done");
        result.setStatus("Done");
        try {
            this.createDefaultPostFunctions(action);
            this.createDefaultRestriction(action);
        }
        catch (PluginParseException ppe) {
            throw new WorkflowDesignerServiceException(ppe);
        }
        action.setParent((AbstractDescriptor)mutable.getDescriptor());
        mutable.getDescriptor().addGlobalAction(action);
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        FlexJiraAction newAction = WorkflowConverter.convertAction(action);
        FlexJiraWorkflow newWorkflow = WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
        HashMap<String, FlexWorkflowObject> returnMap = new HashMap<String, FlexWorkflowObject>();
        returnMap.put("action", newAction);
        returnMap.put("workflow", newWorkflow);
        return returnMap;
    }

    @Override
    public Map cloneTransition(String name, String desc, int actionIdToClone, FlexJiraStep fjFromStep, FlexJiraStep fjToStep, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        StepDescriptor fromStep = mutable.getDescriptor().getStep(fjFromStep.getId());
        StepDescriptor toStep = mutable.getDescriptor().getStep(fjToStep.getId());
        ActionDescriptor actionToCopy = mutable.getDescriptor().getAction(actionIdToClone);
        ActionDescriptor newAction = DescriptorFactory.getFactory().createActionDescriptor();
        newAction.setId(mutable.getNextActionId());
        newAction.setName(name);
        newAction.getMetaAttributes().put("jira.description", desc);
        String viewIdToCopy = (String)actionToCopy.getMetaAttributes().get("jira.fieldscreen.id");
        if (!StringUtils.isBlank((String)viewIdToCopy)) {
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(new Long(viewIdToCopy));
            newAction.setView("fieldscreen");
            newAction.getMetaAttributes().put("jira.fieldscreen.id", fieldScreen.getId().toString());
        } else {
            newAction.setView(null);
        }
        ResultDescriptor result = DescriptorFactory.getFactory().createResultDescriptor();
        newAction.setUnconditionalResult(result);
        result.setStep(toStep.getId());
        result.setOldStatus("Not Done");
        result.setStatus("Done");
        try {
            this.createDefaultRestriction(newAction);
            this.copyActionDetails(actionToCopy, newAction);
        }
        catch (PluginParseException ppe) {
            throw new WorkflowDesignerServiceException(ppe);
        }
        newAction.setParent((AbstractDescriptor)fromStep);
        fromStep.getActions().add(newAction);
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        FlexJiraAction flexAction = WorkflowConverter.convertAction(newAction);
        FlexJiraWorkflow newWorkflow = WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
        HashMap<String, FlexWorkflowObject> returnMap = new HashMap<String, FlexWorkflowObject>();
        returnMap.put("action", flexAction);
        returnMap.put("workflow", newWorkflow);
        return returnMap;
    }

    @Override
    public Map cloneGlobalTransition(String name, String desc, int actionIdToClone, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        ActionDescriptor actionToCopy = mutable.getDescriptor().getAction(actionIdToClone);
        ActionDescriptor newAction = DescriptorFactory.getFactory().createActionDescriptor();
        newAction.setId(mutable.getNextActionId());
        newAction.setName(name);
        newAction.getMetaAttributes().put("jira.description", desc);
        String viewIdToCopy = (String)actionToCopy.getMetaAttributes().get("jira.fieldscreen.id");
        if (!StringUtils.isBlank((String)viewIdToCopy)) {
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(new Long(viewIdToCopy));
            newAction.setView("fieldscreen");
            newAction.getMetaAttributes().put("jira.fieldscreen.id", fieldScreen.getId().toString());
        } else {
            newAction.setView(null);
        }
        ResultDescriptor result = DescriptorFactory.getFactory().createResultDescriptor();
        newAction.setUnconditionalResult(result);
        result.setStep(actionToCopy.getUnconditionalResult().getStep());
        result.setOldStatus("Not Done");
        result.setStatus("Done");
        try {
            this.createDefaultRestriction(newAction);
            this.copyActionDetails(actionToCopy, newAction);
        }
        catch (PluginParseException ppe) {
            throw new WorkflowDesignerServiceException(ppe);
        }
        newAction.setParent((AbstractDescriptor)mutable.getDescriptor());
        mutable.getDescriptor().addGlobalAction(newAction);
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        FlexJiraAction flexAction = WorkflowConverter.convertAction(newAction);
        FlexJiraWorkflow newWorkflow = WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
        HashMap<String, FlexWorkflowObject> returnMap = new HashMap<String, FlexWorkflowObject>();
        returnMap.put("action", flexAction);
        returnMap.put("workflow", newWorkflow);
        return returnMap;
    }

    @Override
    public Map useCommonTransition(int commonActionId, FlexJiraStep fjFromStep, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        StepDescriptor fromStep = mutable.getDescriptor().getStep(fjFromStep.getId());
        ActionDescriptor commonAction = mutable.getDescriptor().getAction(commonActionId);
        if (!commonAction.isCommon()) {
            StepDescriptor originalParent = (StepDescriptor)commonAction.getParent();
            originalParent.getActions().remove(commonAction);
            mutable.getDescriptor().addCommonAction(commonAction);
            commonAction.setParent((AbstractDescriptor)mutable.getDescriptor());
            originalParent.getActions().add(commonAction);
            originalParent.getCommonActions().add(commonAction.getId());
        }
        fromStep.getActions().add(commonAction);
        fromStep.getCommonActions().add(commonAction.getId());
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        FlexJiraAction flexAction = WorkflowConverter.convertAction(commonAction);
        FlexJiraWorkflow newWorkflow = WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
        HashMap<String, FlexWorkflowObject> returnMap = new HashMap<String, FlexWorkflowObject>();
        returnMap.put("action", flexAction);
        returnMap.put("workflow", newWorkflow);
        return returnMap;
    }

    @Override
    public FlexJiraWorkflow deleteGlobalAction(int actionId, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        ActionDescriptor action = mutable.getDescriptor().getAction(actionId);
        if (action != null && mutable.getDescriptor().getGlobalActions().contains(action)) {
            mutable.getDescriptor().removeAction(action);
        }
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        return WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    private void copyActionDetails(ActionDescriptor actionToCopy, ActionDescriptor newAction) {
        ConditionsDescriptor conditionsDescriptor;
        List preFunctions = actionToCopy.getUnconditionalResult().getPreFunctions();
        List postFunctions = actionToCopy.getUnconditionalResult().getPostFunctions();
        List validators = actionToCopy.getUnconditionalResult().getValidators();
        List conditions = Collections.emptyList();
        String type = "AND";
        RestrictionDescriptor restriction = actionToCopy.getRestriction();
        if (restriction != null && (conditionsDescriptor = restriction.getConditionsDescriptor()) != null) {
            conditions = conditionsDescriptor.getConditions();
            type = conditionsDescriptor.getType();
        }
        Map metaToCopy = actionToCopy.getMetaAttributes();
        for (FunctionDescriptor preFunction : preFunctions) {
            newAction.getUnconditionalResult().getPreFunctions().add(preFunction);
        }
        for (FunctionDescriptor postFunction : postFunctions) {
            newAction.getUnconditionalResult().getPostFunctions().add(postFunction);
        }
        for (ValidatorDescriptor validator : validators) {
            newAction.getUnconditionalResult().getValidators().add(validator);
        }
        newAction.getRestriction().getConditionsDescriptor().setType(type);
        if (conditions.size() > 0) {
            for (ConditionDescriptor condition : conditions) {
                newAction.getRestriction().getConditionsDescriptor().getConditions().add(condition);
            }
        }
        for (Map.Entry entry : metaToCopy.entrySet()) {
            newAction.getMetaAttributes().put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public FlexJiraWorkflow updateStep(FlexJiraStep fjs, String newName, String newStatus, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        StepDescriptor jiraStep = mutable.getDescriptor().getStep(fjs.getId());
        jiraStep.setName(newName);
        jiraStep.getMetaAttributes().put("jira.status.id", newStatus);
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        return WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public FlexJiraWorkflow updateAction(FlexJiraAction fja, String newName, String newDesc, FlexJiraStep newDestStep, String newView, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        ActionDescriptor jiraAction = mutable.getDescriptor().getAction(fja.getId());
        StepDescriptor jiraDestStep = mutable.getDescriptor().getStep(newDestStep.getId());
        jiraAction.setName(newName);
        jiraAction.getMetaAttributes().put("jira.description", newDesc);
        if (!StringUtils.isBlank((String)newView)) {
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(new Long(newView));
            jiraAction.setView("fieldscreen");
            jiraAction.getMetaAttributes().put("jira.fieldscreen.id", fieldScreen.getId().toString());
        } else {
            jiraAction.setView(null);
        }
        ResultDescriptor result = jiraAction.getUnconditionalResult();
        result.setStep(jiraDestStep.getId());
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        return WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public FlexJiraWorkflow updateGlobalAction(FlexJiraAction fja, String newName, String newDesc, int newDestStepId, String newView, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        ActionDescriptor jiraAction = mutable.getDescriptor().getAction(fja.getId());
        jiraAction.setName(newName);
        jiraAction.getMetaAttributes().put("jira.description", newDesc);
        if (!StringUtils.isBlank((String)newView)) {
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(new Long(newView));
            jiraAction.setView("fieldscreen");
            jiraAction.getMetaAttributes().put("jira.fieldscreen.id", fieldScreen.getId().toString());
        } else {
            jiraAction.setView(null);
        }
        ResultDescriptor result = jiraAction.getUnconditionalResult();
        result.setStep(newDestStepId);
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator it = messages.iterator();
            String msg = (String)it.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        return WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public FlexJiraWorkflow deleteStepsAndActions(FlexJiraDeleteRequest deleteRequest, FlexJiraWorkflow fjw, JWDLayout layout, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow jiraWorkflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(jiraWorkflow);
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        ArrayList jiraStepsToDelete = new ArrayList();
        CollectionUtils.collect((Collection)deleteRequest.getSteps(), (Transformer)new FlexToJiraStepTransformer(mutable), jiraStepsToDelete);
        this.deleteActions(deleteRequest.getActionRequests(), mutable);
        this.deleteSteps(jiraStepsToDelete, mutable);
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator mit = messages.iterator();
            String msg = (String)mit.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        try {
            this.saveLayout(mutable, layout);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Saving Layout", e);
        }
        return WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    private void deleteSteps(List steps, JiraWorkflow workflow) {
        for (StepDescriptor step : steps) {
            for (ActionDescriptor action : workflow.getActionsWithResult(step)) {
                log.debug((Object)("step is result of " + action.getName() + "(" + action.getId() + ")"));
            }
            workflow.removeStep(step);
        }
    }

    private void deleteActions(List actionRequests, JiraWorkflow workflow) {
        for (FlexJiraDeleteActionRequest actionRequest : actionRequests) {
            FlexJiraAction fja = actionRequest.getAction();
            FlexJiraStep fjs = actionRequest.getStep();
            ActionDescriptor action = workflow.getDescriptor().getAction(fja.getId());
            StepDescriptor step = workflow.getDescriptor().getStep(fjs.getId());
            step.getActions().remove(action);
            if (action.isCommon()) {
                step.getCommonActions().remove(new Integer(action.getId()));
                if (workflow.getStepsForTransition(action).isEmpty()) {
                    workflow.getDescriptor().getCommonActions().remove(action.getId());
                }
            }
            if (!step.getActions().isEmpty() || !step.getCommonActions().isEmpty()) continue;
            step.removeActions();
        }
    }

    private void createDefaultPostFunctions(ActionDescriptor actionDescriptor) throws PluginParseException {
        ResultDescriptor unconditionalResult = actionDescriptor.getUnconditionalResult();
        List postFunctions = unconditionalResult.getPostFunctions();
        TreeMap<Integer, FunctionDescriptor> functionsToAdd = new TreeMap<Integer, FunctionDescriptor>();
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByType("workflow-function");
        for (WorkflowFunctionModuleDescriptor workflowFunctionModuleDescriptor : moduleDescriptors) {
            if (!workflowFunctionModuleDescriptor.isDefault()) continue;
            FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
            functionDescriptor.setType("class");
            WorkflowPluginFunctionFactory functionFactory = (WorkflowPluginFunctionFactory)workflowFunctionModuleDescriptor.getModule();
            functionDescriptor.getArgs().put("class.name", workflowFunctionModuleDescriptor.getImplementationClass().getName());
            functionDescriptor.getArgs().putAll(functionFactory.getDescriptorParams(Collections.EMPTY_MAP));
            if (workflowFunctionModuleDescriptor.getWeight() != null) {
                functionsToAdd.put(workflowFunctionModuleDescriptor.getWeight(), functionDescriptor);
                continue;
            }
            functionsToAdd.put(Integer.MAX_VALUE, functionDescriptor);
        }
        for (Map.Entry entry : functionsToAdd.entrySet()) {
            postFunctions.add(entry.getValue());
        }
    }

    private void createDefaultRestriction(ActionDescriptor actionDescriptor) {
        RestrictionDescriptor restriction = new RestrictionDescriptor();
        ConditionsDescriptor conditionsDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor();
        restriction.setConditionsDescriptor(conditionsDescriptor);
        actionDescriptor.setRestriction(restriction);
    }

    @Override
    public FlexJiraWorkflow updateProperties(FlexJiraMetadataContainer mdc, Map metadata, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        boolean isAction = false;
        if (mdc instanceof FlexJiraAction) {
            isAction = true;
        }
        if (!isAction) {
            StepDescriptor jiraStep = mutable.getDescriptor().getStep(((FlexWorkflowObject)((Object)mdc)).getId());
            Map jiraMD = jiraStep.getMetaAttributes();
            this.updateMetadata(jiraMD, metadata, mutable);
        } else {
            ActionDescriptor jiraAction = mutable.getDescriptor().getAction(((FlexWorkflowObject)((Object)mdc)).getId());
            Map jiraMD = jiraAction.getMetaAttributes();
            this.updateMetadata(jiraMD, metadata, mutable);
        }
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator mit = messages.iterator();
            String msg = (String)mit.next();
            throw new WorkflowDesignerServiceException(msg);
        }
        return WorkflowConverter.convertFullWorkflow(mutable, this.workflowSchemeManager, this.workflowAnnotationManager);
    }

    @Override
    public void updateIssueEditable(FlexJiraStep fjs, Boolean editable, FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNotLoggedInException, FlexNoPermissionException {
        JiraServiceContext context;
        this.checkUser(token);
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        StepDescriptor jiraStep = mutable.getDescriptor().getStep(fjs.getId());
        Map jiraMD = jiraStep.getMetaAttributes();
        jiraMD.put("jira.issue.editable", Boolean.toString(editable));
        try {
            context = this.getJiraServiceContext(token);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException(e);
        }
        this.workflowService.updateWorkflow(context, mutable);
        if (context.getErrorCollection().hasAnyErrors()) {
            Collection messages = context.getErrorCollection().getErrorMessages();
            Iterator mit = messages.iterator();
            String msg = (String)mit.next();
            throw new WorkflowDesignerServiceException(msg);
        }
    }

    private void updateMetadata(Map jiraMD, Map flexMD, JiraWorkflow workflow) throws WorkflowDesignerServiceException {
        Set entries = flexMD.entrySet();
        for (Map.Entry entry : entries) {
            String flexKey = (String)entry.getKey();
            String flexValue = (String)entry.getValue();
            if (MetadataUtils.isReservedKey(flexKey)) {
                throw new WorkflowDesignerServiceException(this.jiraAuthenticationContext.getI18nBean().getText("admin.errors.workflows.attribute.key.has.reserved.prefix", "'jira.'"));
            }
            SimpleErrorCollection ec = new SimpleErrorCollection();
            WorkflowUtil.checkInvalidCharacters((String)flexKey, (String)"attributeKey", (ErrorCollection)ec);
            WorkflowUtil.checkInvalidCharacters((String)flexValue, (String)"attributeValue", (ErrorCollection)ec);
            if (ec.hasAnyErrors()) {
                Map errors = ec.getErrors();
                StringBuffer errorBuffer = new StringBuffer("");
                if (!errors.entrySet().isEmpty()) {
                    for (Map.Entry error : errors.entrySet()) {
                        errorBuffer.append(error.getValue());
                        errorBuffer.append(",");
                    }
                }
                throw new WorkflowDesignerServiceException(errorBuffer.toString());
            }
            jiraMD.put(flexKey, flexValue);
        }
        Iterator jit = jiraMD.keySet().iterator();
        while (jit.hasNext()) {
            String jiraKey = (String)jit.next();
            if (flexMD.containsKey(jiraKey) || MetadataUtils.isReservedKey(jiraKey)) continue;
            jit.remove();
        }
    }

    private JiraWorkflow getJiraWorkflow(FlexJiraWorkflow fjw) {
        JiraWorkflow jiraWorkflow = fjw.getIsDraftWorkflow() ? this.workflowManager.getDraftWorkflow(fjw.getName()) : this.workflowManager.getWorkflow(fjw.getName());
        return jiraWorkflow;
    }

    private JiraWorkflow getMutableWorkflow(JiraWorkflow jw) {
        JiraWorkflow jiraWorkflow = jw.isDraftWorkflow() ? jw : this.workflowManager.getWorkflowClone(jw.getName());
        return jiraWorkflow;
    }

    protected JiraServiceContext getJiraServiceContext(String token) throws Exception {
        ApplicationUser user = this.userTokenManager.getUserFromToken(token);
        return new JiraServiceContextImpl(user);
    }

    @Override
    public JWDLayout loadLayout(FlexJiraWorkflow fjw, String token) throws WorkflowDesignerServiceException, FlexNoPermissionException, FlexNotLoggedInException {
        JWDLayout returnLayout;
        this.checkUser(token);
        try {
            JiraWorkflow jiraWorkflow = this.getJiraWorkflow(fjw);
            returnLayout = this.workflowLayoutManager.getLayoutForWorkflow(jiraWorkflow);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Loading Saved Layout", e);
        }
        return returnLayout;
    }

    @Override
    public JWDLayout calculateLayout(JWDLayout jwdLayout) {
        FlexJiraWorkflowImpl fjw = new FlexJiraWorkflowImpl();
        fjw.setName(jwdLayout.getWorkflowName());
        fjw.setIsDraftWorkflow(jwdLayout.getIsDraftWorkflow());
        JiraWorkflow workflow = this.getJiraWorkflow(fjw);
        return this.workflowLayoutManager.calculateLayout(workflow, jwdLayout);
    }

    @Override
    public void saveActiveLayout(String name, JWDLayout layout, String token) throws WorkflowDesignerServiceException, FlexNoPermissionException, FlexNotLoggedInException {
        this.checkUser(token);
        try {
            this.workflowLayoutManager.saveActiveLayout(name, layout);
            this.clearImageCache(name);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Saving Layout", e);
        }
    }

    @Override
    public void saveDraftLayout(String name, JWDLayout layout, String token) throws WorkflowDesignerServiceException, FlexNoPermissionException, FlexNotLoggedInException {
        this.checkUser(token);
        try {
            this.workflowLayoutManager.saveDraftLayout(name, layout);
            this.clearImageCache(name);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Saving Layout", e);
        }
    }

    @Override
    public void addAnnotationToWorkflow(FlexJiraWorkflow fjw, WorkflowAnnotation annotation, JWDLayout layout, String token) throws WorkflowDesignerServiceException, FlexNoPermissionException, FlexNotLoggedInException {
        this.checkUser(token);
        JiraWorkflow jiraWorkflow = this.getJiraWorkflow(fjw);
        try {
            this.workflowAnnotationManager.addAnnotationToWorkflow(jiraWorkflow, annotation);
            this.saveLayout(jiraWorkflow, layout);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Saving Annotation", e);
        }
    }

    @Override
    public void removeAnnotationFromWorkflow(FlexJiraWorkflow fjw, WorkflowAnnotation annotation, JWDLayout layout, String token) throws WorkflowDesignerServiceException, FlexNoPermissionException, FlexNotLoggedInException {
        this.checkUser(token);
        JiraWorkflow jiraWorkflow = this.getJiraWorkflow(fjw);
        try {
            this.workflowAnnotationManager.removeAnnotationFromWorkflow(jiraWorkflow, annotation);
            this.saveLayout(jiraWorkflow, layout);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Removing Annotation", e);
        }
    }

    @Override
    public void updateAnnotationForWorkflow(FlexJiraWorkflow fjw, WorkflowAnnotation annotation, JWDLayout layout, String token) throws WorkflowDesignerServiceException, FlexNoPermissionException, FlexNotLoggedInException {
        this.checkUser(token);
        JiraWorkflow jiraWorkflow = this.getJiraWorkflow(fjw);
        try {
            this.workflowAnnotationManager.updateAnnotationForWorkflow(jiraWorkflow, annotation);
            this.saveLayout(jiraWorkflow, layout);
        }
        catch (Exception e) {
            throw new WorkflowDesignerServiceException("Error Updating Annotation", e);
        }
    }

    protected void saveLayout(JiraWorkflow workflow, JWDLayout layout) throws Exception {
        if (workflow.isDraftWorkflow()) {
            this.workflowLayoutManager.saveDraftLayout(workflow.getName(), layout);
        } else {
            this.workflowLayoutManager.saveActiveLayout(workflow.getName(), layout);
        }
        this.clearImageCache(workflow.getName());
    }

    protected void clearImageCache(String workflowName) {
        if (this.workflowImageManager instanceof CachingWorkflowImageManagerImpl) {
            ((CachingWorkflowImageManagerImpl)this.workflowImageManager).clearCacheForWorkflow(workflowName);
        }
    }

    protected class FlexToJiraStepTransformer
    implements Transformer {
        private final JiraWorkflow _jiraWorkflow;

        public FlexToJiraStepTransformer(JiraWorkflow jw) {
            this._jiraWorkflow = jw;
        }

        public Object transform(Object input) {
            FlexJiraStep fjs = (FlexJiraStep)input;
            return this._jiraWorkflow.getDescriptor().getStep(fjs.getId());
        }
    }

    protected class IdPredicate
    implements Predicate {
        private final int _id;

        public IdPredicate(int id) {
            this._id = id;
        }

        public boolean evaluate(Object object) {
            return ((FlexWorkflowObject)object).getId() == this._id;
        }
    }
}

