/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.manager;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.layout.Layout;
import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutSerializationException;
import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutSerializer;
import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutUpdater;
import com.atlassian.jira.plugins.workflowdesigner.layout.LegacyLayoutConverter;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionLoopExpander;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflows.layout.persistence.WorkflowLayoutPropertyKeyBuilder;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import com.sysbliss.jira.plugins.workflow.jgraph.JGraphxJWDLayoutProcessor;
import com.sysbliss.jira.plugins.workflow.jgraph.JWDLayoutMerger;
import com.sysbliss.jira.plugins.workflow.jgraph.WorkflowToJWDLayout;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowGlobalTransitionManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutRectImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.JSONLayoutDeserializer;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.JSONLayoutSerializer;
import com.sysbliss.jira.plugins.workflow.util.WorkflowDesignerPropertySet;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class WorkflowLayoutManagerImpl
implements WorkflowLayoutManager {
    private final TransitionLoopExpander loopExpander;
    private final WorkflowDesignerPropertySet workflowDesignerPropertySet;
    private final LegacyLayoutConverter legacyLayoutConverter;
    private final LayoutSerializer layoutSerializer;
    private final LayoutUpdater layoutUpdater;
    private final WorkflowGlobalTransitionManager globalTransitionManager;
    private final Workflows workflows;

    public WorkflowLayoutManagerImpl(TransitionLoopExpander loopExpander, WorkflowDesignerPropertySet workflowDesignerPropertySet, LegacyLayoutConverter legacyLayoutConverter, LayoutSerializer layoutSerializer, LayoutUpdater layoutUpdater, WorkflowGlobalTransitionManager globalTransitionManager, Workflows workflows) {
        this.loopExpander = loopExpander;
        this.workflowDesignerPropertySet = workflowDesignerPropertySet;
        this.legacyLayoutConverter = legacyLayoutConverter;
        this.layoutSerializer = layoutSerializer;
        this.layoutUpdater = layoutUpdater;
        this.globalTransitionManager = globalTransitionManager;
        this.workflows = workflows;
    }

    @Override
    public void saveActiveLayout(String workflowName, JWDLayout layout) throws Exception {
        this.saveLayout(this.getWorkflowPropertyKey(false, workflowName), layout);
    }

    @Override
    public void removeActiveLayout(String workflowName) {
        this.removeLayout(this.getWorkflowPropertyKey(false, workflowName));
    }

    @Override
    public JWDLayout loadSavedActiveLayout(String workflowName) throws Exception {
        return this.loadSavedLayout(this.getWorkflowPropertyKey(false, workflowName));
    }

    @Override
    public void saveDraftLayout(String parentWorkflowName, JWDLayout layout) throws Exception {
        this.saveLayout(this.getWorkflowPropertyKey(true, parentWorkflowName), layout);
    }

    @Override
    public void removeDraftLayout(String parentWorkflowName) {
        this.removeLayout(this.getWorkflowPropertyKey(true, parentWorkflowName));
    }

    @Override
    public JWDLayout loadSavedDraftLayout(String parentWorkflowName) throws Exception {
        return this.loadSavedLayout(this.getWorkflowPropertyKey(true, parentWorkflowName));
    }

    @Override
    public JWDLayout copyLayoutForDraftWorkflow(String parentWorkflowName) throws Exception {
        String originalPropKey = this.getWorkflowPropertyKey(false, parentWorkflowName);
        String originalJson = this.workflowDesignerPropertySet.getProperty(originalPropKey);
        JWDLayout jwdLayout = new JWDLayoutImpl();
        if (StringUtils.isNotBlank((String)originalJson)) {
            JSONLayoutDeserializer deserializer = new JSONLayoutDeserializer();
            jwdLayout = deserializer.deserialize(originalJson);
            this.saveLayout(this.getWorkflowPropertyKey(true, parentWorkflowName), jwdLayout);
        }
        return jwdLayout;
    }

    @Override
    public void copyActiveLayout(String originalWorkflowName, String newWorkflowName) throws Exception {
        String originalPropKey = this.getWorkflowPropertyKey(false, originalWorkflowName);
        String newPropKey = this.getWorkflowPropertyKey(false, newWorkflowName);
        JWDLayout originalLayout = this.loadSavedLayout(originalPropKey);
        if (originalLayout.getRoots().size() > 0) {
            this.saveLayout(newPropKey, originalLayout);
        } else if ("jira".equals(originalWorkflowName)) {
            try {
                InputStream layoutJSON = this.getClass().getClassLoader().getResourceAsStream("layouts/default-layout.json");
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)layoutJSON, (Writer)writer);
                JSONLayoutDeserializer deserializer = new JSONLayoutDeserializer();
                JWDLayout defaultLayout = deserializer.deserialize(writer.toString());
                this.saveLayout(newPropKey, defaultLayout);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public void publishDraftLayout(String parentWorkflowName) throws Exception {
        JWDLayout draftLayout = this.loadSavedDraftLayout(parentWorkflowName);
        if (draftLayout.getRoots().size() > 0) {
            this.saveActiveLayout(parentWorkflowName, draftLayout);
        }
    }

    @Override
    public JWDLayout getLayoutForWorkflow(JiraWorkflow workflow) throws Exception {
        JWDLayout finalLayout;
        JWDLayout jwdLayout = WorkflowToJWDLayout.transform(workflow);
        List<NodeLayout> roots = jwdLayout.getRoots();
        Map<String, Object> processedLayout = JGraphxJWDLayoutProcessor.calculateLayout(roots, workflow);
        List autoRoots = (List)processedLayout.get("roots");
        mxGraph graph = (mxGraph)processedLayout.get("graph");
        JWDLayout savedLayout = workflow.isDraftWorkflow() ? this.loadSavedDraftLayout(workflow.getName()) : this.loadSavedActiveLayout(workflow.getName());
        if (savedLayout.getRoots().size() < 1 && workflow.isDefault() && "jira".equals(workflow.getName())) {
            InputStream layoutJSON = this.getClass().getClassLoader().getResourceAsStream("layouts/default-layout.json");
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)layoutJSON, (Writer)writer);
            JSONLayoutDeserializer deserializer = new JSONLayoutDeserializer();
            savedLayout = deserializer.deserialize(writer.toString());
        }
        if (savedLayout.getRoots().size() > 0) {
            jwdLayout.setRoots(autoRoots);
            finalLayout = JWDLayoutMerger.mergeLayouts(savedLayout, jwdLayout);
        } else {
            finalLayout = new JWDLayoutImpl();
            finalLayout.setRoots(autoRoots);
        }
        mxRectangle gb = graph.getGraphBounds();
        LayoutRectImpl gBounds = new LayoutRectImpl();
        gBounds.setX(gb.getX());
        gBounds.setY(gb.getY());
        gBounds.setWidth(gb.getWidth());
        gBounds.setHeight(gb.getHeight());
        finalLayout.setGraphBounds(gBounds);
        return finalLayout;
    }

    @Override
    public JWDLayout calculateLayout(JiraWorkflow jiraWorkflow, JWDLayout jwdLayout) {
        JWDLayoutImpl newJWDLayout = new JWDLayoutImpl();
        Map<String, Object> processedLayout = JGraphxJWDLayoutProcessor.calculateLayout(jwdLayout.getRoots(), jiraWorkflow);
        List autoRoots = (List)processedLayout.get("roots");
        newJWDLayout.setRoots(autoRoots);
        mxGraph graph = (mxGraph)processedLayout.get("graph");
        mxRectangle gb = graph.getGraphBounds();
        LayoutRectImpl gBounds = new LayoutRectImpl();
        gBounds.setX(gb.getX());
        gBounds.setY(gb.getY());
        gBounds.setWidth(gb.getWidth());
        gBounds.setHeight(gb.getHeight());
        newJWDLayout.setGraphBounds(gBounds);
        return newJWDLayout;
    }

    protected void saveLayout(String propKey, JWDLayout layout) throws Exception {
        JSONLayoutSerializer serializer = new JSONLayoutSerializer();
        String json = serializer.serialize(layout);
        this.workflowDesignerPropertySet.setProperty(propKey, json);
    }

    protected void removeLayout(String propKey) {
        if (this.workflowDesignerPropertySet.hasProperty(propKey)) {
            this.workflowDesignerPropertySet.removeProperty(propKey);
        }
    }

    protected JWDLayout loadSavedLayout(String propKey) throws Exception {
        String json = this.workflowDesignerPropertySet.getProperty(propKey);
        if (StringUtils.isBlank((String)json)) {
            JWDLayoutImpl jwdLayout = new JWDLayoutImpl();
            jwdLayout.setWidth(0);
            jwdLayout.setRoots(Collections.<NodeLayout>emptyList());
            return jwdLayout;
        }
        return this.deserializeOldLayout(json);
    }

    private JWDLayout deserializeOldLayout(String json) throws Exception {
        JSONLayoutDeserializer deserializer = new JSONLayoutDeserializer();
        return deserializer.deserialize(json);
    }

    @Override
    public Layout getNewLayoutOrCreate(boolean isDraft, String workflowName) throws LayoutSerializationException {
        Layout layout = this.getNewLayout(isDraft, workflowName);
        if (layout == null) {
            return this.generateNewLayout(isDraft, workflowName);
        }
        return this.updateExistingLayout(isDraft, workflowName, layout);
    }

    private Layout generateNewLayout(boolean isDraft, String workflowName) throws LayoutSerializationException {
        Workflow workflow = this.getWorkflow(isDraft, workflowName);
        ServiceOutcome<Workflow> result = this.loopExpander.expandLoopsUpdatingDraftAndReturningModifiedWorkflow(workflow);
        if (result.isValid()) {
            workflow = (Workflow)result.getReturnedValue();
        }
        JWDLayout oldLayout = this.getOldLayout(isDraft, workflowName);
        Layout layout = this.legacyLayoutConverter.convert(workflow, oldLayout);
        this.globalTransitionManager.updateLayoutWithLatestGlobalTransitions(layout, this.getWorkflow(isDraft, workflowName));
        this.saveNewLayout(workflowName, isDraft, layout);
        return layout;
    }

    private Layout getNewLayout(boolean isDraft, String workflowName) throws LayoutSerializationException {
        String json = this.getLayoutJson(isDraft, workflowName);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        return this.layoutSerializer.deserializeFromJson(json);
    }

    private Layout updateExistingLayout(boolean isDraft, String workflowName, Layout existingLayout) throws LayoutSerializationException {
        LayoutUpdater.UpdateResult updateResult = this.updateLayoutWithDataFromWorkflow(existingLayout, isDraft, workflowName);
        boolean globalTransitionsUpdated = this.globalTransitionManager.updateLayoutWithLatestGlobalTransitions(updateResult.getUpdatedLayout(), this.getWorkflow(isDraft, workflowName));
        if (updateResult.isChanged() || globalTransitionsUpdated) {
            Layout updatedLayout = updateResult.getUpdatedLayout();
            this.saveNewLayout(workflowName, isDraft, updatedLayout);
            return updatedLayout;
        }
        return existingLayout;
    }

    private LayoutUpdater.UpdateResult updateLayoutWithDataFromWorkflow(Layout layout, boolean isDraft, String workflowName) {
        Workflow workflow = this.workflows.getWorkflow(isDraft, workflowName);
        ServiceOutcome<Workflow> result = this.loopExpander.expandLoopsUpdatingDraftAndReturningModifiedWorkflow(workflow);
        if (result.isValid()) {
            workflow = (Workflow)result.getReturnedValue();
        }
        return this.layoutUpdater.updateLayoutWithDataFromWorkflow(layout, workflow);
    }

    private JWDLayout getOldLayout(boolean isDraft, String workflowName) {
        Workflow workflow = this.getWorkflow(isDraft, workflowName);
        try {
            return this.getLayoutForWorkflow(workflow);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Workflow getWorkflow(boolean isDraft, String workflowName) {
        return this.workflows.getWorkflow(isDraft, workflowName);
    }

    @Override
    public void saveNewLayout(String workflowName, boolean isDraft, Layout layout) throws LayoutSerializationException {
        String propertyKey = this.getWorkflowPropertyKey(isDraft, workflowName, true);
        String json = this.layoutSerializer.serializeToJson(layout);
        this.workflowDesignerPropertySet.setProperty(propertyKey, json);
    }

    @Override
    public void copyNewLayoutForDraftWorkflow(String workflowName) {
        this.copyLayoutBetweenModes(false, true, workflowName);
    }

    @Override
    public void publishNewDraftLayout(String workflowName) {
        this.copyLayoutBetweenModes(true, false, workflowName);
    }

    private void copyLayoutBetweenModes(boolean fromMode, boolean toMode, String workflowName) {
        String json = this.getLayoutJson(fromMode, workflowName);
        if (StringUtils.isNotBlank((String)json)) {
            String toKey = this.getWorkflowPropertyKey(toMode, workflowName, true);
            this.workflowDesignerPropertySet.setProperty(toKey, json);
        }
    }

    @Override
    public void removeNewDraftLayout(String workflowName) {
        this.removeLayout(this.getWorkflowPropertyKey(true, workflowName, true));
    }

    @Override
    public void removeNewActiveLayout(String workflowName) {
        this.removeLayout(this.getWorkflowPropertyKey(false, workflowName, true));
    }

    @Override
    public void copyNewActiveLayout(String sourceWorkflowName, String targetWorkflowName) {
        String json = this.getLayoutJson(false, sourceWorkflowName);
        if (StringUtils.isNotBlank((String)json)) {
            String toKey = this.getWorkflowPropertyKey(false, targetWorkflowName, true);
            this.workflowDesignerPropertySet.setProperty(toKey, json);
        }
    }

    @Override
    public void moveActiveLayout(String sourceWorkflowName, String targetWorkflowName) {
        this.renameLayout(sourceWorkflowName, targetWorkflowName, false);
    }

    @Override
    public void moveNewActiveLayout(String sourceWorkflowName, String targetWorkflowName) {
        this.renameLayout(sourceWorkflowName, targetWorkflowName, true);
    }

    private void renameLayout(String sourceWorkflowName, String targetWorkflowName, boolean version2) {
        String oldKey = this.getWorkflowPropertyKey(false, sourceWorkflowName, version2);
        if (this.workflowDesignerPropertySet.hasProperty(oldKey)) {
            String layout = this.workflowDesignerPropertySet.getProperty(oldKey);
            String newKey = this.getWorkflowPropertyKey(false, targetWorkflowName, version2);
            this.workflowDesignerPropertySet.setProperty(newKey, layout);
            this.workflowDesignerPropertySet.removeProperty(oldKey);
        }
    }

    private String getLayoutJson(boolean isDraft, String workflowName) {
        String propertyKey = this.getWorkflowPropertyKey(isDraft, workflowName, true);
        return this.workflowDesignerPropertySet.getProperty(propertyKey);
    }

    private String getWorkflowPropertyKey(boolean isDraft, String workflowName) {
        return this.getWorkflowPropertyKey(isDraft, workflowName, false);
    }

    private String getWorkflowPropertyKey(boolean isDraft, String workflowName, boolean version2) {
        WorkflowLayoutPropertyKeyBuilder.WorkflowState state = isDraft ? WorkflowLayoutPropertyKeyBuilder.WorkflowState.DRAFT : WorkflowLayoutPropertyKeyBuilder.WorkflowState.LIVE;
        return WorkflowLayoutPropertyKeyBuilder.newBuilder().setWorkflowName(workflowName).setWorkflowState(state).setVersion2(version2).build();
    }
}

