/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.manager;

import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.png.mxPngEncodeParam;
import com.mxgraph.util.png.mxPngImageEncoder;
import com.mxgraph.view.mxGraph;
import com.sysbliss.jira.plugins.workflow.jgraph.WorkflowToJGraphxTransformer;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowImageManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowImageParams;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowThumbnailParams;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTextFieldUI;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class WorkflowImageManagerImpl
implements WorkflowImageManager {
    public static Logger log = Logger.getLogger(WorkflowImageManagerImpl.class);
    public static int MAX_WIDTH = 3000;
    public static int MAX_HEIGHT = 3000;
    public static int MIN_WIDTH = 20;
    public static int MIN_HEIGHT = 20;
    private WorkflowLayoutManager workflowLayoutManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowImageManagerImpl(WorkflowLayoutManager workflowLayoutManager) {
        this.workflowLayoutManager = workflowLayoutManager;
        System.setProperty("java.awt.headless", "true");
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(null);
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            UIManager.put("JTextField", MetalTextFieldUI.class.getName());
        }
        catch (Exception e) {
            log.error((Object)"Error loading MetalLookAndFeel in headless mode!", (Throwable)e);
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public BufferedImage getThumbnailImage(WorkflowThumbnailParams params) throws Exception {
        double scaleX;
        if (params.getWidth() > MAX_WIDTH) {
            throw new IllegalArgumentException("width must be <= " + MAX_WIDTH);
        }
        if (params.getHeight() > MAX_HEIGHT) {
            throw new IllegalArgumentException("height must be <= " + MAX_HEIGHT);
        }
        if (params.getWidth() < MIN_WIDTH) {
            throw new IllegalArgumentException("width must be >= " + MIN_WIDTH);
        }
        if (params.getHeight() < MIN_HEIGHT) {
            throw new IllegalArgumentException("height must be >= " + MIN_HEIGHT);
        }
        WorkflowToJGraphxTransformer transformer = new WorkflowToJGraphxTransformer(this.workflowLayoutManager);
        mxGraph graph = transformer.transform(params.getWorkflow(), params.getStepId(), params.showLabels());
        mxRectangle graphBounds = graph.getGraphBounds();
        graph.getGraphBounds().grow(10.0);
        BufferedImage image = mxCellRenderer.createBufferedImage(graph, null, 1.0, Color.WHITE, true, graphBounds);
        double xScale = (double)params.getWidth() / graphBounds.getWidth();
        double yScale = (double)params.getHeight() / graphBounds.getHeight();
        double scaleY = scaleX = Math.min(xScale, yScale);
        int scaledWidth = (int)Math.ceil(graphBounds.getWidth() * scaleX);
        int scaledHeight = (int)Math.ceil(graphBounds.getHeight() * scaleY);
        BufferedImage scaledImage = mxUtils.createBufferedImage(scaledWidth, scaledHeight, Color.WHITE);
        AffineTransform xform = null;
        Graphics2D graphics2D = scaledImage.createGraphics();
        if ((double)scaledWidth < graphBounds.getWidth() && (double)scaledHeight < graphBounds.getHeight()) {
            xform = AffineTransform.getScaleInstance(scaleX, scaleY);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawImage(image, xform, null);
        graphics2D.dispose();
        BufferedImage finalImage = scaledImage;
        if (!params.maintainAspect()) {
            finalImage = mxUtils.createBufferedImage(params.getWidth(), params.getHeight(), Color.WHITE);
            Graphics2D g = finalImage.createGraphics();
            g.drawImage(scaledImage, null, 0, 0);
        }
        return finalImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getThumbnailStream(WorkflowThumbnailParams params) throws Exception {
        ByteArrayInputStream is = null;
        BufferedImage finalImage = this.getThumbnailImage(params);
        mxPngEncodeParam param = mxPngEncodeParam.getDefaultEncodeParam(finalImage);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            mxPngImageEncoder encoder = new mxPngImageEncoder(outputStream, param);
            encoder.encode(finalImage);
            is = new ByteArrayInputStream(outputStream.toByteArray());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return is;
    }

    @Override
    public BufferedImage getFullImage(WorkflowImageParams params) throws Exception {
        WorkflowToJGraphxTransformer transformer = new WorkflowToJGraphxTransformer(this.workflowLayoutManager);
        mxGraph graph = transformer.transform(params.getWorkflow(), params.getStepId(), params.showLabels());
        mxRectangle graphBounds = graph.getGraphBounds();
        graph.getGraphBounds().grow(10.0);
        return mxCellRenderer.createBufferedImage(graph, null, 1.0, Color.WHITE, true, graphBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getFullImageStream(WorkflowImageParams params) throws Exception {
        ByteArrayInputStream is = null;
        BufferedImage image = this.getFullImage(params);
        mxPngEncodeParam param = mxPngEncodeParam.getDefaultEncodeParam(image);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            mxPngImageEncoder encoder = new mxPngImageEncoder(outputStream, param);
            encoder.encode(image);
            is = new ByteArrayInputStream(outputStream.toByteArray());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return is;
    }
}

