/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.manager;

import com.atlassian.jira.plugins.workflowdesigner.layout.Layout;
import com.atlassian.jira.plugins.workflowdesigner.layout.Transition;
import com.atlassian.jira.plugins.workflowdesigner.layout.Transitions;
import com.atlassian.jira.plugins.workflowdesigner.utilities.ActionDescriptorTransitionData;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowGlobalTransitionManager;
import com.sysbliss.jira.plugins.workflow.util.WorkflowStatusUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WorkflowGlobalTransitionManagerImpl
implements WorkflowGlobalTransitionManager {
    @Override
    public boolean updateLayoutWithLatestGlobalTransitions(Layout layout, JiraWorkflow workflow) {
        Set<Transition> latestGlobalTransitions;
        boolean isUpdated = false;
        Set<Transition> currentGlobalTransitions = layout.getGlobalTransitions();
        if (!currentGlobalTransitions.equals(latestGlobalTransitions = this.getGlobalTransitionsForWorkflow(layout, workflow))) {
            this.removeAllGlobalTransitionsFromLayout(layout);
            this.addAllGlobalTransitionsToLayout(layout, latestGlobalTransitions);
            isUpdated = true;
        }
        return isUpdated;
    }

    @Override
    public void removeAllGlobalTransitionsFromLayout(Layout layout) {
        HashSet allTransitions = Sets.newHashSet(layout.getTransitions());
        Iterables.removeIf((Iterable)allTransitions, (Predicate)new Predicate<Transition>(){

            public boolean apply(Transition input) {
                return input.isGlobalTransition();
            }
        });
        layout.setTransitions(allTransitions);
    }

    public Set<Transition> getGlobalTransitionsForWorkflow(Layout layout, JiraWorkflow workflow) {
        List globalTransitionDescriptors = workflow.getDescriptor().getGlobalActions();
        HashSet<Transition> globalTransitions = new HashSet<Transition>(globalTransitionDescriptors.size());
        for (ActionDescriptor descriptor : globalTransitionDescriptors) {
            StepDescriptor statusAfterTransition = workflow.getDescriptor().getStep(descriptor.getUnconditionalResult().getStep());
            if (statusAfterTransition == null) continue;
            String targetId = WorkflowStatusUtils.findStatusId(layout, statusAfterTransition.getId());
            ActionDescriptorTransitionData data = new ActionDescriptorTransitionData(descriptor);
            Transition globalTransition = Transitions.create(data, targetId, targetId);
            globalTransition.setGlobalTransition(true);
            globalTransitions.add(globalTransition);
        }
        return globalTransitions;
    }

    public void addAllGlobalTransitionsToLayout(Layout layout, Set<Transition> globalTransitions) {
        for (Transition globalTransition : globalTransitions) {
            layout.addTransition(globalTransition);
        }
    }
}

