/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.manager;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.mxgraph.util.png.mxPngEncodeParam;
import com.mxgraph.util.png.mxPngImageEncoder;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowImageManager;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowImageParams;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowThumbnailParams;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class CachingWorkflowImageManagerImpl
implements WorkflowImageManager {
    public static Logger log = Logger.getLogger(CachingWorkflowImageManagerImpl.class);
    public static String BASE_CACHE_FOLDER = "workflowimages";
    private WorkflowImageManager delegateImageManager;
    private JiraHome jiraHome;

    public CachingWorkflowImageManagerImpl(WorkflowImageManager delegateImageManager, JiraHome jiraHome) {
        this.delegateImageManager = delegateImageManager;
        this.jiraHome = jiraHome;
    }

    @Override
    public BufferedImage getThumbnailImage(WorkflowThumbnailParams params) throws Exception {
        String widthName = Integer.toString(params.getWidth());
        String heightName = Integer.toString(params.getHeight());
        BufferedImage image = null;
        image = this.cacheHasValidImage(params.getWorkflow(), params.getStepId(), widthName, heightName, params.showLabels(), params.maintainAspect()) ? ImageIO.read(this.getCacheFile(params.getWorkflow(), params.getStepId(), widthName, heightName, params.showLabels(), params.maintainAspect())) : this.delegateImageManager.getThumbnailImage(params);
        return image;
    }

    @Override
    public BufferedImage getFullImage(WorkflowImageParams params) throws Exception {
        BufferedImage image = null;
        image = this.cacheHasValidImage(params.getWorkflow(), params.getStepId(), "full", "full", params.showLabels(), true) ? ImageIO.read(this.getCacheFile(params.getWorkflow(), params.getStepId(), "full", "full", params.showLabels(), true)) : this.delegateImageManager.getFullImage(params);
        return image;
    }

    @Override
    public InputStream getThumbnailStream(WorkflowThumbnailParams params) throws Exception {
        BufferedImage image;
        String widthName = Integer.toString(params.getWidth());
        String heightName = Integer.toString(params.getHeight());
        InputStream is = this.getStreamFromCache(params.getWorkflow(), params.getStepId(), widthName, heightName, params.showLabels(), params.maintainAspect());
        if (is == null && (image = this.delegateImageManager.getThumbnailImage(params)) != null) {
            File cacheFile = this.addImageToCache(image, params.getWorkflow(), params.getStepId(), widthName, heightName, params.showLabels(), params.maintainAspect());
            try {
                is = new FileInputStream(cacheFile);
            }
            catch (Exception e) {
                log.error((Object)"Workflow Thumbnail File Missing!", (Throwable)e);
            }
        }
        return is;
    }

    @Override
    public InputStream getFullImageStream(WorkflowImageParams params) throws Exception {
        BufferedImage image;
        String widthName = "full";
        String heightName = "full";
        InputStream is = this.getStreamFromCache(params.getWorkflow(), params.getStepId(), widthName, heightName, params.showLabels(), true);
        if (is == null && (image = this.delegateImageManager.getFullImage(params)) != null) {
            File cacheFile = this.addImageToCache(image, params.getWorkflow(), params.getStepId(), widthName, heightName, params.showLabels(), true);
            try {
                is = new FileInputStream(cacheFile);
            }
            catch (Exception e) {
                log.error((Object)"Workflow Thumbnail File Missing!", (Throwable)e);
            }
        }
        return is;
    }

    public InputStream getStreamFromCache(JiraWorkflow workflow, int stepId, String width, String height, boolean showLabels, boolean maintainAspect) {
        FileInputStream is = null;
        if (this.cacheHasValidImage(workflow, stepId, width, height, showLabels, maintainAspect)) {
            File file = this.getCacheFile(workflow, stepId, width, height, showLabels, maintainAspect);
            try {
                is = new FileInputStream(file);
            }
            catch (Exception e) {
                log.error((Object)"Workflow Thumbnail File Missing!", (Throwable)e);
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File addImageToCache(BufferedImage image, JiraWorkflow workflow, int stepId, String width, String height, boolean showLabels, boolean maintainAspect) throws Exception {
        File file = this.getCacheFile(workflow, stepId, width, height, showLabels, maintainAspect);
        File baseDir = new File(file.getParent());
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        mxPngEncodeParam param = mxPngEncodeParam.getDefaultEncodeParam(image);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            mxPngImageEncoder encoder = new mxPngImageEncoder(outputStream, param);
            encoder.encode(image);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return file;
    }

    public boolean cacheHasValidImage(JiraWorkflow workflow, int stepId, String width, String height, boolean showLabels, boolean maintainAspect) {
        boolean cacheIsValid = false;
        File file = this.getCacheFile(workflow, stepId, width, height, showLabels, maintainAspect);
        if (file.exists()) {
            Date workflowUpdated = workflow.getUpdatedDate();
            Date imageUpdated = new Date(file.lastModified());
            if (workflow.isDefault() || workflowUpdated != null && !imageUpdated.before(workflowUpdated)) {
                cacheIsValid = true;
            }
        }
        return cacheIsValid;
    }

    public File getCacheFile(JiraWorkflow workflow, int stepId, String width, String height, boolean showLabels, boolean maintainAspect) {
        return new File(this.getCacheFolder(workflow), this.createFilename(workflow, stepId, width, height, showLabels, maintainAspect));
    }

    public File getCacheFolder(JiraWorkflow workflow) {
        return this.getCacheFolder(workflow.getName());
    }

    public File getCacheFolder(String workflowName) {
        String folderName = workflowName.replaceAll("[:\\\\/*?|<> _]", "-");
        File baseFolder = new File(this.jiraHome.getCachesDirectory(), BASE_CACHE_FOLDER);
        return new File(baseFolder, folderName);
    }

    public void clearCacheForWorkflow(JiraWorkflow workflow) {
        this.clearCacheForWorkflow(workflow.getName());
    }

    public void clearCacheForWorkflow(String workflowName) {
        File cacheFolder = this.getCacheFolder(workflowName);
        if (cacheFolder.exists() && cacheFolder.canWrite()) {
            try {
                FileUtils.cleanDirectory((File)cacheFolder);
            }
            catch (IOException e) {
                log.error((Object)"Unable to remove cached workflow images", (Throwable)e);
            }
        }
    }

    public String createFilename(JiraWorkflow workflow, int stepId, String width, String height, boolean showLabels, boolean maintainAspect) {
        StringBuffer buff = new StringBuffer();
        if (workflow.isDraftWorkflow()) {
            buff.append("D");
        }
        if (stepId > -1) {
            buff.append("S").append(Integer.toString(stepId));
        }
        buff.append("W").append(width).append("H").append(height);
        if (showLabels) {
            buff.append("L1");
        } else {
            buff.append("L0");
        }
        if (maintainAspect) {
            buff.append("A1");
        } else {
            buff.append("A0");
        }
        buff.append(".png");
        return buff.toString().replaceAll("[:\\\\/*?|<> _]", "-");
    }
}

