/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.jgraph;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxIMarker;
import com.mxgraph.shape.mxMarkerRegistry;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Polygon;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class JGraphxWorkflowStyles {
    public static mxEdgeStyle.mxEdgeStyleFunction JIRA_EDGE_LOOP = new mxEdgeStyle.mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            if (source != null) {
                mxGraphView view = state.getView();
                mxGraph graph = view.getGraph();
                mxRectangle startRect = source.getBoundingBox();
                mxPoint startPoint = new mxPoint(startRect.getCenterX(), startRect.getCenterY());
                mxPoint endPoint = new mxPoint(startPoint.getX(), startPoint.getY());
                mxPoint p1 = new mxPoint(startPoint.getX() - (startPoint.getX() - startRect.getX() + 15.0), startPoint.getY());
                mxPoint p2 = new mxPoint(p1.getX(), startPoint.getY() + startRect.getHeight() + 15.0);
                mxPoint p3 = new mxPoint(endPoint.getX(), p2.getY());
                result.add(p1);
                result.add(p2);
                result.add(p3);
            }
        }
    };
    public static final String KEY_LAYER = "JIRALAYER";
    public static final Map<String, Object> STYLE_LAYER = JGraphxWorkflowStyles.initLayerStyle();
    public static final String KEY_JIRA_STEP = "JIRASTEP";
    public static final Map<String, Object> STYLE_JIRA_STEP = JGraphxWorkflowStyles.initJiraStepStyle();
    public static final String KEY_JIRA_STEP_SELECTED = "SELECTEDJIRASTEP";
    public static final Map<String, Object> STYLE_JIRA_STEP_SELECTED = JGraphxWorkflowStyles.initJiraStepSelectedStyle();
    public static final String KEY_JIRA_ACTION = "JIRAACTION";
    public static final Map<String, Object> STYLE_JIRA_ACTION = JGraphxWorkflowStyles.initJiraActionStyle();
    public static final String KEY_JIRA_ARROW_STYLE = "JIRAARROW";

    private static Map<String, Object> initLayerStyle() {
        Hashtable<String, Object> layerStyle = new Hashtable<String, Object>();
        layerStyle.put(mxConstants.STYLE_SHAPE, "rectangle");
        layerStyle.put(mxConstants.STYLE_OPACITY, 0);
        return layerStyle;
    }

    private static Map<String, Object> initJiraStepSelectedStyle() {
        HashMap<String, Object> stepStyle = new HashMap<String, Object>();
        stepStyle.put(mxConstants.STYLE_SHAPE, "label");
        stepStyle.put(mxConstants.STYLE_OPACITY, 100);
        stepStyle.put(mxConstants.STYLE_FONTCOLOR, "#111111");
        stepStyle.put(mxConstants.STYLE_FONTSIZE, "14");
        stepStyle.put(mxConstants.STYLE_FONTSTYLE, 1);
        stepStyle.put(mxConstants.STYLE_FONTFAMILY, "Arial,FreeSans,Helvetica,sans-serif,_sans");
        stepStyle.put(mxConstants.STYLE_ROUNDED, "true");
        stepStyle.put(mxConstants.STYLE_FILLCOLOR, "#ffff99");
        stepStyle.put(mxConstants.STYLE_STROKECOLOR, "#bbbbbb");
        stepStyle.put(mxConstants.STYLE_STROKEWIDTH, "1");
        stepStyle.put(mxConstants.STYLE_SPACING_TOP, "-5");
        stepStyle.put(mxConstants.STYLE_SPACING_BOTTOM, "-5");
        stepStyle.put(mxConstants.STYLE_SPACING_LEFT, "18");
        stepStyle.put(mxConstants.STYLE_SPACING_RIGHT, "2");
        stepStyle.put(mxConstants.STYLE_IMAGE_WIDTH, 27);
        stepStyle.put(mxConstants.STYLE_IMAGE_HEIGHT, 35);
        stepStyle.put(mxConstants.STYLE_IMAGE_ALIGN, "left");
        return stepStyle;
    }

    private static Map<String, Object> initJiraStepStyle() {
        HashMap<String, Object> stepStyle = new HashMap<String, Object>();
        stepStyle.put(mxConstants.STYLE_SHAPE, "label");
        stepStyle.put(mxConstants.STYLE_OPACITY, 100);
        stepStyle.put(mxConstants.STYLE_FONTCOLOR, "#000000");
        stepStyle.put(mxConstants.STYLE_FONTSIZE, "12");
        stepStyle.put(mxConstants.STYLE_FONTSTYLE, 1);
        stepStyle.put(mxConstants.STYLE_FONTFAMILY, "Arial,FreeSans,Helvetica,sans-serif,_sans");
        stepStyle.put(mxConstants.STYLE_ROUNDED, "true");
        stepStyle.put(mxConstants.STYLE_FILLCOLOR, "#f0f0f0");
        stepStyle.put(mxConstants.STYLE_STROKECOLOR, "#bbbbbb");
        stepStyle.put(mxConstants.STYLE_STROKEWIDTH, "1");
        stepStyle.put(mxConstants.STYLE_SPACING_TOP, "-5");
        stepStyle.put(mxConstants.STYLE_SPACING_BOTTOM, "-5");
        stepStyle.put(mxConstants.STYLE_SPACING_LEFT, "18");
        stepStyle.put(mxConstants.STYLE_SPACING_RIGHT, "2");
        stepStyle.put(mxConstants.STYLE_IMAGE_WIDTH, 27);
        stepStyle.put(mxConstants.STYLE_IMAGE_HEIGHT, 35);
        stepStyle.put(mxConstants.STYLE_IMAGE_ALIGN, "left");
        return stepStyle;
    }

    private static Map<String, Object> initJiraActionStyle() {
        HashMap<String, Object> edgeStyle = new HashMap<String, Object>();
        edgeStyle.put(mxConstants.STYLE_FONTCOLOR, "#003366");
        edgeStyle.put(mxConstants.STYLE_FONTSIZE, "11");
        edgeStyle.put(mxConstants.STYLE_FONTFAMILY, "Arial,FreeSans,Helvetica,sans-serif,_sans");
        edgeStyle.put(mxConstants.STYLE_EDGE, mxConstants.STYLE_NOEDGESTYLE);
        edgeStyle.put(mxConstants.STYLE_STROKECOLOR, "#BBBBBB");
        edgeStyle.put(mxConstants.STYLE_STROKEWIDTH, "1");
        edgeStyle.put(mxConstants.STYLE_ENDARROW, KEY_JIRA_ARROW_STYLE);
        edgeStyle.put(mxConstants.STYLE_ENDSIZE, "7");
        edgeStyle.put(mxConstants.STYLE_LABEL_BACKGROUNDCOLOR, "#D0DFEE");
        edgeStyle.put(mxConstants.STYLE_LABEL_BORDERCOLOR, "#3c78b5");
        edgeStyle.put("loopEdgeStyle", JIRA_EDGE_LOOP);
        return edgeStyle;
    }

    static {
        mxIMarker tmp = new mxIMarker(){

            @Override
            @Deprecated
            public mxPoint paintMarker(mxGraphics2DCanvas canvas, mxCellState state, String type, mxPoint pe, double nx, double ny, double size) {
                return this.paintMarker(canvas, pe, nx, ny);
            }

            public mxPoint paintMarker(mxGraphics2DCanvas canvas, mxPoint pe, double nx, double ny) {
                Polygon poly = new Polygon();
                poly.addPoint((int)Math.round(pe.getX()), (int)Math.round(pe.getY()));
                poly.addPoint((int)Math.round(pe.getX() - nx * 2.0 - ny / 2.0), (int)Math.round(pe.getY() - ny * 2.0 + nx / 2.0));
                poly.addPoint((int)Math.round(pe.getX() + ny / 2.0 - nx * 2.0), (int)Math.round(pe.getY() - ny * 2.0 - nx / 2.0));
                canvas.fillShape(poly);
                canvas.getGraphics().draw(poly);
                return new mxPoint(-nx, -ny);
            }
        };
        mxMarkerRegistry.registerMarker(KEY_JIRA_ARROW_STYLE, tmp);
    }
}

