/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflowdesigner.utilities.ActionDescriptorTransitionData;
import com.atlassian.jira.plugins.workflowdesigner.utilities.WorkflowFunctionUtilities;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class Workflow
implements JiraWorkflow {
    public static final String SCREEN_ID_KEY = "jira.fieldscreen.id";
    public static final String WORKFLOW_EDITING_LIMITATIONS_ANCHOR_TAG_OPEN = "<a target=\"_blank\" href=\"https://confluence.atlassian.com/display/JIRA/Configuring+Workflow#ConfiguringWorkflow-Limitationswheneditinganactiveworkflow\">";
    public static final String ANCHOR_TAG_CLOSE = "</a>";
    private static final Logger LOG = Logger.getLogger(Workflow.class);
    private static final Function<StepDescriptor, Integer> GET_STEP_ID = new Function<StepDescriptor, Integer>(){

        public Integer apply(StepDescriptor step) {
            return step.getId();
        }
    };
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final JiraWorkflow jiraWorkflow;
    private final WorkflowFunctionUtilities workflowFunctionUtilities;
    private final WorkflowService workflowService;

    public Workflow(JiraWorkflow workflow, WorkflowFunctionUtilities workflowFunctionUtilities, WorkflowService workflowService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraWorkflow = workflow;
        this.workflowFunctionUtilities = workflowFunctionUtilities;
        this.workflowService = workflowService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public ServiceOutcome<Workflow> addStatus(Status status) {
        try {
            StepDescriptor step = this.makeStepDescriptor(status);
            this.jiraWorkflow.getDescriptor().addStep(step);
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)"addStatus - exception occurred when adding status", (Throwable)e);
            return Outcomes.errorOutcome("workflow.designer.add.status.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> removeStatus(Status status) {
        try {
            StepDescriptor stepToDelete = this.findStepInWorkflowWithStatusId(status.getId());
            this.removeOutboundTransitions(stepToDelete);
            this.removeInboundTransitions(stepToDelete);
            this.jiraWorkflow.removeStep(stepToDelete);
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)"removeStatus() - exception removing status", (Throwable)e);
            return Outcomes.errorOutcome("workflow.designer.remove.status.error", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> updateStatus(String statusId, String name) {
        try {
            StepDescriptor step = this.findStepInWorkflowWithStatusId(statusId);
            step.setName(name);
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)"updateStatus() - exception updating status", (Throwable)e);
            return Outcomes.errorOutcome("workflow.designer.update.status.error", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> addGlobalTransition(String name, String description, Status status, FieldScreen screen) {
        StepDescriptor targetStep = this.findStepInWorkflowWithStatusId(status.getId());
        return this.addGlobalTransition(targetStep, name, description, screen);
    }

    public ServiceOutcome<Workflow> updateGlobalTransition(int transitionId, String name, String description, FieldScreen screen) {
        return this.updateTransition(transitionId, name, description, screen);
    }

    public ServiceOutcome<Workflow> addCommonTransition(String sourceStatusId, int transitionId) {
        try {
            StepDescriptor sourceStep = this.findStepInWorkflowWithStatusId(sourceStatusId);
            ActionDescriptor transition = this.getDescriptor().getAction(transitionId);
            if (!transition.isCommon()) {
                this.makeTransitionCommon(transition);
            }
            sourceStep.getActions().add(transition);
            sourceStep.getCommonActions().add(transition.getId());
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)"Workflow.addCommonTransition failed", (Throwable)e);
            return Outcomes.errorOutcome("workflow.designer.reusing.a.transition.failed", new Object[0]);
        }
    }

    public ServiceOutcome<TransitionData> addTransition(String name, String description, FieldScreen screen, int sourceStepId, int targetStepId) {
        StepDescriptor targetStep;
        StepDescriptor sourceStep = (StepDescriptor)this.findStepDescriptor(sourceStepId).getReturnedValue();
        ServiceOutcome<ActionDescriptor> addTransitionOutcome = this.addTransitionToWorkflow(description, name, screen, sourceStep, targetStep = (StepDescriptor)this.findStepDescriptor(targetStepId).getReturnedValue());
        if (!addTransitionOutcome.isValid()) {
            return Outcomes.errorOutcome(addTransitionOutcome);
        }
        ActionDescriptor actionDescriptor = (ActionDescriptor)addTransitionOutcome.getReturnedValue();
        ActionDescriptorTransitionData data = new ActionDescriptorTransitionData(actionDescriptor);
        return ServiceOutcomeImpl.ok((Object)data);
    }

    public ServiceOutcome<Workflow> deleteTransition(int transitionId, int sourceStepId) {
        ServiceOutcome<ActionDescriptor> actionOutcome = this.findActionDescriptor(transitionId);
        if (!actionOutcome.isValid()) {
            return Outcomes.errorOutcome(actionOutcome);
        }
        ActionDescriptor action = (ActionDescriptor)actionOutcome.getReturnedValue();
        if (this.isInitialAction(action)) {
            return Outcomes.errorOutcome("workflow.designer.cannot.delete.initial.transition", new Object[0]);
        }
        ServiceOutcome<StepDescriptor> sourceStepOutcome = this.findStepDescriptor(sourceStepId);
        if (!sourceStepOutcome.isValid()) {
            return Outcomes.errorOutcome(sourceStepOutcome);
        }
        StepDescriptor sourceStep = (StepDescriptor)sourceStepOutcome.getReturnedValue();
        this.removeActionFromWorkflow(action, sourceStep);
        return ServiceOutcomeImpl.ok((Object)this);
    }

    public ServiceOutcome<Workflow> updateTransition(int transitionId, String name, String description, FieldScreen screen) {
        try {
            ActionDescriptor transition = this.jiraWorkflow.getDescriptor().getAction(transitionId);
            transition.setName(name);
            transition.getMetaAttributes().put("jira.description", description);
            ServiceOutcome<ActionDescriptor> screenResult = this.addScreenToTransition(transition, screen);
            if (!screenResult.isValid()) {
                return Outcomes.errorOutcome(screenResult.getErrorCollection());
            }
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)"updateTransition - there was a problem updating the transition.", (Throwable)e);
            return Outcomes.errorOutcome("workflow.designer.updating.transition.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> updateTransitionTarget(int transitionId, Status targetStatus) {
        try {
            ActionDescriptor transition = this.jiraWorkflow.getDescriptor().getAction(transitionId);
            ResultDescriptor result = transition.getUnconditionalResult();
            result.setStep(this.jiraWorkflow.getLinkedStep(targetStatus).getId());
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)"updateTransitionTarget - there was a problem updating the transition target.", (Throwable)e);
            return Outcomes.errorOutcome("workflow.designer.updating.transition.target.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> updateTransitionSource(int transitionId, Status newSourceStatus, Status originalSourceStatus) {
        try {
            ActionDescriptor transition = this.jiraWorkflow.getDescriptor().getAction(transitionId);
            StepDescriptor originalSourceStep = this.jiraWorkflow.getLinkedStep(originalSourceStatus);
            StepDescriptor newSourceStep = this.jiraWorkflow.getLinkedStep(newSourceStatus);
            if (transition.isCommon()) {
                originalSourceStep.getCommonActions().remove(new Integer(transitionId));
                newSourceStep.getCommonActions().add(new Integer(transitionId));
            } else {
                transition.setParent((AbstractDescriptor)newSourceStep);
            }
            originalSourceStep.getActions().remove(transition);
            newSourceStep.getActions().add(transition);
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)"updateTransitionSource - there was a problem updating the transition source.", (Throwable)e);
            return Outcomes.errorOutcome("workflow.designer.updating.transition.source.failed", new Object[0]);
        }
    }

    public ServiceOutcome<Workflow> deleteGlobalTransition(String globalTransitionId) {
        try {
            ActionDescriptor action = this.jiraWorkflow.getDescriptor().getAction(Integer.valueOf(globalTransitionId).intValue());
            if (this.jiraWorkflow.getDescriptor().getGlobalActions().contains(action)) {
                this.jiraWorkflow.getDescriptor().removeAction(action);
            }
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)("deleteGlobalTransition - statusId:" + globalTransitionId + ", workflow:" + this.jiraWorkflow), (Throwable)e);
            return Outcomes.errorOutcome("workflow.designer.deleting.global.transition.failed", new Object[0]);
        }
    }

    public boolean isDuplicateGlobalTransitionName(String transitionName) {
        List transitions = this.jiraWorkflow.getDescriptor().getGlobalActions();
        return this.isNameInTransitions(transitionName, transitions);
    }

    public boolean isDuplicateTransitionName(String transitionName, int sourceStepId) {
        StepDescriptor sourceStep = (StepDescriptor)this.findStepDescriptor(sourceStepId).getReturnedValue();
        return this.isDuplicateTransitionName(transitionName, sourceStep);
    }

    public boolean targetStatusHasExistingTransitionWithName(int transitionId, String transitionName) {
        final int targetStepId = this.jiraWorkflow.getDescriptor().getAction(transitionId).getUnconditionalResult().getStep();
        Collection matchingTransitions = Collections2.filter((Collection)Lists.newArrayList((Iterable)this.jiraWorkflow.getAllActions()), (Predicate)new Predicate<ActionDescriptor>(){

            public boolean apply(ActionDescriptor transition) {
                return transition.getUnconditionalResult().getStep() == targetStepId;
            }
        });
        return this.isNameInTransitions(transitionName, Lists.newArrayList((Iterable)matchingTransitions));
    }

    public boolean isCommonTransition(int transitionId) {
        return this.hasTransition(transitionId) && this.jiraWorkflow.getDescriptor().getAction(transitionId).isCommon();
    }

    public boolean commonTransitionExistsFromSource(int transitionId, Status source) {
        boolean commonTransitionExistsFromSource = false;
        ActionDescriptor transition = this.jiraWorkflow.getDescriptor().getAction(transitionId);
        if (transition.isCommon()) {
            StepDescriptor sourceStep = this.getLinkedStep(source);
            commonTransitionExistsFromSource = sourceStep.getActions().contains(transition) && sourceStep.getCommonActions().contains(new Integer(transitionId));
        }
        return commonTransitionExistsFromSource;
    }

    public boolean targetStatusHasExistingTransitionWithName(Status status, String transitionName) {
        final int targetStepId = this.findStepInWorkflowWithStatusId(status.getId()).getId();
        Collection matchingTransitions = Collections2.filter((Collection)Lists.newArrayList((Iterable)this.jiraWorkflow.getAllActions()), (Predicate)new Predicate<ActionDescriptor>(){

            public boolean apply(ActionDescriptor transition) {
                return transition.getUnconditionalResult().getStep() == targetStepId;
            }
        });
        return this.isNameInTransitions(transitionName, Lists.newArrayList((Iterable)matchingTransitions));
    }

    public boolean hasTransition(int transitionId) {
        return this.jiraWorkflow.getDescriptor().getAction(transitionId) != null;
    }

    public ServiceOutcome<Boolean> statusHasOutgoingTransition(Status status, int transitionId) {
        ServiceOutcome<ActionDescriptor> actionDescriptorOutcome = this.findActionDescriptor(transitionId);
        if (!actionDescriptorOutcome.isValid()) {
            return Outcomes.errorOutcome(actionDescriptorOutcome);
        }
        StepDescriptor statusStep = this.getLinkedStep(status);
        Collection<StepDescriptor> transitionSourceSteps = this.getStepsForTransition((ActionDescriptor)actionDescriptorOutcome.getReturnedValue());
        return ServiceOutcomeImpl.ok((Object)transitionSourceSteps.contains(statusStep));
    }

    public String getTransitionName(int transitionId) {
        return this.jiraWorkflow.getDescriptor().getAction(transitionId).getName();
    }

    public boolean statusHasGlobalTransition(Status status) {
        StepDescriptor step = this.findStepInWorkflowWithStatusId(status.getId());
        List globalTransitions = this.jiraWorkflow.getDescriptor().getGlobalActions();
        for (ActionDescriptor transition : globalTransitions) {
            if (transition.getUnconditionalResult().getStep() != step.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean statusExistsOnWorkflow(Status status) {
        return null != this.findStepInWorkflowWithStatusId(status.getId());
    }

    public List<Integer> getStepIds() {
        return Lists.transform(this.getSteps(), GET_STEP_ID);
    }

    private void removeInboundTransitions(final StepDescriptor stepToDelete) {
        Collection matchingTransitions = Collections2.filter((Collection)Lists.newArrayList((Iterable)this.jiraWorkflow.getAllActions()), (Predicate)new Predicate<ActionDescriptor>(){

            public boolean apply(ActionDescriptor transition) {
                return transition.getUnconditionalResult().getStep() == stepToDelete.getId();
            }
        });
        for (ActionDescriptor matchedTransition : matchingTransitions) {
            if (this.jiraWorkflow.isGlobalAction(matchedTransition)) {
                this.deleteGlobalTransition(String.valueOf(matchedTransition.getId()));
                continue;
            }
            for (StepDescriptor step : this.getStepsForTransition(matchedTransition)) {
                if (matchedTransition.getUnconditionalResult().getStep() != stepToDelete.getId()) continue;
                this.removeActionFromWorkflow(matchedTransition, step);
            }
        }
    }

    private void makeTransitionCommon(ActionDescriptor transition) {
        StepDescriptor originalParent = (StepDescriptor)transition.getParent();
        originalParent.getActions().remove(transition);
        this.getDescriptor().addCommonAction(transition);
        transition.setParent((AbstractDescriptor)this.getDescriptor());
        originalParent.getActions().add(transition);
        originalParent.getCommonActions().add(transition.getId());
    }

    private void removeOutboundTransitions(StepDescriptor stepToDelete) {
        ArrayList transitions = Lists.newArrayList((Iterable)stepToDelete.getActions());
        for (ActionDescriptor transition : transitions) {
            this.removeActionFromWorkflow(transition, stepToDelete);
        }
    }

    private ServiceOutcome<ActionDescriptor> addTransitionToWorkflow(String description, String name, FieldScreen screen, StepDescriptor sourceStep, StepDescriptor targetStep) {
        if (this.isDuplicateTransitionName(name, sourceStep)) {
            return Outcomes.errorOutcome("workflow.designer.transition.name.exists", new Object[0]);
        }
        if (this.workflowService.isStepOnDraftWithNoTransitionsOnParentWorkflow((JiraServiceContext)this.createServiceContext(), this.jiraWorkflow, sourceStep.getId())) {
            return Outcomes.errorOutcome("workflow.designer.forbidden.operation.draft.workflow", WORKFLOW_EDITING_LIMITATIONS_ANCHOR_TAG_OPEN, ANCHOR_TAG_CLOSE);
        }
        ServiceOutcome<ActionDescriptor> transitionOutcome = this.createTransition(description, name, screen, targetStep);
        if (!transitionOutcome.isValid()) {
            return Outcomes.errorOutcome(transitionOutcome.getErrorCollection());
        }
        ActionDescriptor transition = (ActionDescriptor)transitionOutcome.getReturnedValue();
        transition.setParent((AbstractDescriptor)sourceStep);
        sourceStep.getActions().add(transition);
        return ServiceOutcomeImpl.ok((Object)transition);
    }

    public boolean isDuplicateTransitionName(String transitionName, StepDescriptor sourceStep) {
        return this.isDuplicateStepTransitionName(transitionName, sourceStep) || this.isDuplicateGlobalTransitionName(transitionName);
    }

    public boolean stepExists(int stepId) {
        return this.jiraWorkflow.getDescriptor().getStep(stepId) != null;
    }

    public boolean stepExists(Status status) {
        StepDescriptor linkedStep = this.jiraWorkflow.getLinkedStep(status);
        return linkedStep != null && this.stepExists(linkedStep.getId());
    }

    private boolean isNameInTransitions(String transitionName, List<ActionDescriptor> transitions) {
        for (ActionDescriptor transition : transitions) {
            if (!transitionName.equalsIgnoreCase(transition.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicateStepTransitionName(String transitionName, StepDescriptor sourceStep) {
        List transitions = sourceStep.getActions();
        return this.isNameInTransitions(transitionName, transitions);
    }

    private ServiceOutcome<Workflow> addGlobalTransition(StepDescriptor targetStep, String name, String description, FieldScreen screen) {
        ServiceOutcome<ActionDescriptor> transitionOutcome = this.createTransition(description, name, screen, targetStep);
        if (!transitionOutcome.isValid()) {
            return Outcomes.errorOutcome(transitionOutcome.getErrorCollection());
        }
        ActionDescriptor transition = (ActionDescriptor)transitionOutcome.getReturnedValue();
        try {
            transition.setParent((AbstractDescriptor)this.jiraWorkflow.getDescriptor());
            this.jiraWorkflow.getDescriptor().addGlobalAction(transition);
            return ServiceOutcomeImpl.ok((Object)this);
        }
        catch (Exception e) {
            return Outcomes.errorOutcome("workflow.designer.adding.global.transition.failed", new Object[0]);
        }
    }

    private ServiceOutcome<ActionDescriptor> createTransition(String description, String name, FieldScreen fieldScreen, StepDescriptor targetStep) {
        ResultDescriptor transitionResult = DescriptorFactory.getFactory().createResultDescriptor();
        transitionResult.setStep(targetStep.getId());
        ActionDescriptor transition = DescriptorFactory.getFactory().createActionDescriptor();
        transition.setId(this.jiraWorkflow.getNextActionId());
        transition.setName(name);
        transition.getMetaAttributes().put("jira.description", description);
        transition.setUnconditionalResult(transitionResult);
        this.addDefaultPostFunctionsToTransition(transition);
        return this.addScreenToTransition(transition, fieldScreen);
    }

    private ServiceOutcome<ActionDescriptor> addScreenToTransition(ActionDescriptor transition, FieldScreen fieldScreen) {
        if (fieldScreen != null) {
            transition.setView(fieldScreen.getName());
            transition.getMetaAttributes().put(SCREEN_ID_KEY, fieldScreen.getId().toString());
        } else {
            transition.setView(null);
            transition.getMetaAttributes().put(SCREEN_ID_KEY, null);
        }
        return ServiceOutcomeImpl.ok((Object)transition);
    }

    private ServiceOutcome<ActionDescriptor> findActionDescriptor(int transitionId) {
        ActionDescriptor action = this.jiraWorkflow.getDescriptor().getAction(transitionId);
        if (action == null) {
            return Outcomes.errorOutcome("workflow.designer.selected.transition.not.found", new Object[0]);
        }
        return ServiceOutcomeImpl.ok((Object)action);
    }

    private ServiceOutcome<StepDescriptor> findStepDescriptor(int stepId) {
        StepDescriptor step = this.jiraWorkflow.getDescriptor().getStep(stepId);
        if (step == null) {
            return Outcomes.errorOutcome("workflow.designer.selected.status.not.found", new Object[0]);
        }
        return ServiceOutcomeImpl.ok((Object)step);
    }

    private void removeActionFromWorkflow(ActionDescriptor action, StepDescriptor sourceStep) {
        sourceStep.getActions().remove(action);
        if (action.isCommon()) {
            sourceStep.getCommonActions().remove((Object)action.getId());
            if (this.jiraWorkflow.getStepsForTransition(action).isEmpty()) {
                this.jiraWorkflow.getDescriptor().getCommonActions().remove(action.getId());
            }
        }
        if (sourceStep.getActions().isEmpty() && sourceStep.getCommonActions().isEmpty()) {
            sourceStep.removeActions();
        }
    }

    private void addDefaultPostFunctionsToTransition(ActionDescriptor transition) {
        List transitionPostFunctions = transition.getUnconditionalResult().getPostFunctions();
        for (FunctionDescriptor function : this.workflowFunctionUtilities.getDefaultPostFunctions()) {
            transitionPostFunctions.add(function);
        }
    }

    public boolean workflowContainsStepWithStatusId(final String statusId) {
        return null != this.findStep(new Predicate<StepDescriptor>(){

            public boolean apply(StepDescriptor input) {
                Object value = input.getMetaAttributes().get("jira.status.id");
                return value instanceof String && statusId.equalsIgnoreCase((String)value);
            }
        });
    }

    private StepDescriptor findStepInWorkflowWithStatusId(final String statusId) {
        return this.findStep(new Predicate<StepDescriptor>(){

            public boolean apply(StepDescriptor input) {
                Object value = input.getMetaAttributes().get("jira.status.id");
                return value instanceof String && statusId.equalsIgnoreCase((String)value);
            }
        });
    }

    private StepDescriptor findStep(Predicate<StepDescriptor> predicate) {
        return (StepDescriptor)Iterables.find(this.getSteps(), predicate, null);
    }

    public List<StepDescriptor> getSteps() {
        return this.jiraWorkflow.getDescriptor().getSteps();
    }

    public String getName() {
        return this.jiraWorkflow.getName();
    }

    public String getDisplayName() {
        return this.jiraWorkflow.getDisplayName();
    }

    public String getDescription() {
        return this.jiraWorkflow.getDescription();
    }

    public WorkflowDescriptor getDescriptor() {
        return this.jiraWorkflow.getDescriptor();
    }

    public Collection<ActionDescriptor> getAllActions() {
        return this.jiraWorkflow.getAllActions();
    }

    public Collection<ActionDescriptor> getActionsWithResult(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.getActionsWithResult(stepDescriptor);
    }

    public boolean removeStep(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.removeStep(stepDescriptor);
    }

    public StepDescriptor getLinkedStep(GenericValue status) {
        return this.jiraWorkflow.getLinkedStep(status);
    }

    public StepDescriptor getLinkedStep(Status status) {
        return this.jiraWorkflow.getLinkedStep(status);
    }

    public List<GenericValue> getLinkedStatuses() {
        return this.jiraWorkflow.getLinkedStatuses();
    }

    public List<Status> getLinkedStatusObjects() {
        return this.jiraWorkflow.getLinkedStatusObjects();
    }

    public boolean isActive() throws WorkflowException {
        return this.jiraWorkflow.isActive();
    }

    public boolean isSystemWorkflow() throws WorkflowException {
        return this.jiraWorkflow.isSystemWorkflow();
    }

    public boolean isEditable() throws WorkflowException {
        return this.jiraWorkflow.isEditable();
    }

    public boolean isDefault() {
        return this.jiraWorkflow.isDefault();
    }

    public boolean isDraftWorkflow() {
        return this.jiraWorkflow.isDraftWorkflow();
    }

    public boolean hasDraftWorkflow() {
        return this.jiraWorkflow.hasDraftWorkflow();
    }

    public int getNextActionId() {
        return this.jiraWorkflow.getNextActionId();
    }

    public Collection<StepDescriptor> getStepsForTransition(ActionDescriptor action) {
        return this.jiraWorkflow.getStepsForTransition(action);
    }

    public Collection<FunctionDescriptor> getPostFunctionsForTransition(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.getPostFunctionsForTransition(actionDescriptor);
    }

    public boolean isInitialAction(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.isInitialAction(actionDescriptor);
    }

    public boolean isCommonAction(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.isCommonAction(actionDescriptor);
    }

    public boolean isGlobalAction(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.isGlobalAction(actionDescriptor);
    }

    public boolean isOrdinaryAction(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.isOrdinaryAction(actionDescriptor);
    }

    public GenericValue getLinkedStatus(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.getLinkedStatus(stepDescriptor);
    }

    public Status getLinkedStatusObject(StepDescriptor stepDescriptor) {
        return this.jiraWorkflow.getLinkedStatusObject(stepDescriptor);
    }

    public String getActionType(ActionDescriptor actionDescriptor) {
        return this.jiraWorkflow.getActionType(actionDescriptor);
    }

    public void reset() {
        this.jiraWorkflow.reset();
    }

    public Collection<ActionDescriptor> getActionsForScreen(FieldScreen fieldScreen) {
        return this.jiraWorkflow.getActionsForScreen(fieldScreen);
    }

    public String getUpdateAuthorName() {
        return this.jiraWorkflow.getUpdateAuthorName();
    }

    public ApplicationUser getUpdateAuthor() {
        return this.jiraWorkflow.getUpdateAuthor();
    }

    public Date getUpdatedDate() {
        return this.jiraWorkflow.getUpdatedDate();
    }

    public String getMode() {
        return this.jiraWorkflow.getMode();
    }

    public int compareTo(JiraWorkflow workflow) {
        return this.jiraWorkflow.compareTo((Object)workflow);
    }

    private JiraServiceContextImpl createServiceContext() {
        return new JiraServiceContextImpl(this.getCurrentUser());
    }

    private ApplicationUser getCurrentUser() {
        return this.jiraAuthenticationContext.getUser();
    }

    private StepDescriptor makeStepDescriptor(Status status) {
        StepDescriptor step = DescriptorFactory.getFactory().createStepDescriptor();
        step.getMetaAttributes().put("jira.status.id", status.getId());
        step.setId(WorkflowUtil.getNextId(this.getSteps()));
        step.setName(status.getName());
        step.setParent((AbstractDescriptor)this.jiraWorkflow.getDescriptor());
        return step;
    }

    public JiraWorkflow getJiraWorkflow() {
        return this.jiraWorkflow;
    }
}

