/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.rest.Screen;
import com.atlassian.jira.plugins.workflowdesigner.utilities.Permissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/screens")
public class ScreensResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final Permissions permissions;
    private final FieldScreenManager fieldScreenManager;

    public ScreensResource(JiraAuthenticationContext jiraAuthenticationContext, Permissions permissions, FieldScreenManager fieldScreenManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissions = permissions;
        this.fieldScreenManager = fieldScreenManager;
    }

    @GET
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response getScreens() {
        if (this.permissions.userIsAdministrator()) {
            ArrayList screens = Lists.newArrayList((Object[])new Screen[]{this.emptyView()});
            screens.addAll(Collections2.transform((Collection)this.fieldScreenManager.getFieldScreens(), Screen.FROM_FIELD_SCREEN));
            return Responses.createOKResponse(screens);
        }
        return Responses.createResponse(this.jiraAuthenticationContext.getI18nHelper(), "workflow.designer.screens.forbidden", Response.Status.FORBIDDEN);
    }

    private Screen emptyView() {
        return new Screen(0L, this.jiraAuthenticationContext.getI18nHelper().getText("workflow.designer.no.screen.for.transition"));
    }
}

