/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.jira.plugins.workflowdesigner.layout.Layout;
import com.atlassian.jira.plugins.workflowdesigner.layout.LegacyLayoutConverter;
import com.atlassian.jira.plugins.workflowdesigner.layout.Status;
import com.atlassian.jira.plugins.workflowdesigner.layout.StatusCategory;
import com.atlassian.jira.plugins.workflowdesigner.layout.Transition;
import com.atlassian.jira.plugins.workflowdesigner.layout.Transitions;
import com.atlassian.jira.plugins.workflowdesigner.utilities.ActionDescriptorTransitionData;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayout;
import java.util.HashSet;
import java.util.Set;

public class LegacyLayoutConverterImpl
implements LegacyLayoutConverter {
    @Override
    public Layout convert(JiraWorkflow workflow, JWDLayout oldLayout) {
        return new Converter(workflow, oldLayout).convert();
    }

    private static class Converter {
        private final Layout newLayout = new Layout();
        private final JWDLayout oldLayout;
        private final Set<String> statusIds = new HashSet<String>();
        private final Set<String> transitionIds = new HashSet<String>();
        private final JiraWorkflow workflow;

        Converter(JiraWorkflow workflow, JWDLayout oldLayout) {
            this.workflow = workflow;
            this.oldLayout = oldLayout;
        }

        private Layout convert() {
            for (NodeLayout nodeLayout : this.oldLayout.getRoots()) {
                this.convertStatus(nodeLayout);
            }
            return this.newLayout;
        }

        private void convertStatus(NodeLayout nodeLayout) {
            String id = nodeLayout.getId();
            if (this.statusIds.contains(id)) {
                return;
            }
            this.statusIds.add(id);
            Status status = new Status(id, nodeLayout.getLabel(), this.getLinkedStatusDescription(nodeLayout), nodeLayout.getIsInitialAction(), nodeLayout.getStepId(), this.getLinkedStatusId(nodeLayout), nodeLayout.getRect().getX(), nodeLayout.getRect().getY(), this.getLinkedStatusCategory(nodeLayout));
            this.newLayout.addStatus(status);
            for (EdgeLayout edgeLayout : nodeLayout.getInLinks()) {
                this.convertTransition(edgeLayout);
            }
            for (EdgeLayout edgeLayout : nodeLayout.getOutLinks()) {
                this.convertTransition(edgeLayout);
            }
        }

        private void convertTransition(EdgeLayout edgeLayout) {
            String id = edgeLayout.getId();
            if (this.transitionIds.contains(id)) {
                return;
            }
            this.transitionIds.add(id);
            Transition transition = new Transition(edgeLayout.getLabel(), edgeLayout.getStartNode().getId(), edgeLayout.getEndNode().getId(), edgeLayout.getActionId());
            ActionDescriptor actionDescriptor = this.workflow.getDescriptor().getAction(edgeLayout.getActionId().intValue());
            ActionDescriptorTransitionData data = new ActionDescriptorTransitionData(actionDescriptor);
            Transitions.copyDataToTransition(data, transition);
            this.newLayout.addTransition(transition);
            this.convertStatus(edgeLayout.getStartNode());
            this.convertStatus(edgeLayout.getEndNode());
        }

        private StatusCategory getLinkedStatusCategory(NodeLayout nodeLayout) {
            if (nodeLayout.getIsInitialAction().booleanValue()) {
                return null;
            }
            com.atlassian.jira.issue.status.Status status = this.getStatus(nodeLayout);
            if (status == null) {
                return null;
            }
            com.atlassian.jira.issue.status.category.StatusCategory statusCategory = status.getStatusCategory();
            if (statusCategory == null) {
                return null;
            }
            return new StatusCategory(statusCategory.getColorName(), statusCategory.getId());
        }

        private String getLinkedStatusDescription(NodeLayout nodeLayout) {
            if (nodeLayout.getIsInitialAction().booleanValue()) {
                return null;
            }
            com.atlassian.jira.issue.status.Status status = this.getStatus(nodeLayout);
            return status != null ? status.getDescription() : null;
        }

        private String getLinkedStatusId(NodeLayout nodeLayout) {
            if (nodeLayout.getIsInitialAction().booleanValue()) {
                return null;
            }
            com.atlassian.jira.issue.status.Status status = this.getStatus(nodeLayout);
            return status != null ? status.getId() : null;
        }

        private com.atlassian.jira.issue.status.Status getStatus(NodeLayout nodeLayout) {
            StepDescriptor step = this.workflow.getDescriptor().getStep(nodeLayout.getStepId().intValue());
            return this.workflow.getLinkedStatusObject(step);
        }
    }
}

