/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.plugins.webhooks.listener.JiraWebHookListenerParameters;
import com.atlassian.jira.plugins.webhooks.matcher.JqlEventMatcher;
import com.atlassian.jira.plugins.webhooks.workflow.TransitionMapper;
import com.atlassian.jira.plugins.webhooks.workflow.TransitionSerializer;
import com.atlassian.jira.plugins.webhooks.workflow.WebHookPostFunctionEvent;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.api.provider.WebHookListenerService;
import com.atlassian.webhooks.spi.provider.WebHookListenerParameters;
import com.google.common.base.Optional;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class TriggerWebhookFunction
extends AbstractJiraFunctionProvider {
    private final I18nResolver i18n;
    private final TransitionMapper transitionMapper;
    private final EventPublisher eventPublisher;
    private final JqlEventMatcher jqlEventMatcher;
    private final WebHookListenerService webHookListenerService;
    private final Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());

    public TriggerWebhookFunction(I18nResolver i18n, TransitionMapper transitionMapper, EventPublisher eventPublisher, JqlEventMatcher jqlEventMatcher, WebHookListenerService webHookListenerService) {
        this.i18n = i18n;
        this.transitionMapper = transitionMapper;
        this.eventPublisher = eventPublisher;
        this.jqlEventMatcher = jqlEventMatcher;
        this.webHookListenerService = webHookListenerService;
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String webHookId = (String)args.get("field.webhookId");
        Optional webHookOption = this.webHookListenerService.getWebHookListener(Integer.valueOf(Integer.parseInt(webHookId)));
        if (!webHookOption.isPresent()) {
            this.logger.error((Object)this.i18n.getText("webhooks.postfunction.deleted"));
            return;
        }
        WebHookListenerParameters webHookListenerParameters = (WebHookListenerParameters)webHookOption.get();
        MutableIssue issue = this.getIssue(transientVars);
        if (issue == null || !issue.isCreated()) {
            this.logger.error((Object)"Transition cannot be sent to webhook as an issue has not been created yet.");
            return;
        }
        Optional<String> filter = JiraWebHookListenerParameters.ParametersParser.getFilter(webHookListenerParameters.getParameters());
        if (webHookListenerParameters.isEnabled().booleanValue() && this.jqlEventMatcher.matchJql((String)filter.orNull(), (Issue)issue)) {
            Map<String, Object> data = this.transitionMapper.toMap(transientVars, this.getCaller(transientVars, args), issue);
            try {
                boolean excludeIssueDetails = JiraWebHookListenerParameters.ParametersParser.getExcludeIssueDetails(webHookListenerParameters.getParameters());
                String message = excludeIssueDetails ? "" : new TransitionSerializer(data).getJson();
                this.eventPublisher.publish((Object)new WebHookPostFunctionEvent(webHookListenerParameters.getId(), message, issue.getKey()));
            }
            catch (IOException e) {
                this.logger.error((Object)"Error serializing post-function context", (Throwable)e);
            }
        }
    }
}

