/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.validation;

import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.webhooks.listener.JiraWebHookListenerParameters;
import com.atlassian.jira.plugins.webhooks.templates.InvalidTemplateException;
import com.atlassian.jira.plugins.webhooks.templates.UrlBuilder;
import com.atlassian.jira.plugins.webhooks.validation.JqlValidationUtil;
import com.atlassian.jira.plugins.webhooks.workflow.WorkflowUtil;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.MessageCollection;
import com.atlassian.webhooks.spi.provider.WebHookListenerActionValidator;
import com.atlassian.webhooks.spi.provider.WebHookListenerParameters;
import com.atlassian.webhooks.spi.provider.WebHookListenerRegistrationParameters;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class JiraWebHookListenerActionValidator
implements WebHookListenerActionValidator {
    private final JqlValidationUtil jqlValidationUtil;
    private final FeatureManager featureManager;
    private final UrlBuilder urlBuilder;
    private final I18nResolver i18n;
    private final WorkflowUtil workflowUtil;

    public JiraWebHookListenerActionValidator(JqlValidationUtil jqlValidationUtil, FeatureManager featureManager, UrlBuilder urlBuilder, I18nResolver i18n, WorkflowUtil workflowUtil) {
        this.jqlValidationUtil = jqlValidationUtil;
        this.featureManager = featureManager;
        this.urlBuilder = urlBuilder;
        this.i18n = i18n;
        this.workflowUtil = workflowUtil;
    }

    public MessageCollection validateWebHookRegistration(WebHookListenerRegistrationParameters webHookListenerRegistrationParameters) {
        return this.validateAdditionAndUpdate(webHookListenerRegistrationParameters);
    }

    public MessageCollection validateWebHookUpdate(WebHookListenerRegistrationParameters webHookListenerRegistrationParameters) {
        return this.validateAdditionAndUpdate(webHookListenerRegistrationParameters);
    }

    private MessageCollection validateAdditionAndUpdate(WebHookListenerRegistrationParameters webHookListenerRegistrationParameters) {
        WebHookListenerActionValidator.ErrorMessageCollection errorMessageCollection = new WebHookListenerActionValidator.ErrorMessageCollection();
        this.validateUrl((MessageCollection)errorMessageCollection, webHookListenerRegistrationParameters.getUrl());
        Optional<String> filter = JiraWebHookListenerParameters.ParametersParser.getFilter(webHookListenerRegistrationParameters.getParameters());
        this.jqlValidationUtil.validateFilter((MessageCollection)errorMessageCollection, filter);
        return errorMessageCollection;
    }

    public MessageCollection validateWebHookRemoval(WebHookListenerParameters webHookListenerParameters) {
        Set<Map<String, String>> transitions = this.workflowUtil.getTransitionLinkedToWebHookListener(webHookListenerParameters.getId());
        if (!transitions.isEmpty()) {
            WebHookListenerActionValidator.ErrorMessageCollection errorCollection = new WebHookListenerActionValidator.ErrorMessageCollection();
            errorCollection.addMessage("title", new Serializable[]{this.i18n.getText("webhooks.delete.error.linkedtransitions", new Serializable[]{webHookListenerParameters.getName()})});
            errorCollection.addMessage("transitions", new Serializable[]{transitions.toString()});
            return errorCollection;
        }
        return WebHookListenerActionValidator.ErrorMessageCollection.emptyErrorMessageCollection();
    }

    private void validateUrl(MessageCollection errorMessageCollection, String url) {
        if (!StringUtils.isBlank((String)url)) {
            UrlValidator validator = this.featureManager.isEnabled(CoreFeatures.ON_DEMAND) ? new OnDemandUrlValidator() : new UrlValidator();
            try {
                String sampleUrl = this.urlBuilder.getSampleUrl(url);
                validator.validate(sampleUrl, errorMessageCollection, this.i18n);
            }
            catch (InvalidTemplateException e) {
                errorMessageCollection.addMessage("url", new Serializable[]{this.i18n.getText("webhooks.invalid.url.template")});
            }
        }
    }

    public static class OnDemandUrlValidator
    extends UrlValidator {
        static final Map<String, Integer> ALLOWED_ONDEMAND_PORTS = ImmutableMap.of((Object)"HTTP", (Object)80, (Object)"HTTPS", (Object)443);

        @Override
        public boolean validate(String url, MessageCollection errorCollection, I18nResolver i18n) {
            if (!super.validate(url, errorCollection, i18n)) {
                return false;
            }
            try {
                URI uriToCheck = new URI(url);
                Integer allowedPort = ALLOWED_ONDEMAND_PORTS.get(uriToCheck.getScheme().toUpperCase());
                if (uriToCheck.getPort() == -1) {
                    return true;
                }
                if (!allowedPort.equals(uriToCheck.getPort())) {
                    errorCollection.addMessage("url", new Serializable[]{i18n.getText("webhooks.invalid.url.ondemand.ports")});
                    return false;
                }
            }
            catch (URISyntaxException e) {
                errorCollection.addMessage("url", new Serializable[]{i18n.getText("webhooks.invalid.url")});
                return false;
            }
            return true;
        }
    }

    public static class UrlValidator {
        static final List<String> ALLOWED_PROTOCOLS = ImmutableList.of((Object)"HTTP", (Object)"HTTPS");
        public static final String URL_FIELD = "url";

        public boolean validate(String url, MessageCollection errorCollection, I18nResolver i18n) {
            if (StringUtils.isBlank((String)url)) {
                errorCollection.addMessage(URL_FIELD, new Serializable[]{i18n.getText("webhooks.empty.url")});
                return false;
            }
            if (!com.atlassian.jira.util.UrlValidator.isValid((String)url)) {
                String errorMessage = this.isProtocolValid(url) ? i18n.getText("webhooks.invalid.url") : i18n.getText("webhooks.invalid.url.protocol");
                errorCollection.addMessage(URL_FIELD, new Serializable[]{errorMessage});
                return false;
            }
            return true;
        }

        boolean isProtocolValid(String url) {
            try {
                String protocol = new URI(url).getScheme();
                return protocol != null && ALLOWED_PROTOCOLS.contains(protocol.toUpperCase());
            }
            catch (URISyntaxException e) {
                return true;
            }
        }
    }
}

