/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.ui;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.webhooks.matcher.WebHookJiraEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.sal.api.message.HelpPath;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.webhooks.spi.provider.WebHookUIItem;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;

public class JiraWebHookParametersUI
implements WebHookUIItem {
    private static final String WEBHOOKS_PARAMETERS_TEMPLATE = "/templates/webhooks-parameters.vm";
    private final TemplateRenderer templateRenderer;
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final ApplicationProperties applicationProperties;
    private final HelpPathResolver helpPathResolver;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public JiraWebHookParametersUI(TemplateRenderer templateRenderer, AutoCompleteJsonGenerator autoCompleteJsonGenerator, ApplicationProperties applicationProperties, HelpPathResolver helpPathResolver, JiraAuthenticationContext jiraAuthenticationContext) {
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        this.autoCompleteJsonGenerator = (AutoCompleteJsonGenerator)Preconditions.checkNotNull((Object)autoCompleteJsonGenerator);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.helpPathResolver = (HelpPathResolver)Preconditions.checkNotNull((Object)helpPathResolver);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
    }

    public String getHtml() {
        try {
            HashMap builder = Maps.newHashMap();
            builder.put("action", this);
            builder.put("textutils", new TextUtils());
            StringWriter stringWriter = new StringWriter();
            this.templateRenderer.render(WEBHOOKS_PARAMETERS_TEMPLATE, (Map)ImmutableMap.copyOf((Map)builder), (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private User getUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    private Locale getLocale() {
        return this.jiraAuthenticationContext.getLocale();
    }

    public String section() {
        return "jia-webhooks-item";
    }

    public Integer weight() {
        return 1;
    }

    public BrowserUtils getBrowserUtils() {
        return new BrowserUtils();
    }

    public Collection<WebHookJiraEvent> getEvents() {
        return Arrays.asList(WebHookJiraEvent.values());
    }

    @HtmlSafe
    public String getAllEventsKey() {
        JSONArray jsonArray = new JSONArray();
        for (WebHookJiraEvent event : WebHookJiraEvent.values()) {
            jsonArray.put((Object)event.getValue());
        }
        return StringEscapeUtils.escapeHtml((String)jsonArray.toString());
    }

    @HtmlSafe
    public String getNoEventsKey() {
        return null;
    }

    @HtmlSafe
    public String getEventNameMappings() throws JSONException {
        JSONObject json = new JSONObject();
        for (WebHookJiraEvent event : WebHookJiraEvent.values()) {
            json.append(event.getValue(), (Object)event.getDisplayName());
        }
        return StringEscapeUtils.escapeHtml((String)json.toString());
    }

    @HtmlSafe
    public String getVisibleFieldNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(this.getUser(), this.getLocale());
    }

    @HtmlSafe
    public String getVisibleFunctionNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(this.getUser(), this.getLocale());
    }

    @HtmlSafe
    public String getJqlReservedWordsJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getJqlReservedWordsJson();
    }

    public boolean isAutocompleteEnabled() {
        return !this.applicationProperties.getOption("jira.jql.autocomplete.disabled");
    }

    public HelpPath getHelpPath(String path) {
        return this.helpPathResolver.getHelpPath(path);
    }
}

