/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks;

import com.atlassian.jira.event.issue.IssueRelatedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugins.webhooks.templates.InvalidTemplateException;
import com.atlassian.jira.plugins.webhooks.templates.UrlBuilder;
import com.atlassian.jira.plugins.webhooks.workflow.WebHookPostFunctionEvent;
import com.atlassian.webhooks.spi.plugin.PluginUriCustomizer;
import com.atlassian.webhooks.spi.provider.WebHookEvent;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraWebHookPluginUriCustomizer
implements PluginUriCustomizer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UrlBuilder urlBuilder;

    public JiraWebHookPluginUriCustomizer(UrlBuilder urlBuilder) {
        this.urlBuilder = urlBuilder;
    }

    public URI customizeURI(String pluginKey, URI uri, WebHookEvent webHookEvent) {
        try {
            if (webHookEvent.getEvent() instanceof IssueRelatedEvent) {
                Issue issue = ((IssueRelatedEvent)webHookEvent.getEvent()).getIssue();
                return this.urlBuilder.buildUrl(uri, issue);
            }
            if (webHookEvent.getEvent() instanceof WebHookPostFunctionEvent) {
                String issueKey = ((WebHookPostFunctionEvent)webHookEvent.getEvent()).getIssueKey();
                return this.urlBuilder.buildUrl(uri, issueKey);
            }
        }
        catch (InvalidTemplateException e) {
            this.logger.error("Exception while customizing URI ", (Object)e.getMessage());
        }
        return uri;
    }
}

