// Warning!
// This module has a hidden circular dependency -> jira/project-templates/template-info-controller
define('jira/project-templates/template-info-view', [
    'jira/project-templates/dialog-controller',
    'require',
    'backbone',
    'jquery',
    'underscore'
], function(
    DialogController,
    require,
    Backbone,
    $,
    _
){
    var trigger = AJS.trigger;

    return Backbone.View.extend({

        initialize: function(options) {
            _.bindAll(this, "draw", "onNext")
        },

        draw: function(templatePath, name) {
            var page = DialogController.addPage({
                name: "template-info",
                title: name,
                panelName: "template-info",
                backButton: true,
                submitButtonText: AJS.I18n.getText("add.project.select"),
                submitButtonCallback: this.onNext,
                submitButtonClass: "template-info-dialog-create-button"
            });

            var templateInfoPanel = this._nameToObj(templatePath)();
            DialogController.dialog.getPanel(page.id, 0).html(templateInfoPanel);

            DialogController.dialog.gotoPage(page.id);

            var submitButton = _.find(page.button, function (button) {
                return button.item && button.item.hasClass('pt-submit-button');
            });

            if(submitButton) {
                setTimeout(function() { submitButton.item.focus(); }, 0);
            }
        },

        _nameToObj: function(name) {
            return _.reduce(name.split('.'), function(obj, name) { if (obj) return obj[name]; }, window);
        },

        onNext: function(e) {
            trigger('analyticsEvent', {name: 'jira.project.templates.dialog.create.templateinfo.next'});
            // This is a workaround to resolve circular dependencies between these two modules.
            var TemplateInfoController = require('jira/project-templates/template-info-controller');
            TemplateInfoController.next();
            return false;
        }
    });
});
AJS.namespace('JPT.TemplateInfoView', null, require('jira/project-templates/template-info-view'));
