// WARNING
// This module has a hidden circular dependency -> jira/project-templates/add-project-controller
define('jira/project-templates/add-project-view-impl', [
    'jira/project-templates/dialog-controller',
    'jira/project-templates/config',
    'jira/util/events',
    'jira/util/events/types',
    'require',
    'backbone',
    'jquery',
    'underscore'
], function(
    DialogController,
    Config,
    Events,
    EventTypes,
    require,
    Backbone,
    $,
    _
){
    var InlineDialog = AJS.InlineDialog;

    return Backbone.View.extend({
        TIMEOUT_MS: 100,

        postDrawCallbacks: [],

        events: {
            "submit #add-project-form": "onSubmitForm"
        },

        page: undefined,
        isSubmitting: false,

        initialize: function(options) {
            _.bindAll(this, "bindHook");
        },

        addPostDrawCallback: function(callback) {
            this.postDrawCallbacks.push(callback);
        },

        /**
         * Prepare the Dialog to hold the Add Project form; this should only be called once for a selected Project Template.
         * The actual form could be rendered multiple times after unsuccessful validations.
         */
        prepareDialog: function(title) {
            this.page = DialogController.addPage({
                name: "add-project",
                title: title,
                panelName: "add-project",
                backButton: true,
                submitButtonText: AJS.I18n.getText("admin.addproject.submit"),
                submitButtonCallback: this.onSubmitForm.bind(this),
                submitButtonClass: "add-project-dialog-create-button"
            });
        },

        /**
         * Draw the Add Project form into the passed dialog, as a new screen.
         *
         * This will be triggered on clicking "Next", so should render on the second page.
         */
        draw: function(params) {
            function fixErrorObject(errors) {
                if (!errors.errors) {
                    errors.errors = {}
                }
                return errors;
            }
            this.isSubmitting = false;

            DialogController.dialog.gotoPage(this.page.id);

            var projectTemplateModuleCompleteKey = params.webItemData.projectTemplateModuleCompleteKey;
            var templateGroup = _.find(Config.model.projectTemplatesGroupedByType, function(templateGroup){
                return _.any(templateGroup.projectTemplates, function(template) {
                    return template.itemModuleCompleteKey == projectTemplateModuleCompleteKey
                });
            });
            var applicationName = (templateGroup && templateGroup.applicationInfo && templateGroup.applicationInfo.applicationName) || '';
            var usedSeats = (templateGroup && templateGroup.applicationInfo && templateGroup.applicationInfo.licenseUsedSeats) || 0;
            var totalSeats = (templateGroup && templateGroup.applicationInfo && templateGroup.applicationInfo.licenseTotalSeats) || 0;
            var canUserBeAddedToApplication = (templateGroup && templateGroup.applicationInfo && templateGroup.applicationInfo.canUserBeAddedToApplication) || false;
            var canUserUseApplication = (templateGroup && templateGroup.applicationInfo && templateGroup.applicationInfo.canUserUseApplication) || false;
            var isOnDemand = (templateGroup && templateGroup.applicationInfo && templateGroup.applicationInfo.ondemand) || false;
            var displayCheckbox;
            if (!templateGroup || !templateGroup.applicationInfo) {
                displayCheckbox = false;
            } else {
                displayCheckbox = !canUserUseApplication;
            }

            var soyParameters = {
                maxNameLength: Config.model.maxNameLength,
                maxKeyLength: Config.model.maxKeyLength,
                shouldShowLead: Config.model.shouldShowProjectLead,
                projectTemplateWebItemKey: Config.model.selectedTemplate || params.webItemData.itemModuleCompleteKey,
                projectTemplateModuleKey: projectTemplateModuleCompleteKey,
                projectTemplateTitle: params.webItemData.name,
                projectTemplateDescriptionContent: params.webItemData.longDescriptionContent,
                currentKey: params.currentKey || "",
                currentName: params.currentName || "",
                errors: fixErrorObject(params.errors),
                projectLeadPickerField: {
                    id: 'lead',
                    name: 'lead'
                },
                addUserToLicense: {
                    displayCheckbox: displayCheckbox,
                    disableCheckbox: !canUserBeAddedToApplication,
                    applicationName: applicationName,
                    usedSeats: usedSeats,
                    totalSeats: totalSeats,
                    fieldId: 'licenseUser',
                    fieldName: 'licenseUser',
                    licensingUrl: isOnDemand? '/admin/accessconfig' : '/plugins/servlet/applications/versions-licenses'
                },
                leadOptions: [
                    {
                        selected: true,
                        displayName: params.currentUserDisplayName,
                        optionName: params.currentUserName,
                        avatarURL: params.currentUserAvatarUrl
                    }
                ]
            };
            var addProjectForm = JIRA.Templates.ProjectTemplates.addProjectForm(soyParameters);

            DialogController.dialog.getPanel(this.page.id, 0).html(addProjectForm);

            if (params.webItemData && params.webItemData.backgroundIconUrl) {
                var $addProjectWrapper = DialogController.$dialogElement.find(".pt-content");
                $addProjectWrapper.css('background-image', 'url("' + params.webItemData.backgroundIconUrl + '")');
            }

            var $addProjectForm = $("#add-project-form");
            // fire event to create the Single User Picker
            Events.trigger(EventTypes.NEW_CONTENT_ADDED, [$addProjectForm]);

            this.nameElement = DialogController.$dialogElement.find("#name");
            this.keyElement = DialogController.$dialogElement.find("#key");
            this.keyEditedElement = DialogController.$dialogElement.find("#keyEdited");
            this.leadDisplayElement = DialogController.$dialogElement.find("#lead-field");
            this.leadValueElement = DialogController.$dialogElement.find("#lead");

            var $keyHelpElement = this.keyElement.parent().find(".aui-icon-help");
            if ($keyHelpElement.length) {
                new InlineDialog($keyHelpElement, "project-key-help-popup",
                    function(contents, trigger, show) {
                        contents.html(JIRA.Templates.ProjectTemplates.keyHelp());
                        show();
                    }, {
                        width: 330,
                        offsetX: -30
                    });
            }

            // Input restrictions
            this.keyElement.attr("style", "text-transform: uppercase");

            var AddProjectController = require('jira/project-templates/add-project-controller');

            this.nameElement.focus(_.bind(function(e) {
                this.bindHook(e, AddProjectController.nameTimeout);
            }, this));

            var self = this;
            this.nameElement.change(function (e){
                AddProjectController.validateName();
                self.unbindHook(e);
            });

            this.nameElement.focus();

            this.keyElement.focus(_.bind(function(e) {
                var el = $(e.target);
                el.data("lastValue", el.val());
                this.bindHook(e, AddProjectController.keyTimeout);
            }, this));

            this.keyElement.blur(_.bind(function(e) {
                this.unbindHook(e);
            }, this));

            this.keyElement.change(function() {
                AddProjectController.validateKey();
                AddProjectController.autofillKeyIfNeeded();
            });
            if (!_.isEmpty(this.postDrawCallbacks)) {
                _.each(this.postDrawCallbacks, function(callback) {
                    callback();
                });
            }
            DialogController.dialog.updateHeight();
        },

        /**
         * Submits the "Add Project" form.
         *
         * @param {jQuery.Event} e the submit event
         * @returns {boolean}
         */
        onSubmitForm: function(e) {
            var AddProjectController = require('jira/project-templates/add-project-controller');
            AddProjectController.submit();
            return false;
        },

        get$SubmitButton: function() {
            return DialogController.$dialogElement.find(".add-project-dialog-create-button");
        },

        get$BackButton: function() {
            return DialogController.$dialogElement.find(".add-project-back-button");
        },

        bindHook: function bindHook(e, func) {
            var el = $(e.target), hook;
            hook = _.bind(function() {
                this.unbindHook(e);
                func.apply();
                if (el.is(":visible")) {
                    el.data("checkHook", setTimeout(hook, this.TIMEOUT_MS));
                }
            }, this);
            if (!el.data("checkHook")) {
                el.data("checkHook", setTimeout(hook, 0));
            }
        },

        unbindHook: function(e) {
            var el = $(e.target);
            clearTimeout(el.data("checkHook"));
            el.removeData("checkHook");
        },

        /**
         * Show an error for an input element, in the place of its description.
         *
         * @param $element
         * @param msg
         */
        showInlineError: function($element, msg) {
            if (this.isSubmitting) {
                // while the form is being submitted, don't show any late validation errors
                return;
            }
            var $errorElement = $element.parent().find(".error");
            if (!$errorElement.length) {
                $errorElement = $("<div class='error'></div>");
                $element.parent().append($errorElement);
            }
            $errorElement.text(msg);
            $errorElement.show();
        },

        showInlineErrorForName: function showInlineErrorForName(msg) {
            this.showInlineError(this.nameElement, msg);
        },

        showInlineErrorForKey: function showInlineErrorForKey(msg) {
            this.showInlineError(this.keyElement, msg);
        },

        /**
         * Hide any errors for an input field shown by showInlineError, and its description.
         *
         * @param $element
         */
        hideInlineError: function hideInlineError($element) {
            $element.parent().find(".error").hide();
        },

        hideInlineErrorForName: function hideInlineErrorForName() {
            this.hideInlineError(this.nameElement);
        },

        hideInlineErrorForKey: function hideInlineErrorForKey() {
            this.hideInlineError(this.keyElement);
        },

        setName: function setName(value) {
            this.nameElement.val(value);
        },

        getName: function getName() {
            return this.nameElement.val();
        },

        setKey: function setKey(value) {
            this.keyElement.val(value);
        },

        getKey: function getKey() {
            return this.keyElement.val().toUpperCase();
        },

        getLeadDisplayName: function getLeadDisplayName() {
            return this.leadDisplayElement.val();
        },

        getLeadUserName: function getLeadUserName() {
            return this.leadValueElement.val();
        },

        getAvatarUrlOfSelectedLead: function getAvatarUrlOfSelectedLead() {
            var userAvatarBackGroundProperty = DialogController.$dialogElement.find("#lead-single-select .aui-ss-entity-icon").css('background-image');
            if (!_.isUndefined(userAvatarBackGroundProperty)) {
                var userAvatarUrl = userAvatarBackGroundProperty.match(/^url\((.+)\)$/);
                return (userAvatarUrl && userAvatarUrl[1]) ? userAvatarUrl[1] : "";
            } else {
                return "";
            }
        },

        setKeyEdited: function setKeyEdited(value) {
            this.keyEditedElement.val(value);
        },

        getKeyEdited: function getKeyEdited() {
            return this.keyEditedElement.val();
        },

        setKeyEdited: function setKeyEdited() {
            var key = this.getKey();
            // If the key is manually edited, do not suggest automatically generated keys anymore
            // If the key field is cleared, resume suggesting automatically generated keys
            if (this.keyElement.data("lastValue") !== key) {
                this.keyEditedElement.val((key) ? "true" : "false");
            }
            this.keyElement.data("lastValue", key);
        },

        hasNameErrors: function hasNameErrors() {
            return this.nameElement.parent().find(".error").size() > 0;
        },

        getAddProjectForm: function getAddProjectForm() {
            return $("#add-project-form");
        },

        get$FormFields: function getFormFields() {
            return DialogController.$dialogElement.find(":input");
        },

        enterLoadingState: function showLoadingState() {
            $submitButton = this.get$SubmitButton();
            if (!$submitButton.attr("disabled")) {
                $backButton = this.get$BackButton();
                $submitButton.attr("disabled", "disabled");
                $backButton.attr("disabled", "disabled");
                $backButton.before(
                    JIRA.Templates.ProjectTemplates.spinner({
                        id: "addproject-loading"
                    }));
                this.get$FormFields().attr('disabled', 'disabled');

                this.isSubmitting = true;

                return true;
            } else {
                return false;
            }
        },

        hideLoadingState: function hideLoadingState() {
            DialogController.$dialogElement.find("#addproject-loading").remove();
            this.get$SubmitButton().removeAttr('disabled');
            this.get$BackButton().removeAttr('disabled');
            this.get$FormFields().removeAttr('disabled');
        },

        avoidDirtyFormWarning: function avoidDirtyFormWarning() {
            if ($.fn.removeDirtyWarning) {
                this.getAddProjectForm().removeDirtyWarning();
            }
        },

        hasInlineErrors: function hasInlineErrors() {
            return DialogController.$dialogElement.find(".field-group .error:visible").length != 0;
        }

    });
});
define('jira/project-templates/add-project-view', [
    'jira/project-templates/add-project-view-impl',
    'jira/project-templates/dialog-view',
    'jquery'
], function(
    AddProjectViewImpl,
    DialogView,
    $
) {
    return new AddProjectViewImpl({
        el: $(document),
        dialogView: DialogView
    });
});

AJS.namespace('JPT.AddProjectView', null, require('jira/project-templates/add-project-view'));