/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.I18nTranslator;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.template.hook.ScreenTemplate;
import com.atlassian.jira.projecttemplates.service.CustomScreenService;
import com.atlassian.jira.projecttemplates.service.NameResolver;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomScreenServiceImpl
implements CustomScreenService {
    private static final Logger LOG = LoggerFactory.getLogger(CustomScreenServiceImpl.class);
    private final ProjectManager projectManager;
    private final FieldManager fieldManager;
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenManager fieldScreenManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final I18nTranslator i18nTranslator;
    private final NameResolver nameResolver;

    public CustomScreenServiceImpl(ProjectManager projectManager, FieldManager fieldManager, FieldScreenFactory fieldScreenFactory, FieldScreenManager fieldScreenManager, FieldLayoutManager fieldLayoutManager, I18nTranslator i18nTranslator, NameResolver nameResolver) {
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.fieldScreenFactory = fieldScreenFactory;
        this.fieldScreenManager = fieldScreenManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.i18nTranslator = i18nTranslator;
        this.nameResolver = nameResolver;
    }

    @Override
    public FieldScreen create(String projectKey, ScreenTemplate template) {
        FieldScreen screen = this.fieldScreenFactory.createScreen();
        String name = this.nameResolver.getUniqueName(projectKey, template.name(), new IsScreenNameUnique());
        String description = this.i18nTranslator.getSystemTranslation(template.description());
        screen.setName(name);
        screen.setDescription(description);
        screen.store();
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        Set<String> projectRequiredFields = this.getProjectRequiredFields(project);
        template.tabs().stream().forEach(tabTemplate -> this.addScreenTab(screen, tabTemplate.name(), (Set<String>)Sets.union((Set)projectRequiredFields, (Set)Sets.newHashSet((Iterable)tabTemplate.fields()))));
        return screen;
    }

    private Set<String> getProjectRequiredFields(Project project) {
        List issueTypes = project.getIssueTypes().stream().map(issueType -> issueType.getId()).collect(Collectors.toList());
        return this.fieldLayoutManager.getUniqueFieldLayouts(project).stream().flatMap(fieldLayout -> fieldLayout.getRequiredFieldLayoutItems(project, issueTypes).stream()).map(fieldLayoutItem -> fieldLayoutItem.getOrderableField().getId()).collect(Collectors.toSet());
    }

    private void addScreenTab(FieldScreen screen, String tabName, Set<String> fieldsToAdd) {
        FieldScreenTab tab = screen.addTab(this.i18nTranslator.getSystemTranslation(tabName));
        for (String fieldId : fieldsToAdd) {
            if (this.fieldManager.getField(fieldId) != null) {
                tab.addFieldScreenLayoutItem(fieldId);
                continue;
            }
            LOG.warn("Field '{}' was not found and was not added to screen", (Object)fieldId);
        }
    }

    private class IsScreenNameUnique
    implements Predicate<String> {
        private IsScreenNameUnique() {
        }

        public boolean apply(String name) {
            for (FieldScreen screen : CustomScreenServiceImpl.this.fieldScreenManager.getFieldScreens()) {
                if (!name.equals(screen.getName())) continue;
                return false;
            }
            return true;
        }
    }
}

