/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.I18nTranslator;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.project.template.hook.ResolutionTemplate;
import com.atlassian.jira.projecttemplates.service.CustomResolutionService;
import java.util.ArrayList;
import java.util.Collection;

public class CustomResolutionServiceImpl
implements CustomResolutionService {
    private final ResolutionManager resolutionManager;
    private final I18nTranslator i18nTranslator;

    public CustomResolutionServiceImpl(ResolutionManager resolutionManager, I18nTranslator i18nTranslator) {
        this.resolutionManager = resolutionManager;
        this.i18nTranslator = i18nTranslator;
    }

    @Override
    public Collection<Resolution> configureResolutions(Collection<ResolutionTemplate> resolutionTemplates) {
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        if (resolutionTemplates != null) {
            for (ResolutionTemplate resolutionTemplate : resolutionTemplates) {
                String name = this.i18nTranslator.getSystemTranslation(resolutionTemplate.name());
                Resolution resolution = this.resolutionManager.getResolutionByName(name);
                if (resolution == null) {
                    String description = this.i18nTranslator.getSystemTranslation(resolutionTemplate.description());
                    resolution = this.resolutionManager.createResolution(name, description);
                }
                resolutions.add(resolution);
            }
        }
        return resolutions;
    }
}

