/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.CroppingAvatarImageDataProviderFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.template.hook.IssueTypeTemplate;
import com.atlassian.jira.projecttemplates.service.CustomAvatarService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public class CustomAvatarServiceImpl
implements CustomAvatarService {
    private final ApplicationProperties applicationProperties;
    private final AvatarManager avatarManager;
    private final CroppingAvatarImageDataProviderFactory imageDataProviderFactory;

    public CustomAvatarServiceImpl(ApplicationProperties applicationProperties, AvatarManager avatarManager, CroppingAvatarImageDataProviderFactory imageDataProviderFactory) {
        this.applicationProperties = applicationProperties;
        this.avatarManager = avatarManager;
        this.imageDataProviderFactory = imageDataProviderFactory;
    }

    @Override
    public Long getOrCreateAvatar(IssueTypeTemplate issueTypeTemplate, IssueType issueType) {
        return issueTypeTemplate.avatar().flatMap(this::getSystemAvatar).flatMap(avatar -> Optional.ofNullable(avatar.getId())).orElseGet(() -> this.createAvatar(issueTypeTemplate, issueType));
    }

    @Override
    public Long createAvatar(IssueTypeTemplate issueTypeTemplate, IssueType issueType) {
        Avatar avatar;
        URL iconUrl = issueTypeTemplate.iconUrl();
        if (iconUrl == null) {
            return this.getDefaultAvatarId(issueTypeTemplate);
        }
        InputStream iconStream = null;
        try {
            iconStream = iconUrl.openStream();
            AvatarImageDataProvider imageDataProvider = this.imageDataProviderFactory.createStreamsFrom(iconStream, null);
            avatar = this.avatarManager.create(Avatar.Type.ISSUETYPE, issueType.getId(), imageDataProvider);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while saving the avatar", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)iconStream);
        }
        return avatar.getId();
    }

    private Optional<Avatar> getSystemAvatar(@Nonnull String avatarFileName) {
        return this.getAllSystemAvatars().stream().filter(avatar -> avatarFileName.equals(avatar.getFileName())).findAny();
    }

    private List<Avatar> getAllSystemAvatars() {
        return this.avatarManager.getAllSystemAvatars(Avatar.Type.ISSUETYPE);
    }

    private Long getDefaultAvatarId(IssueTypeTemplate issueTypeTemplate) {
        String defaultAvatarIdKey = issueTypeTemplate.isSubtask() ? "jira.avatar.issuetype.subtask.default.id" : "jira.avatar.issuetype.default.id";
        return Long.valueOf(this.applicationProperties.getString(defaultAvatarIdKey));
    }
}

