/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCreateHandler;
import com.atlassian.jira.project.ProjectCreatedData;
import com.atlassian.jira.project.template.ProjectTemplate;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.template.ProjectTemplateManager;
import com.atlassian.jira.project.template.hook.AddProjectHook;
import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.ConfigureData;
import com.atlassian.jira.projecttemplates.events.ProjectCreatedFromProjectTemplateEvent;
import com.atlassian.jira.projecttemplates.service.AppliedTemplateStorage;
import com.atlassian.jira.projecttemplates.service.ProjectConfigurationService;
import java.util.Optional;

public class ApplyProjectTemplateHandler
implements ProjectCreateHandler {
    private final ProjectTemplateManager projectTemplateManager;
    private final ProjectConfigurationService projectConfigurationService;
    private final AppliedTemplateStorage appliedTemplateStorage;
    private final EventPublisher eventPublisher;

    public ApplyProjectTemplateHandler(ProjectTemplateManager projectTemplateManager, ProjectConfigurationService projectConfigurationService, AppliedTemplateStorage appliedTemplateStorage, EventPublisher eventPublisher) {
        this.projectTemplateManager = projectTemplateManager;
        this.projectConfigurationService = projectConfigurationService;
        this.appliedTemplateStorage = appliedTemplateStorage;
        this.eventPublisher = eventPublisher;
    }

    public String getHandlerId() {
        return "com.atlassian.jira.project-templates-plugin:apply-project-template-handler";
    }

    public void onProjectCreated(ProjectCreatedData projectCreatedData) throws CreateException {
        Optional templateKey = projectCreatedData.getProjectTemplateKey();
        if (!templateKey.isPresent()) {
            return;
        }
        Optional projectTemplate = this.projectTemplateManager.getProjectTemplate((ProjectTemplateKey)templateKey.get());
        if (!projectTemplate.isPresent()) {
            return;
        }
        this.applyProjectTemplate(projectCreatedData.getProject(), (ProjectTemplate)projectTemplate.get());
    }

    private void applyProjectTemplate(Project project, ProjectTemplate projectTemplate) {
        ConfigureData configureData = this.configureProject(project, projectTemplate);
        ProjectTemplateKey templateKey = projectTemplate.getKey();
        String templateKeyString = templateKey.getKey();
        this.appliedTemplateStorage.add(project.getId(), templateKeyString, templateKeyString);
        this.eventPublisher.publish((Object)new ProjectCreatedFromProjectTemplateEvent(templateKeyString, templateKeyString));
        AddProjectHook addProjectHook = projectTemplate.getAddProjectHook();
        addProjectHook.configure(configureData);
    }

    private ConfigureData configureProject(Project project, ProjectTemplate projectTemplate) {
        ConfigTemplate configTemplate = null;
        if (projectTemplate.hasAddProjectModule() && projectTemplate.addProjectModule().hasConfigTemplate()) {
            configTemplate = projectTemplate.addProjectModule().configTemplate();
        }
        return this.projectConfigurationService.configure(project, configTemplate);
    }

    public void onProjectCreationRolledBack(ProjectCreatedData projectCreatedData) {
    }
}

