/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.projecttemplates.querydsl.AppliedTemplate;
import com.atlassian.jira.projecttemplates.querydsl.QAppliedTemplate;
import com.atlassian.jira.projecttemplates.service.AppliedTemplateStorage;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Objects;

public class AppliedTemplateStorageImpl
implements AppliedTemplateStorage {
    private final DatabaseAccessor databaseAccessor;

    public AppliedTemplateStorageImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = Objects.requireNonNull(databaseAccessor);
    }

    @Override
    public AppliedTemplate add(long projectId, String webItemKey, String moduleKey) {
        return (AppliedTemplate)this.databaseAccessor.runInTransaction(databaseConnection -> {
            QAppliedTemplate qAppliedTemplate = new QAppliedTemplate();
            Integer id = (Integer)databaseConnection.insert((RelationalPath)qAppliedTemplate).set(qAppliedTemplate.PROJECT_ID, (Object)projectId).set((Path)qAppliedTemplate.PROJECT_TEMPLATE_MODULE_KEY, (Object)moduleKey).set((Path)qAppliedTemplate.PROJECT_TEMPLATE_WEB_ITEM_KEY, (Object)webItemKey).executeWithKey(qAppliedTemplate.ID);
            return new AppliedTemplate(id, projectId, moduleKey, webItemKey);
        });
    }

    @Override
    public AppliedTemplate getByProjectId(long projectId) {
        return (AppliedTemplate)this.databaseAccessor.runInTransaction(databaseConnection -> {
            QAppliedTemplate qAppliedTemplate = new QAppliedTemplate();
            Tuple ret = (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])qAppliedTemplate.all()).from((Expression)qAppliedTemplate)).where((Predicate)qAppliedTemplate.PROJECT_ID.eq((Object)projectId))).fetchOne();
            if (ret != null) {
                return new AppliedTemplate((Integer)ret.get(qAppliedTemplate.ID), projectId, (String)ret.get((Expression)qAppliedTemplate.PROJECT_TEMPLATE_MODULE_KEY), (String)ret.get((Expression)qAppliedTemplate.PROJECT_TEMPLATE_WEB_ITEM_KEY));
            }
            return new AppliedTemplate(null, null, null, null);
        });
    }
}

