/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.rest;

import com.atlassian.jira.project.template.module.DemoProjectModule;
import com.atlassian.jira.projecttemplates.rest.ProjectCreationBean;
import com.atlassian.jira.util.I18nHelper;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class DemoProjectBean
implements ProjectCreationBean {
    private final String key;
    private final String name;
    private final String description;
    private final String longDescription;
    private final String iconUrl;
    private final String backgroundIconUrl;
    private final String projectTypeKey;
    private final int weight;

    public DemoProjectBean(String key, String name, String description, String longDescription, String iconUrl, String backgroundIconUrl, String projectTypeKey, int weight) {
        this.key = key;
        this.name = name;
        this.description = description;
        this.longDescription = longDescription;
        this.iconUrl = iconUrl;
        this.backgroundIconUrl = backgroundIconUrl;
        this.projectTypeKey = projectTypeKey;
        this.weight = weight;
    }

    public static DemoProjectBean fromModule(I18nHelper i18n, DemoProjectModule module) {
        return new DemoProjectBean(module.getKey(), i18n.getText(module.getLabelKey()), i18n.getText(module.getDescriptionKey()), module.getLongDescriptionKey().map(arg_0 -> ((I18nHelper)i18n).getText(arg_0)).orElse(null), module.getIconUrl(), module.getBackgroundIconUrl().orElse(null), module.getProjectTypeKey().orElse(null), module.getWeight());
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLongDescriptionContent() {
        return this.longDescription;
    }

    @Override
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Override
    public String getBackgroundIconUrl() {
        return this.backgroundIconUrl;
    }

    @Override
    public String getItemModuleCompleteKey() {
        return this.key;
    }

    @Override
    public String getProjectTypeKey() {
        return this.projectTypeKey;
    }

    @Override
    public Boolean getCreateProject() {
        return true;
    }

    @Override
    public boolean isDemoProject() {
        return true;
    }
}

