/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.model;

import java.util.Objects;
import java.util.Optional;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class ApplicationInfoBean {
    private final Optional<Integer> licenseTotalSeats;
    private final Optional<Integer> licenseUsedSeats;
    private final boolean isOnDemand;
    private final boolean canUserUseApplication;
    private final boolean canUserBeAddedToApplication;
    private final Optional<String> applicationName;

    public ApplicationInfoBean(Optional<Integer> licenseTotalSeats, Optional<Integer> licenseUsedSeats, boolean isOnDemand, boolean userCanUseApplication, boolean userCanBeAddedToApplication, Optional<String> applicationName) {
        this.licenseTotalSeats = licenseTotalSeats;
        this.licenseUsedSeats = licenseUsedSeats;
        this.canUserUseApplication = userCanUseApplication;
        this.canUserBeAddedToApplication = userCanBeAddedToApplication;
        this.applicationName = applicationName;
        this.isOnDemand = isOnDemand;
    }

    @JsonProperty
    public int getLicenseTotalSeats() {
        return this.licenseTotalSeats.orElse(0);
    }

    @JsonProperty
    public int getLicenseUsedSeats() {
        return this.licenseUsedSeats.orElse(0);
    }

    @JsonProperty
    public boolean canUserUseApplication() {
        return this.canUserUseApplication;
    }

    @JsonProperty
    public boolean canUserBeAddedToApplication() {
        return this.canUserBeAddedToApplication;
    }

    @JsonProperty
    public String getApplicationName() {
        return this.applicationName.orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationInfoBean that = (ApplicationInfoBean)o;
        return Objects.equals(this.canUserUseApplication, that.canUserUseApplication) && Objects.equals(this.canUserBeAddedToApplication, that.canUserBeAddedToApplication) && Objects.equals(this.licenseTotalSeats, that.licenseTotalSeats) && Objects.equals(this.licenseUsedSeats, that.licenseUsedSeats) && Objects.equals(this.isOnDemand, that.isOnDemand);
    }

    public int hashCode() {
        return Objects.hash(this.licenseTotalSeats, this.licenseUsedSeats, this.canUserUseApplication, this.canUserBeAddedToApplication);
    }

    public boolean isOndemand() {
        return this.isOnDemand;
    }
}

