/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates;

import com.atlassian.jira.project.ProjectCreateHandler;
import com.atlassian.jira.project.ProjectCreateRegistrar;
import com.atlassian.jira.projecttemplates.service.ApplyProjectTemplateHandler;
import com.atlassian.jira.projecttemplates.service.BusinessProjectSearchRequestGeneratorHandler;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher
implements LifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(Launcher.class);
    private final ProjectCreateRegistrar projectCreateRegistrar;
    private final ApplyProjectTemplateHandler applyProjectTemplateHandler;
    private final BusinessProjectSearchRequestGeneratorHandler businessProjectSearchRequestGeneratorHandler;

    public Launcher(ProjectCreateRegistrar projectCreateRegistrar, ApplyProjectTemplateHandler applyProjectTemplateHandler, BusinessProjectSearchRequestGeneratorHandler businessProjectSearchRequestGeneratorHandler) {
        this.projectCreateRegistrar = projectCreateRegistrar;
        this.applyProjectTemplateHandler = applyProjectTemplateHandler;
        this.businessProjectSearchRequestGeneratorHandler = businessProjectSearchRequestGeneratorHandler;
    }

    public void onStart() {
        try {
            this.registerProjectCreateHandlers();
        }
        catch (Exception ex) {
            LOG.error("Unexpected error during project template plugin launch", (Throwable)ex);
        }
    }

    public void onStop() {
        try {
            this.unregisterProjectCreateHandlers();
        }
        catch (Exception ex) {
            LOG.error("Unexpected error during project template plugin shutdown", (Throwable)ex);
        }
    }

    private void registerProjectCreateHandlers() {
        this.projectCreateRegistrar.register((ProjectCreateHandler)this.applyProjectTemplateHandler);
        this.projectCreateRegistrar.register((ProjectCreateHandler)this.businessProjectSearchRequestGeneratorHandler);
    }

    private void unregisterProjectCreateHandlers() {
        this.projectCreateRegistrar.unregister((ProjectCreateHandler)this.applyProjectTemplateHandler);
        this.projectCreateRegistrar.unregister((ProjectCreateHandler)this.businessProjectSearchRequestGeneratorHandler);
    }
}

