/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.common.log.Logger;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.event.workflow.WorkflowDescriptorXmlUpdatedEvent;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projecttemplates.ao.AppliedTemplate;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class PTUpgradeTask2001
implements PluginUpgradeTask {
    public static final String WORKFLOW_ENTITY_NAME = "Workflow";
    public static final String PERMISSION_ASSIGNABLE = "assignable";
    private static final String PERMISSION_RESOLVE_ISSUES = "resolve";
    public static final String UPDATE_FIELD_FUNCTION = "com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction";
    public static final int EXPECTED_MAPPING_COUNT = 2;
    private static final Set<Integer> SOFTWARE_DONE_ACTIONS = Sets.newHashSet((Object[])new Integer[]{21, 151, 91});
    private static final Set<Integer> SOFTWARE_REOPENED_ACTIONS = Sets.newHashSet((Object[])new Integer[]{51, 61, 101});
    private static final Set<Integer> ISSUE_DONE_ACTIONS = Sets.newHashSet((Object[])new Integer[]{21, 41});
    private static final Set<Integer> ISSUE_REOPENED_ACTIONS = Sets.newHashSet((Object[])new Integer[]{51, 61});
    private static final Set<Integer> ALL_ISSUE_ACTIONS = Sets.newHashSet((Object[])new Integer[]{1, 11, 21, 31, 41, 51, 61});
    private static final Set<Integer> ISSUE_ASSIGNABLE_ONLY_ACTIONS = Sets.newHashSet((Object[])new Integer[]{11, 21, 31, 41, 51, 61});
    private static final Set<Integer> SOFTWARE_ASSIGNABLE_ONLY_ACTIONS = Sets.newHashSet((Object[])new Integer[]{11, 131, 71, 161, 61, 101, 171, 181});
    private static final Set<Integer> SOFTWARE_RESOLVABLE_ONLY_ACTIONS = Sets.newHashSet((Object[])new Integer[]{21, 151, 51, 91});
    private static final Set<Integer> ALL_SOFTWARE_ACTIONS = Sets.newHashSet((Object[])new Integer[]{1, 11, 21, 131, 71, 151, 161, 51, 61, 101, 91, 171, 181});
    private static final Predicate<Object> UPDATES_FIELD_PREDICATE = new UpdatesFieldPredicate();
    private final ActiveObjects ao;
    private final WorkflowManager workflowManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final ProjectManager projectManager;
    private final ResolutionManager resolutionManager;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;
    private final DescriptorFactory factory;
    private final Logger.Log logger;
    private static Function<ActionDescriptor, Integer> ID_COLLECTOR = new Function<ActionDescriptor, Integer>(){

        public Integer apply(ActionDescriptor action) {
            return action.getId();
        }
    };
    private LazyReference<String> doneId = new LazyReference<String>(){

        protected String create() throws Exception {
            Resolution resolution = PTUpgradeTask2001.this.resolutionManager.getResolutionByName("Done");
            if (resolution == null) {
                resolution = PTUpgradeTask2001.this.resolutionManager.createResolution("Done", "");
            }
            return resolution.getId();
        }
    };

    public PTUpgradeTask2001(ActiveObjects ao, WorkflowManager workflowManager, WorkflowSchemeManager workflowSchemeManager, ProjectManager projectManager, ResolutionManager resolutionManager, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher) {
        this.ao = ao;
        this.workflowManager = workflowManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.projectManager = projectManager;
        this.resolutionManager = resolutionManager;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.factory = DescriptorFactory.getFactory();
        this.logger = Logger.getInstance(this.getClass());
    }

    public int getBuildNumber() {
        return 2001;
    }

    public String getShortDescription() {
        return "Reinstates resolution-setting post-functions and permissions that failed to persist to the database";
    }

    public Collection<Message> doUpgrade() throws Exception {
        for (Map.Entry<String, TemplateUsed> templateWorkflow : this.getProjectTemplateWorkflows().entrySet()) {
            boolean repairsMade;
            String workflowName = templateWorkflow.getKey();
            TemplateUsed templateType = templateWorkflow.getValue();
            Option<WorkflowDescriptor> descriptor = this.getDescriptorFor(workflowName);
            if (descriptor.isEmpty()) continue;
            if (templateType == TemplateUsed.SOFTWARE) {
                repairsMade = this.repairSoftwareWorkflow(workflowName, (WorkflowDescriptor)descriptor.get());
                if (repairsMade) {
                    this.saveDescriptorFor(workflowName, (WorkflowDescriptor)descriptor.get());
                    continue;
                }
                this.logger.info((Object)("The transitions in Software workflow " + workflowName + " do not match those expected, so this workflow will be skipped"));
                continue;
            }
            if (templateType != TemplateUsed.ISSUE) continue;
            repairsMade = this.repairIssueWorkflow(workflowName, (WorkflowDescriptor)descriptor.get());
            if (repairsMade) {
                this.saveDescriptorFor(workflowName, (WorkflowDescriptor)descriptor.get());
                continue;
            }
            this.logger.info((Object)("The transitions in Simple workflow " + workflowName + " do not match those expected, so this workflow will be skipped"));
        }
        return Collections.emptyList();
    }

    private boolean needsPermissions(WorkflowDescriptor descriptor, Set<Integer> actions) {
        for (int id : actions) {
            ActionDescriptor action = descriptor.getAction(id);
            if (action != null && action.getRestriction() == null) continue;
            return false;
        }
        return true;
    }

    private boolean needsFieldUpdates(WorkflowDescriptor descriptor, Set<Integer> actions) {
        for (int id : actions) {
            List postFunctions;
            ActionDescriptor action = descriptor.getAction(id);
            if (action == null) {
                return false;
            }
            ResultDescriptor unconditionalResult = action.getUnconditionalResult();
            if (unconditionalResult == null || (postFunctions = unconditionalResult.getPostFunctions()) == null || !Iterators.any(postFunctions.iterator(), UPDATES_FIELD_PREDICATE)) continue;
            return false;
        }
        return true;
    }

    private boolean transitionAddedOrRemoved(String workflowName, Set<Integer> expectedTransitionIds) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        HashSet actualTransitionIds = Sets.newHashSet((Iterator)Iterators.transform(workflow.getAllActions().iterator(), ID_COLLECTOR));
        return !expectedTransitionIds.equals(actualTransitionIds);
    }

    private boolean repairIssueWorkflow(String workflowName, WorkflowDescriptor descriptor) {
        if (this.transitionAddedOrRemoved(workflowName, ALL_ISSUE_ACTIONS)) {
            return false;
        }
        this.addMissingIssueFunctions(workflowName, descriptor);
        this.addMissingIssuePermissions(workflowName, descriptor);
        return true;
    }

    private boolean repairSoftwareWorkflow(String workflowName, WorkflowDescriptor descriptor) {
        if (this.transitionAddedOrRemoved(workflowName, ALL_SOFTWARE_ACTIONS)) {
            return false;
        }
        this.addMissingSoftwareFunctions(workflowName, descriptor);
        this.addMissingSoftwarePermissions(workflowName, descriptor);
        return true;
    }

    private void addMissingIssuePermissions(String workflowName, WorkflowDescriptor descriptor) {
        if (this.needsPermissions(descriptor, ISSUE_ASSIGNABLE_ONLY_ACTIONS)) {
            this.addPermissionsToActions(descriptor, ISSUE_ASSIGNABLE_ONLY_ACTIONS, PERMISSION_ASSIGNABLE);
        } else {
            this.logger.info((Object)("Found existing permissions on Simple workflow " + workflowName + ", so not adding any more."));
        }
    }

    private void addMissingIssueFunctions(String workflowName, WorkflowDescriptor descriptor) {
        if (this.needsFieldUpdates(descriptor, ISSUE_DONE_ACTIONS) && this.needsFieldUpdates(descriptor, ISSUE_REOPENED_ACTIONS)) {
            PTUpgradeTask2001.addFunctionsToActions(descriptor, ISSUE_DONE_ACTIONS, this.resolutionFunction((String)this.doneId.get()));
            PTUpgradeTask2001.addFunctionsToActions(descriptor, ISSUE_REOPENED_ACTIONS, this.resolutionFunction(""));
        } else {
            this.logger.info((Object)("Found existing field-setting post functions on Simple workflow " + workflowName + ", so not adding any more."));
        }
    }

    private void addMissingSoftwarePermissions(String workflowName, WorkflowDescriptor descriptor) {
        if (this.needsPermissions(descriptor, SOFTWARE_ASSIGNABLE_ONLY_ACTIONS) && this.needsPermissions(descriptor, SOFTWARE_RESOLVABLE_ONLY_ACTIONS)) {
            this.addPermissionsToActions(descriptor, SOFTWARE_ASSIGNABLE_ONLY_ACTIONS, PERMISSION_ASSIGNABLE);
            this.addPermissionsToActions(descriptor, SOFTWARE_RESOLVABLE_ONLY_ACTIONS, PERMISSION_RESOLVE_ISSUES);
        } else {
            this.logger.info((Object)("Found existing permissions on Software workflow " + workflowName + ", so not adding any more."));
        }
    }

    private void addMissingSoftwareFunctions(String workflowName, WorkflowDescriptor descriptor) {
        if (this.needsFieldUpdates(descriptor, SOFTWARE_DONE_ACTIONS) && this.needsFieldUpdates(descriptor, SOFTWARE_REOPENED_ACTIONS)) {
            PTUpgradeTask2001.addFunctionsToActions(descriptor, SOFTWARE_DONE_ACTIONS, this.resolutionFunction((String)this.doneId.get()));
            PTUpgradeTask2001.addFunctionsToActions(descriptor, SOFTWARE_REOPENED_ACTIONS, this.resolutionFunction(""));
        } else {
            this.logger.info((Object)("Found existing field-setting post functions on Software workflow " + workflowName + ", so not adding any more."));
        }
    }

    private void addPermissionsToActions(WorkflowDescriptor descriptor, Set<Integer> actions, String permission) {
        for (int actionId : actions) {
            ConditionsDescriptor conditions;
            ActionDescriptor action = descriptor.getAction(actionId);
            RestrictionDescriptor restriction = action.getRestriction();
            if (restriction == null) {
                restriction = new RestrictionDescriptor();
                action.setRestriction(restriction);
            }
            if ((conditions = restriction.getConditionsDescriptor()) == null) {
                conditions = this.factory.createConditionsDescriptor();
                restriction.setConditionsDescriptor(conditions);
            }
            conditions.getConditions().add(this.permissionDescriptor(permission));
        }
    }

    private static void addFunctionsToActions(WorkflowDescriptor descriptor, Set<Integer> actions, FunctionDescriptor function) {
        for (int actionId : actions) {
            ResultDescriptor unconditionalResult = descriptor.getAction(actionId).getUnconditionalResult();
            if (unconditionalResult == null) continue;
            unconditionalResult.getPostFunctions().add(function);
        }
    }

    private Option<WorkflowDescriptor> getDescriptorFor(String workflowName) {
        GenericValue workflowRow = (GenericValue)Iterators.getOnlyElement(this.ofBizDelegator.findByAnd(WORKFLOW_ENTITY_NAME, MapBuilder.build((Object)"name", (Object)workflowName)).iterator(), null);
        if (workflowRow == null) {
            return Option.none();
        }
        if (this.workflowManager.getDraftWorkflow(workflowName) != null) {
            this.logger.info((Object)("Template-based workflow " + workflowName + " has a draft, and so will be skipped"));
            return Option.none();
        }
        try {
            return Option.option((Object)WorkflowUtil.convertXMLtoWorkflowDescriptor((String)workflowRow.getString("descriptor")));
        }
        catch (FactoryException ignored) {
            return Option.none();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDescriptorFor(String workflowName, WorkflowDescriptor descriptor) {
        GenericValue workflowRow = (GenericValue)Iterators.getOnlyElement(this.ofBizDelegator.findByAnd(WORKFLOW_ENTITY_NAME, MapBuilder.build((Object)"name", (Object)workflowName)).iterator(), null);
        if (workflowRow == null) {
            return;
        }
        workflowRow.set("descriptor", (Object)WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)descriptor));
        try {
            this.logger.info((Object)("Repairing template-based workflow " + workflowName));
            workflowRow.store();
        }
        catch (GenericEntityException ignored) {
            this.logger.warn((Object)("Failed to update template-based workflow " + workflowName));
        }
        finally {
            this.eventPublisher.publish((Object)new WorkflowDescriptorXmlUpdatedEvent(workflowName));
        }
    }

    private FunctionDescriptor resolutionFunction(String resolutionId) {
        FunctionDescriptor descriptor = this.factory.createFunctionDescriptor();
        descriptor.setType("class");
        Map args = descriptor.getArgs();
        args.put("class.name", UPDATE_FIELD_FUNCTION);
        args.put("field.name", "resolution");
        args.put("field.value", resolutionId);
        return descriptor;
    }

    private ConditionDescriptor permissionDescriptor(String permission) {
        ConditionDescriptor descriptor = this.factory.createConditionDescriptor();
        descriptor.setType("class");
        Map args = descriptor.getArgs();
        args.put("class.name", "com.atlassian.jira.workflow.condition.PermissionCondition");
        args.put("permission", permission);
        return descriptor;
    }

    private Map<String, TemplateUsed> getProjectTemplateWorkflows() {
        AppliedTemplate[] appliedTemplates;
        HashMap workflows = Maps.newHashMap();
        for (AppliedTemplate appliedTemplate : appliedTemplates = (AppliedTemplate[])this.ao.find(AppliedTemplate.class)) {
            Project candidateProject;
            Option<String> workflowName;
            long projectId = appliedTemplate.getProjectId();
            TemplateUsed templateUsed = TemplateUsed.fromString(appliedTemplate.getProjectTemplateWebItemKey());
            if (templateUsed == TemplateUsed.OTHER || !(workflowName = this.getTemplateBasedWorkflowNameFor(candidateProject = this.projectManager.getProjectObj(Long.valueOf(projectId)))).isDefined()) continue;
            workflows.put(workflowName.get(), templateUsed);
        }
        return workflows;
    }

    private Option<String> getTemplateBasedWorkflowNameFor(Project candidateProject) {
        if (candidateProject == null) {
            return Option.none();
        }
        long projectId = candidateProject.getId();
        AssignableWorkflowScheme scheme = this.workflowSchemeManager.getWorkflowSchemeObj(candidateProject);
        Map mappings = scheme.getMappings();
        int mappingsSize = mappings.size();
        if (mappingsSize != 2) {
            return Option.none();
        }
        HashSet workflows = Sets.newHashSet();
        int templateMappingCount = 0;
        block0: for (String workflowName : mappings.values()) {
            for (String key : this.projectManager.getAllProjectKeys(Long.valueOf(projectId))) {
                if (!workflowName.startsWith(key + ": ")) continue;
                workflows.add(workflowName);
                ++templateMappingCount;
                continue block0;
            }
        }
        if (templateMappingCount == mappingsSize && workflows.size() == 1) {
            return Option.option((Object)Iterators.getOnlyElement(workflows.iterator()));
        }
        return Option.none();
    }

    public String getPluginKey() {
        return "com.atlassian.jira.project-templates-plugin";
    }

    private static class UpdatesFieldPredicate
    implements Predicate<Object> {
        private UpdatesFieldPredicate() {
        }

        public boolean apply(@Nullable Object object) {
            FunctionDescriptor functionDescriptor;
            Map args;
            return object instanceof FunctionDescriptor && (args = (functionDescriptor = (FunctionDescriptor)object).getArgs()) != null && PTUpgradeTask2001.UPDATE_FIELD_FUNCTION.equals(args.get("class.name"));
        }
    }

    private static enum TemplateUsed {
        ISSUE,
        SOFTWARE,
        OTHER;

        public static final String ISSUE_TRACKING_KEY = "com.atlassian.jira-core-project-templates:jira-issuetracking-item";
        public static final String SOFTWARE_KEY = "com.atlassian.jira-core-project-templates:jira-softwaredevelopment-item";

        static TemplateUsed fromString(String key) {
            if (ISSUE_TRACKING_KEY.equals(key)) {
                return ISSUE;
            }
            if (SOFTWARE_KEY.equals(key)) {
                return SOFTWARE;
            }
            return OTHER;
        }
    }
}

