(function() {
    AJS.namespace('JPT.test.Keyboard');

    JPT.test.Keyboard = {
        /**
         * Simulates a keyboard event.
         *
         * @param {jQuery} target
         * @param {object} [options]
         * @param {string} [options.event] the event to trigger (default: "keydown")
         * @param {number} [options.keyCode] the keyCode to trigger (default: 13/ENTER)
         */
        triggerEvent: function(target, options) {
            options = options || {};
            options.event = options.event || "keydown";
            options.keyCode = options.keyCode || 13;

            var enterEvent = jQuery.Event(options.event);
            enterEvent.which = options.keyCode;
            enterEvent.keyCode = options.keyCode;
            target.trigger(enterEvent);
        }
    }

})();
