JPT = {};

(function() {
    JPT.DialogControllerImpl = Class.extend({
        WELCOME_REST_URL: AJS.contextPath() + "/rest/welcome/1.0/show/welcome",

        initialize: function() {
            _.bindAll(this, 'handleProjectTemplateTriggered', 'openWithSelectedProjectTemplate', 'hideDialogFromNewUser');

            if (AJS.Meta.getBoolean('show-welcome-screen')) {
                this.handleProjectTemplateTriggered();
            }
        },

        handleProjectTemplateTriggered: function() {
            this.openWithSelectedProjectTemplate();
        },

        // CAREFUL!
        // THIS FUNCTION IS USED BY GREENHOPPER MARKETING TEMPLATES, CHANGING ITS SIGNATURE MAY BREAK THEM!!!
        openWithSelectedProjectTemplate: function(itemModuleCompleteKey) {
            // If we're coming from an existing PT dialog, remove this before creating a new one.
            if (itemModuleCompleteKey && this.dialog) {
                this.dialog.remove();
            }
            var projectTemplatesDeferred = JPT.SelectProjectTemplateController.loadProjectTemplatesData();

            projectTemplatesDeferred.fail(_.bind(function (jqXHR) {
                if (jqXHR.status === 401 && jqXHR.responseText.toLowerCase().indexOf("requires websudo") >= 0) {
                    this._enableWebSudo();
                } else {
                   this._handleUnknownErrorOfPTRetrieval();
                }
            }, this));

            projectTemplatesDeferred.done(_.bind(function (data) {
                this.dialog  = JPT.DialogView.draw();
                this.$dialogElement = this.dialog.popup.element;

                // Persist the selected template (e.g. after coming back from a GH installation)
                var selectedTemplate;
                if (!_.isUndefined(JPT.ConfigModel) && !_.isUndefined(JPT.ConfigModel.selectedTemplate)) {
                    selectedTemplate = JPT.ConfigModel.selectedTemplate;
                }
                JPT.ConfigModel = data;
                JPT.ConfigModel.selectedTemplate = selectedTemplate;
                JPT.SelectProjectTemplateController.init(data.projectTemplates, itemModuleCompleteKey);
            }, this));
        },

        addPage: function(pageConfig) {
            var page = this.dialog.addPage(pageConfig.name).page[this.dialog.curpage];
            this.dialog.addHeader(pageConfig.title, "add-project-dialog-header");
            this.dialog.addPanel(pageConfig.panelName, "", "pt-content");

            if (pageConfig.backButton) {
                this._addBackButton(page);
            }

            this.dialog.addButton(pageConfig.submitButtonText, pageConfig.submitButtonCallback, pageConfig.submitButtonClass + " pt-submit-button");
            var $submitButton = this.$dialogElement.find("." + pageConfig.submitButtonClass);
            $submitButton.removeClass("button-panel-button").addClass("aui-button aui-button-primary"); /* button-panel-button class doesn't have disabled styles, using .aui-button instead */

            this.dialog.addCancel(AJS.I18n.getText("add.project.cancel"), _.bind(function(event) {
                this.hideDialogFromNewUser("dismissed");

                this.dialog.remove();
            }, this));

            return page;
        },

        _addBackButton: function(page) {
            this.dialog.addButton(AJS.I18n.getText("admin.addproject.back"), _.bind(function() {
                var $addProjectWrapper = JPT.DialogView.get$PTContent();
                $addProjectWrapper.css('background-image', 'none');

                this.dialog.prevPage();
                page.remove();
                this.dialog.page.pop();
                }, this), "add-project-back-button");
            var $backButton = this.$dialogElement.find(".add-project-back-button");
            $backButton.removeClass("button-panel-button").addClass("aui-button");
        },

        _enableWebSudo: function() {
            JIRA.SmartAjax.showWebSudoDialog({
                success: _.bind(function(close) {
                    this.handleProjectTemplateTriggered();
                    close();
                }, this)
            });
        },

        _handleUnknownErrorOfPTRetrieval: function() {
            JPT.DialogView.draw();

            JPT.DialogView.showErrorMessage(AJS.I18n.getText("add.projects.templates.error.requestfailed.msg"));
        },

        hideDialogFromNewUser: function(reason) {
            if (AJS.Meta.getBoolean('show-welcome-screen')) {
                AJS.$.ajax({
                    url: this.WELCOME_REST_URL + "/" + reason,
                    type: "DELETE",
                    success: function () {
                        if (AJS.isDevMode && AJS.isDevMode()) {
                            AJS.log("don't show project template dialog anymore");
                        }
                    }
                });
            }
        }
    });

    JPT.DialogController = new JPT.DialogControllerImpl();
})();