/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.blueprint.api.AddProjectHook;
import com.atlassian.jira.blueprint.api.ApiAccessor;
import com.atlassian.jira.blueprint.api.ConfigureData;
import com.atlassian.jira.blueprint.api.ConfigureResponse;
import com.atlassian.jira.blueprint.api.ValidateData;
import com.atlassian.jira.blueprint.api.ValidateResponse;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projecttemplates.events.ProjectCreatedFromProjectTemplateEvent;
import com.atlassian.jira.projecttemplates.manager.ProjectTemplateManager;
import com.atlassian.jira.projecttemplates.model.ApplyTemplateParam;
import com.atlassian.jira.projecttemplates.model.IssueTypeSchemeCreationResult;
import com.atlassian.jira.projecttemplates.model.ProjectTemplate;
import com.atlassian.jira.projecttemplates.model.ProjectTemplateInstantiationResult;
import com.atlassian.jira.projecttemplates.model.RemoteProjectLinks;
import com.atlassian.jira.projecttemplates.model.RemoteProjectLinksBuilder;
import com.atlassian.jira.projecttemplates.model.WorkflowSchemeCreationResult;
import com.atlassian.jira.projecttemplates.service.AppliedTemplateStorage;
import com.atlassian.jira.projecttemplates.service.CustomIssueTypeSchemeService;
import com.atlassian.jira.projecttemplates.service.CustomWorkflowSchemeService;
import com.atlassian.jira.projecttemplates.service.ProjectTemplateService;
import com.atlassian.jira.projecttemplates.service.TemplateInstantiationFailure;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.ValidationFailureException;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ProjectTemplateServiceImpl
implements ProjectTemplateService {
    private final ProjectTemplateManager projectTemplateManager;
    private final CustomWorkflowSchemeService customWorkflowSchemeService;
    private final CustomIssueTypeSchemeService customIssueTypeSchemeService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final ProjectService projectService;
    private final EventPublisher eventPublisher;
    private final PermissionManager permissionManager;
    private final AppliedTemplateStorage appliedTemplateStorage;
    private final EntityLinkService entityLinkService;

    public ProjectTemplateServiceImpl(I18nResolver i18nResolver, ProjectService projectService, EventPublisher eventPublisher, PermissionManager permissionManager, AppliedTemplateStorage appliedTemplateStorage, EntityLinkService entityLinkService, ProjectTemplateManager projectTemplateManager, CustomWorkflowSchemeService customWorkflowSchemeService, CustomIssueTypeSchemeService customIssueTypeSchemeService, UserManager userManager) {
        this.i18nResolver = i18nResolver;
        this.projectService = projectService;
        this.eventPublisher = eventPublisher;
        this.permissionManager = permissionManager;
        this.appliedTemplateStorage = appliedTemplateStorage;
        this.entityLinkService = entityLinkService;
        this.projectTemplateManager = projectTemplateManager;
        this.customWorkflowSchemeService = customWorkflowSchemeService;
        this.customIssueTypeSchemeService = customIssueTypeSchemeService;
        this.userManager = userManager;
    }

    @Override
    public List<ProjectTemplate> getProjectTemplateItems(User user) {
        return this.projectTemplateManager.getProjectTemplates(user);
    }

    @Override
    public ProjectTemplateInstantiationResult applyProjectTemplate(ApplyTemplateParam applyTemplateParam) throws TemplateInstantiationFailure, ValidationFailureException {
        ProjectTemplate projectTemplate = this.projectTemplateManager.getProjectTemplate(applyTemplateParam.getProjectTemplateWebItemKey(), applyTemplateParam.getProjectTemplateModuleKey());
        if (projectTemplate == null) {
            throw new TemplateInstantiationFailure(this.i18nResolver.getText("admin.addproject.projectemplate.template.not.found"), "");
        }
        AddProjectHook addProjectHook = projectTemplate.getAddProjectHook();
        ProjectService.CreateProjectValidationResult projectTemplateValidationResult = this.validateProjectTemplateInstantiation(applyTemplateParam, addProjectHook);
        Project project = this.projectService.createProject(projectTemplateValidationResult);
        IssueTypeSchemeCreationResult issueTypeSchemeCreationResult = new IssueTypeSchemeCreationResult();
        WorkflowSchemeCreationResult workflowSchemeCreationResult = new WorkflowSchemeCreationResult();
        if (projectTemplate.hasAddProjectModule() && projectTemplate.addProjectModule().hasConfigTemplate()) {
            issueTypeSchemeCreationResult = this.customIssueTypeSchemeService.configureCustomIssueTypeSchemeForProjectFromTemplate(project, projectTemplate.addProjectModule().configTemplate().issueTypeSchemeTemplate());
            workflowSchemeCreationResult = this.customWorkflowSchemeService.configureCustomWorkflowSchemeForProjectFromTemplate(project, projectTemplate.addProjectModule().configTemplate(), issueTypeSchemeCreationResult.getCreatedIssueTypes());
        }
        this.appliedTemplateStorage.add(project.getId(), applyTemplateParam.getProjectTemplateWebItemKey(), projectTemplate.getProjectTemplateModuleCompleteKey());
        this.eventPublisher.publish((Object)new ProjectCreatedFromProjectTemplateEvent(applyTemplateParam.getProjectTemplateWebItemKey(), projectTemplate.getProjectTemplateModuleCompleteKey()));
        String redirectUrl = "";
        try {
            ConfigureResponse resp = addProjectHook.configure(this.createConfigureData(project, workflowSchemeCreationResult, issueTypeSchemeCreationResult));
            redirectUrl = StringUtils.defaultString((String)resp.getRedirect());
        }
        catch (Exception e) {
            throw new TemplateInstantiationFailure(this.i18nResolver.getText("admin.addproject.projectemplate.configuration.error"), this.getDefaultRedirectURL(project.getKey()), e);
        }
        return new ProjectTemplateInstantiationResult(this.getValidRedirectUrl(redirectUrl, project.getKey()), project.getId(), project.getKey(), project.getName(), this.getRemoteProjectLinks(project));
    }

    private ProjectService.CreateProjectValidationResult validateProjectTemplateInstantiation(ApplyTemplateParam template, AddProjectHook addProjectHook) {
        if (!this.permissionManager.hasPermission(0, template.getCurrentUser())) {
            throw new ValidationFailureException(this.createSingleError(this.i18nResolver.getText("admin.projects.service.error.no.admin.permission")));
        }
        ProjectService.CreateProjectValidationResult createProjectValidationResult = this.projectService.validateCreateProject(template.getCurrentUser().getDirectoryUser(), template.getProjectName(), template.getProjectKey(), template.getProjectDescription(), template.getLeadName(), template.getUrl(), template.getAssigneeType());
        ErrorCollection projectValidationErrors = createProjectValidationResult.getErrorCollection();
        ValidateResponse response = addProjectHook.validate(this.createValidateData(template));
        ErrorCollection templateValidationErrorCollection = ApiAccessor.toErrorCollection(response);
        projectValidationErrors.addErrorCollection(templateValidationErrorCollection);
        if (projectValidationErrors.hasAnyErrors()) {
            throw new ValidationFailureException(projectValidationErrors);
        }
        return createProjectValidationResult;
    }

    public RemoteProjectLinks getRemoteProjectLinks(Project project) {
        Iterable entityLinks = this.entityLinkService.getEntityLinks((Object)project);
        RemoteProjectLinksBuilder remoteProjectLinksBuilder = new RemoteProjectLinksBuilder();
        for (EntityLink entityLink : entityLinks) {
            remoteProjectLinksBuilder = remoteProjectLinksBuilder.addEntityLink(entityLink);
        }
        RemoteProjectLinks build = remoteProjectLinksBuilder.build();
        return build;
    }

    private String getValidRedirectUrl(String redirectUrl, String projectKey) {
        return StringUtils.defaultIfEmpty((String)redirectUrl, (String)this.getDefaultRedirectURL(projectKey));
    }

    private String getDefaultRedirectURL(String projectKey) {
        return "/browse/" + projectKey + "#selectedTab=com.atlassian.jira.plugin.system.project%3Asummary-panel";
    }

    private ErrorCollection createSingleError(String message) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message);
        return errorCollection;
    }

    private ConfigureData createConfigureData(Project project, WorkflowSchemeCreationResult workflowResult, IssueTypeSchemeCreationResult issueTypeResult) {
        return ConfigureData.create((Project)project, (Scheme)workflowResult.getCreatedWorklowScheme(), workflowResult.getCreatedWorkflows(), (FieldConfigScheme)issueTypeResult.getCreatedIssueTypeScheme(), issueTypeResult.getCreatedIssueTypes());
    }

    private ValidateData createValidateData(ApplyTemplateParam param) {
        String leadName = param.getLeadName();
        ApplicationUser lead = this.userManager.getUserByKey(leadName);
        return new ValidateData(param.getProjectName(), param.getProjectKey(), lead);
    }
}

