/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.ConfigTemplate;
import com.atlassian.jira.blueprint.template.IssueTypeTemplate;
import com.atlassian.jira.blueprint.template.WorkflowTemplate;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugins.workflow.sharing.importer.JiraWorkflowSharingImporter;
import com.atlassian.jira.plugins.workflow.sharing.importer.SharedWorkflowImportPlan;
import com.atlassian.jira.plugins.workflow.sharing.importer.StatusMapping;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowImporterFactory;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowStatusHelper;
import com.atlassian.jira.plugins.workflow.sharing.model.StatusInfo;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projecttemplates.model.WorkflowSchemeCreationResult;
import com.atlassian.jira.projecttemplates.service.CustomWorkflowSchemeService;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomWorkflowSchemeServiceImpl
implements CustomWorkflowSchemeService {
    private static final Logger log = LoggerFactory.getLogger(CustomWorkflowSchemeService.class);
    private static final int MAX_NAME_LENGTH = 250;
    private final SharedWorkflowImportPlanFactoryHelper sharedWorkflowImportPlanFactoryHelper;
    private final WorkflowBundle.Factory workflowBundleFactory;
    private final WorkflowImporterFactory workflowImporterFactory;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final WorkflowStatusHelper workflowStatusHelper;
    private final I18nResolver i18nResolver;
    private final ApplicationProperties applicationProperties;

    public CustomWorkflowSchemeServiceImpl(WorkflowBundle.Factory workflowBundleFactory, WorkflowImporterFactory workflowImporterFactory, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, WorkflowStatusHelper workflowStatusHelper, I18nResolver i18nResolver, ApplicationProperties applicationProperties) {
        this(new SharedWorkflowImportPlanFactoryHelper(), workflowBundleFactory, workflowImporterFactory, workflowSchemeManager, workflowManager, workflowStatusHelper, i18nResolver, applicationProperties);
    }

    @VisibleForTesting
    CustomWorkflowSchemeServiceImpl(SharedWorkflowImportPlanFactoryHelper sharedWorkflowImportPlanFactoryHelper, WorkflowBundle.Factory workflowBundleFactory, WorkflowImporterFactory workflowImporterFactory, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, WorkflowStatusHelper workflowStatusHelper, I18nResolver i18nResolver, ApplicationProperties applicationProperties) {
        this.sharedWorkflowImportPlanFactoryHelper = sharedWorkflowImportPlanFactoryHelper;
        this.workflowBundleFactory = workflowBundleFactory;
        this.workflowImporterFactory = workflowImporterFactory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.workflowStatusHelper = workflowStatusHelper;
        this.i18nResolver = i18nResolver;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public WorkflowSchemeCreationResult configureCustomWorkflowSchemeForProjectFromTemplate(Project project, ConfigTemplate configTemplate, Map<String, IssueType> issueTypeMap) {
        if (!configTemplate.hasWorkflowSchemeTemplate()) {
            return new WorkflowSchemeCreationResult();
        }
        HashMap createdWorkflowMap = Maps.newHashMap();
        for (WorkflowTemplate workflowTemplate : configTemplate.workflowSchemeTemplate().workflowTemplates()) {
            JiraWorkflow workflow = this.importWorkflow(project.getKey(), workflowTemplate);
            if (workflow == null) {
                return new WorkflowSchemeCreationResult();
            }
            createdWorkflowMap.put(workflowTemplate.key(), workflow);
        }
        Scheme workflowScheme = this.createWorkflowScheme(configTemplate, issueTypeMap, createdWorkflowMap, project.getKey());
        if (workflowScheme == null) {
            return new WorkflowSchemeCreationResult();
        }
        this.workflowSchemeManager.addSchemeToProject(project, workflowScheme);
        return new WorkflowSchemeCreationResult(workflowScheme, createdWorkflowMap);
    }

    private Scheme createWorkflowScheme(ConfigTemplate configTemplate, Map<String, IssueType> issueTypeMap, Map<String, JiraWorkflow> createdWorkflowMap, String projectKey) {
        String finalWorkflowSchemeName = this.getWorkflowSchemeNameForProjectKey(configTemplate.workflowSchemeTemplate().name(), projectKey);
        Scheme workflowSchemeObject = this.workflowSchemeManager.createSchemeObject(finalWorkflowSchemeName, this.getSystemTranslationForValue(configTemplate.workflowSchemeTemplate().description()));
        try {
            GenericValue workflowSchemeGV = this.workflowSchemeManager.getScheme(workflowSchemeObject.getId());
            if (configTemplate.hasIssueTypeSchemeTemplate()) {
                Preconditions.checkNotNull(issueTypeMap);
                for (IssueTypeTemplate issueTypeTemplate : configTemplate.issueTypeSchemeTemplate().issueTypeTemplates()) {
                    if (!issueTypeTemplate.hasWorkflow()) continue;
                    this.workflowSchemeManager.addWorkflowToScheme(workflowSchemeGV, createdWorkflowMap.get(issueTypeTemplate.workflow()).getName(), issueTypeMap.get(issueTypeTemplate.key()).getId());
                }
            }
            if (configTemplate.workflowSchemeTemplate().defaultWorkflow() != null) {
                JiraWorkflow defaultWorkflow = createdWorkflowMap.get(configTemplate.workflowSchemeTemplate().defaultWorkflow());
                this.workflowSchemeManager.addWorkflowToScheme(workflowSchemeGV, defaultWorkflow.getName(), "0");
            }
        }
        catch (GenericEntityException e) {
            log.error("Error while creating Workflow Scheme: {}", (Object)e.getMessage());
            return null;
        }
        return workflowSchemeObject;
    }

    private String getWorkflowSchemeNameForProjectKey(String workflowSchemeName, String projectKey) {
        String proposedName = projectKey + ": " + this.getSystemTranslationForValue(workflowSchemeName);
        if (proposedName.length() > 250) {
            proposedName = proposedName.substring(0, 250);
        }
        return this.getUniqueWorkflowSchemeName(proposedName);
    }

    private String getUniqueWorkflowSchemeName(String proposedName) {
        String wfsName = proposedName;
        int counter = 1;
        while (this.workflowSchemeManager.getWorkflowSchemeObj(wfsName) != null) {
            wfsName = proposedName + " (" + counter + ")";
            ++counter;
        }
        return wfsName;
    }

    private JiraWorkflow importWorkflow(String projectKey, WorkflowTemplate workflowTemplate) {
        WorkflowBundle workflowBundle = this.importWorkflowBundle(workflowTemplate);
        if (workflowBundle == null) {
            return null;
        }
        SharedWorkflowImportPlan sharedWorkflowImportPlan = this.sharedWorkflowImportPlanFactoryHelper.getSharedWorkflowImportPlan(workflowBundle);
        sharedWorkflowImportPlan.setStatusMappings(this.getStatusMappings(workflowBundle.getWorkflowXml(), sharedWorkflowImportPlan.getStatusInfo()));
        sharedWorkflowImportPlan.setWorkflowName(this.getWorkflowNameForProjectKey(workflowTemplate, projectKey));
        JiraWorkflowSharingImporter jiraWorkflowSharingImporter = this.workflowImporterFactory.newImporter();
        return jiraWorkflowSharingImporter.importWorkflow(sharedWorkflowImportPlan);
    }

    private String getWorkflowNameForProjectKey(WorkflowTemplate workflowTemplate, String projectKey) {
        String proposedName = projectKey + ": " + this.getSystemTranslationForValue(workflowTemplate.name());
        if (proposedName.length() > 250) {
            proposedName = proposedName.substring(0, 250);
        }
        return this.getUniqueWorkflowName(proposedName);
    }

    private List<StatusMapping> getStatusMappings(String workflowXml, List<StatusInfo> statusInfo) {
        Map holders = this.workflowStatusHelper.getStatusHolders(workflowXml, statusInfo);
        return new ArrayList<StatusMapping>(holders.values());
    }

    private String getUniqueWorkflowName(String proposedName) {
        String wfName = proposedName;
        int counter = 1;
        while (this.workflowManager.getWorkflow(wfName) != null) {
            wfName = proposedName + " (" + counter + ")";
            ++counter;
        }
        return wfName;
    }

    private String getSystemTranslationForValue(String name) {
        return this.i18nResolver.getText(this.applicationProperties.getDefaultLocale(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowBundle importWorkflowBundle(WorkflowTemplate workflowTemplate) {
        InputStream wbInputStream = null;
        WorkflowBundle workflowBundle = null;
        try {
            wbInputStream = workflowTemplate.bundleUrl().openStream();
            workflowBundle = this.workflowBundleFactory.bundle(wbInputStream, WorkflowBundle.BundleSource.MANUAL);
        }
        catch (IOException e) {
            log.error("Error while parsing Workflow {}: {}", (Object)workflowTemplate.name(), (Object)e.getMessage());
        }
        catch (ValidationException e) {
            log.error("Error while validating Workflow {}: {}", (Object)workflowTemplate.name(), (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)wbInputStream);
        }
        return workflowBundle;
    }

    static class SharedWorkflowImportPlanFactoryHelper {
        SharedWorkflowImportPlanFactoryHelper() {
        }

        public SharedWorkflowImportPlan getSharedWorkflowImportPlan(WorkflowBundle workflowBundle) {
            return new SharedWorkflowImportPlan(ComponentAccessor.getPluginAccessor(), workflowBundle);
        }
    }
}

