/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.model;

import com.atlassian.jira.blueprint.module.AddProjectModule;
import com.atlassian.jira.projecttemplates.model.ProjectTemplate;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import org.apache.commons.lang3.StringUtils;

public class ProjectTemplateBuilder {
    static final String PT_RESOURCE_MODULE_KEY = "com.atlassian.jira.project-templates-plugin:project-templates-plugin-resources";
    static final String PT_DEFAULT_IMG_NAME = "images/project-template-default-icon.png";
    static final String PT_DEFAULT_BG_IMG_NAME = "images/default-template-background-image.png";
    private final WebResourceUrlProvider webResourceUrlProvider;
    private Integer weight;
    private String name;
    private String description;
    private String longDescriptionContent;
    private String iconUrl;
    private String backgroundIconUrl;
    private String itemModuleCompleteKey;
    private String projectTemplateModuleCompleteKey;
    private AddProjectModule addProjectModule;
    private String infoSoyPath;

    ProjectTemplateBuilder(WebResourceUrlProvider webResourceUrlProvider) {
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public ProjectTemplateBuilder weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public ProjectTemplateBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ProjectTemplateBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ProjectTemplateBuilder longDescriptionContent(String longDescriptionContent) {
        this.longDescriptionContent = longDescriptionContent;
        return this;
    }

    public ProjectTemplateBuilder iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public ProjectTemplateBuilder backgroundIconUrl(String backgroundIconUrl) {
        this.backgroundIconUrl = backgroundIconUrl;
        return this;
    }

    public ProjectTemplateBuilder itemModuleCompleteKey(String itemModuleCompleteKey) {
        this.itemModuleCompleteKey = itemModuleCompleteKey;
        return this;
    }

    public ProjectTemplateBuilder projectTemplateModuleCompleteKey(String projectTemplateModuleCompleteKey) {
        this.projectTemplateModuleCompleteKey = projectTemplateModuleCompleteKey;
        return this;
    }

    public ProjectTemplateBuilder addProjectModule(AddProjectModule addProjectModule) {
        this.addProjectModule = addProjectModule;
        return this;
    }

    public ProjectTemplateBuilder infoSoyPath(String infoSoyPath) {
        this.infoSoyPath = infoSoyPath;
        return this;
    }

    public ProjectTemplate build() {
        return new ProjectTemplate(this.weight, this.name, this.description, this.longDescriptionContent, this.defaultIconUrl(this.iconUrl, PT_DEFAULT_IMG_NAME), this.defaultIconUrl(this.backgroundIconUrl, PT_DEFAULT_BG_IMG_NAME), this.itemModuleCompleteKey, this.projectTemplateModuleCompleteKey, this.addProjectModule, this.infoSoyPath);
    }

    private String defaultIconUrl(String iconUrl, String defaultLocation) {
        if (StringUtils.isBlank((CharSequence)iconUrl)) {
            return this.webResourceUrlProvider.getStaticPluginResourceUrl(PT_RESOURCE_MODULE_KEY, defaultLocation, UrlMode.ABSOLUTE);
        }
        return iconUrl;
    }
}

