/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.model;

import com.atlassian.jira.blueprint.api.AddProjectHook;
import com.atlassian.jira.blueprint.api.EmptyAddProjectHook;
import com.atlassian.jira.blueprint.module.AddProjectModule;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class ProjectTemplate
implements Comparable<ProjectTemplate> {
    private final int weight;
    private final String name;
    private final String description;
    private final String longDescriptionContent;
    private final String iconUrl;
    private final String backgroundIconUrl;
    private final String itemModuleCompleteKey;
    private final String projectTemplateModuleCompleteKey;
    private final AddProjectModule addProjectModule;
    private final String infoSoyPath;

    ProjectTemplate(int weight, String name, String description, String longDescriptionContent, String iconUrl, String backgroundIconUrl, String itemModuleCompleteKey, String projectTemplateModuleCompleteKey, AddProjectModule addProjectModule, String infoSoyPath) {
        this.weight = weight;
        this.name = StringUtils.defaultString((String)name);
        this.description = StringUtils.defaultString((String)description);
        this.longDescriptionContent = StringUtils.defaultString((String)longDescriptionContent);
        this.iconUrl = StringUtils.defaultString((String)iconUrl);
        this.backgroundIconUrl = StringUtils.defaultString((String)backgroundIconUrl);
        this.itemModuleCompleteKey = StringUtils.defaultString((String)itemModuleCompleteKey);
        this.projectTemplateModuleCompleteKey = StringUtils.defaultString((String)projectTemplateModuleCompleteKey);
        this.addProjectModule = addProjectModule;
        this.infoSoyPath = infoSoyPath;
    }

    @JsonProperty
    public int getWeight() {
        return this.weight;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public String getLongDescriptionContent() {
        return this.longDescriptionContent;
    }

    @JsonProperty
    public String getIconUrl() {
        return this.iconUrl;
    }

    @JsonProperty
    public String getBackgroundIconUrl() {
        return this.backgroundIconUrl;
    }

    @JsonProperty
    public String getItemModuleCompleteKey() {
        return this.itemModuleCompleteKey;
    }

    @JsonProperty
    public String getProjectTemplateModuleCompleteKey() {
        return this.projectTemplateModuleCompleteKey;
    }

    @JsonProperty
    public Boolean getCreateProject() {
        return this.addProjectModule != null;
    }

    public Boolean isHasCreateHook() {
        return this.getCreateProject() != false && this.addProjectModule.hasProjectCreateHook();
    }

    @Nonnull
    public AddProjectHook getAddProjectHook() {
        if (!this.isHasCreateHook().booleanValue()) {
            return new EmptyAddProjectHook();
        }
        return this.addProjectModule.addProjectHook();
    }

    public boolean hasAddProjectModule() {
        return this.addProjectModule != null;
    }

    public AddProjectModule addProjectModule() {
        return this.addProjectModule;
    }

    @JsonProperty
    public String getInfoSoyPath() {
        return this.infoSoyPath;
    }

    @Override
    public int compareTo(ProjectTemplate that) {
        int difference = this.weight - that.weight;
        if (difference == 0) {
            return this.name.compareTo(that.name);
        }
        return difference;
    }
}

