/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.template;

import com.atlassian.jira.blueprint.descriptor.ProjectBlueprintModuleDescriptor;
import com.atlassian.jira.blueprint.template.IssueTypeTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JacksonInject;

public class IssueTypeTemplateImpl
implements IssueTypeTemplate {
    private static final String DEFAULT_ISSUE_TYPE_ICON = "/images/icons/issuetypes/genericissue.png";
    private final String key;
    private final String name;
    private final String description;
    private final String icon;
    private final String workflow;
    private final boolean isSubtask;

    public IssueTypeTemplateImpl(@JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="icon") String iconPath, @JsonProperty(value="workflow") String workflow, @JsonProperty(value="sub-task") Boolean isSubtask, @JacksonInject(value="moduleDescriptor") ProjectBlueprintModuleDescriptor moduleDescriptor) {
        this.key = ((String)Preconditions.checkNotNull((Object)key)).toUpperCase();
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = Strings.nullToEmpty((String)description);
        this.workflow = workflow == null ? null : workflow.toUpperCase();
        this.isSubtask = isSubtask == null ? false : isSubtask;
        this.icon = this.getIconResourcePath(iconPath, moduleDescriptor);
    }

    @VisibleForTesting
    public IssueTypeTemplateImpl(String key, String name, String icon, String workflow, boolean isSubtask) {
        this.key = key;
        this.name = name;
        this.description = "";
        this.icon = icon;
        this.workflow = workflow;
        this.isSubtask = isSubtask;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String icon() {
        return this.icon;
    }

    @Override
    public String workflow() {
        return this.workflow;
    }

    @Override
    public String style() {
        if (this.isSubtask()) {
            return "jira_subtask";
        }
        return "";
    }

    @Override
    public boolean hasWorkflow() {
        return this.workflow != null;
    }

    @Override
    public boolean isSubtask() {
        return this.isSubtask;
    }

    private String getIconResourcePath(String iconPath, ProjectBlueprintModuleDescriptor moduleDescriptor) {
        String resourcePath = "";
        if (Strings.isNullOrEmpty((String)iconPath)) {
            resourcePath = DEFAULT_ISSUE_TYPE_ICON;
        } else {
            String fileName = new File(iconPath).getName();
            resourcePath = moduleDescriptor.addIconResource(iconPath, fileName);
        }
        return resourcePath;
    }
}

