/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.template;

import com.atlassian.jira.blueprint.template.ConfigTemplate;
import com.atlassian.jira.blueprint.template.IssueTypeSchemeTemplate;
import com.atlassian.jira.blueprint.template.IssueTypeSchemeTemplateImpl;
import com.atlassian.jira.blueprint.template.IssueTypeTemplate;
import com.atlassian.jira.blueprint.template.WorkflowSchemeTemplateImpl;
import com.atlassian.jira.blueprint.template.WorkflowTemplate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.type.TypeReference;

public final class ConfigTemplateImpl
implements ConfigTemplate {
    public static final TypeReference<ConfigTemplateImpl> JSON_TYPE = new TypeReference<ConfigTemplateImpl>(){};
    private final WorkflowSchemeTemplateImpl workflowSchemeTemplate;
    private final IssueTypeSchemeTemplate issueTypeSchemeTemplate;

    public ConfigTemplateImpl(@JsonProperty(value="workflow-scheme") WorkflowSchemeTemplateImpl workflowSchemeTemplate, @JsonProperty(value="issue-type-scheme") IssueTypeSchemeTemplateImpl issueTypeSchemeTemplate) {
        this.workflowSchemeTemplate = workflowSchemeTemplate;
        this.issueTypeSchemeTemplate = issueTypeSchemeTemplate;
        this.validate();
    }

    @Override
    public WorkflowSchemeTemplateImpl workflowSchemeTemplate() {
        return this.workflowSchemeTemplate;
    }

    @Override
    public IssueTypeSchemeTemplate issueTypeSchemeTemplate() {
        return this.issueTypeSchemeTemplate;
    }

    @Override
    public boolean hasIssueTypeSchemeTemplate() {
        return this.issueTypeSchemeTemplate != null;
    }

    @Override
    public boolean hasWorkflowSchemeTemplate() {
        return this.workflowSchemeTemplate != null;
    }

    private void validate() {
        if (this.hasIssueTypeSchemeTemplate() && !this.hasWorkflowSchemeTemplate()) {
            this.checkTemplateWithIssueTypeSchemeButNoWorkflowScheme();
        } else if (this.hasIssueTypeSchemeTemplate() && this.hasWorkflowSchemeTemplate()) {
            this.checkTemplateWithIssueTypeSchemeAndWorkflowScheme();
        }
    }

    private void checkTemplateWithIssueTypeSchemeButNoWorkflowScheme() {
        for (IssueTypeTemplate issueTypeTemplate : this.issueTypeSchemeTemplate.issueTypeTemplates()) {
            if (!issueTypeTemplate.hasWorkflow()) continue;
            throw new IllegalArgumentException("Issue Type '" + issueTypeTemplate.name() + "' has a workflow configured, but no workflow scheme has been configured in the configuration scheme");
        }
    }

    private void checkTemplateWithIssueTypeSchemeAndWorkflowScheme() {
        HashSet workflowKeys = Sets.newHashSet();
        for (IssueTypeTemplate issueTypeTemplate : this.issueTypeSchemeTemplate.issueTypeTemplates()) {
            if (!issueTypeTemplate.hasWorkflow()) continue;
            workflowKeys.add(issueTypeTemplate.workflow());
            if (this.workflowSchemeTemplate.hasWorkflow(issueTypeTemplate.workflow())) continue;
            throw new IllegalArgumentException("Issue Type '" + issueTypeTemplate.name() + "' refers to an unknown workflow key.");
        }
        if (this.workflowSchemeTemplate.defaultWorkflow() != null) {
            workflowKeys.add(this.workflowSchemeTemplate.defaultWorkflow());
        }
        this.checkAllDefinedWorkflowsAreUsed(workflowKeys);
    }

    private void checkAllDefinedWorkflowsAreUsed(Set<String> workflowKeys) {
        for (WorkflowTemplate workflowTemplate : this.workflowSchemeTemplate.workflowTemplates()) {
            if (workflowKeys.contains(workflowTemplate.key())) continue;
            throw new IllegalArgumentException("Workflow with key '" + workflowTemplate.key() + "' is defined but not used.");
        }
    }
}

