/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient.exercise;

import com.atlassian.jira.rpc.soap.client.RemoteField;
import com.atlassian.jira.rpc.soap.client.RemoteFieldValue;
import com.atlassian.jira.rpc.soap.client.RemoteIssue;
import com.atlassian.jira.rpc.soap.client.RemoteNamedObject;
import com.atlassian.jira_soapclient.SOAPSession;
import com.atlassian.jira_soapclient.exercise.AbstractSoapExerciser;
import com.atlassian.jira_soapclient.exercise.ExerciserClientConstants;
import java.rmi.RemoteException;

public class WorkflowSoapExerciser
extends AbstractSoapExerciser {
    public WorkflowSoapExerciser(SOAPSession soapSession) {
        super(soapSession);
    }

    public void testProgressWorkflow(String issueKey) throws RemoteException {
        System.out.println("Progressing workflow of " + issueKey + "...");
        RemoteNamedObject[] availableActions = this.getJiraSoapService().getAvailableActions(this.getToken(), issueKey);
        String actionId = null;
        for (int i = 0; i < availableActions.length; ++i) {
            RemoteNamedObject availableAction = availableActions[i];
            System.out.println("availableAction: " + availableAction.getId() + " - " + availableAction.getName());
            if (actionId != null) continue;
            actionId = availableAction.getId();
        }
        this.testProgressWorkflow(issueKey, actionId);
    }

    public void testProgressWorkflow(String issueKey, String actionId) throws RemoteException {
        if (actionId != null) {
            RemoteFieldValue[] actionParams = new RemoteFieldValue[]{new RemoteFieldValue("assignee", new String[]{ExerciserClientConstants.LOGIN_NAME})};
            this.testProgressWorkflow(issueKey, actionId, actionParams);
        }
    }

    public void testProgressWorkflow(String issueKey, String actionId, RemoteFieldValue[] actionParams) throws RemoteException {
        if (actionId != null) {
            RemoteField[] fieldsForAction = this.getJiraSoapService().getFieldsForAction(this.getToken(), issueKey, actionId);
            for (int i = 0; i < fieldsForAction.length; ++i) {
                RemoteField remoteField = fieldsForAction[i];
                System.out.println("remoteField: " + remoteField.getId() + " - " + remoteField.getName());
            }
            RemoteIssue remoteIssue = this.getJiraSoapService().progressWorkflowAction(this.getToken(), issueKey, actionId, actionParams);
            System.out.println("Progressed workflow of " + remoteIssue.getKey() + " to: " + remoteIssue.getStatus());
        }
    }

    public void testResolveWithNoResolution(String issueKey) throws RemoteException {
        System.out.println("Attempting to resolve " + issueKey + "...");
        RemoteFieldValue[] actionParams = new RemoteFieldValue[]{};
        RemoteIssue remoteIssue = this.getJiraSoapService().progressWorkflowAction(this.getToken(), issueKey, "5", actionParams);
        System.out.println("Progressed workflow of " + remoteIssue.getKey() + " to: " + remoteIssue.getStatus());
    }

    public void testResolveAsCannotReproduce(String issueKey) throws RemoteException {
        System.out.println("Resolving " + issueKey + "...");
        RemoteFieldValue[] actionParams = new RemoteFieldValue[]{new RemoteFieldValue("resolution", new String[]{"5"})};
        RemoteIssue remoteIssue = this.getJiraSoapService().progressWorkflowAction(this.getToken(), issueKey, "5", actionParams);
        System.out.println("Progressed workflow of " + remoteIssue.getKey() + " to: " + remoteIssue.getStatus());
    }
}

