/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira_soapclient.exercise;

import com.atlassian.jira.rpc.soap.client.RemoteGroup;
import com.atlassian.jira.rpc.soap.client.RemoteProject;
import com.atlassian.jira.rpc.soap.client.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.client.RemoteProjectRoleActors;
import com.atlassian.jira.rpc.soap.client.RemoteRoleActors;
import com.atlassian.jira.rpc.soap.client.RemoteUser;
import com.atlassian.jira_soapclient.SOAPSession;
import com.atlassian.jira_soapclient.exercise.AbstractSoapExerciser;
import com.atlassian.jira_soapclient.exercise.ExerciserClientConstants;
import java.rmi.RemoteException;

public class UserAdminSoapExerciser
extends AbstractSoapExerciser {
    public UserAdminSoapExerciser(SOAPSession soapSession) {
        super(soapSession);
    }

    public RemoteUser testAddUser(String username, String password, String fullname, String email) throws RemoteException {
        System.out.println("Testing create User: " + username);
        RemoteUser remoteUser = this.getJiraSoapService().createUser(this.getToken(), username, password, fullname, email);
        System.out.println("Successfully created User: " + username);
        return remoteUser;
    }

    public void testDeleteGroup(String groupName, String swapGroup) throws RemoteException {
        System.out.println("Testing group delete..");
        this.getJiraSoapService().deleteGroup(this.getToken(), groupName, swapGroup);
    }

    public void testCreateGroup(String groupName) throws RemoteException {
        System.out.println("Testing group create..");
        this.getJiraSoapService().createGroup(this.getToken(), groupName, null);
    }

    public void testAddUserToGroup(String groupName, String userName) throws RemoteException {
        System.out.println("Testing add user to group..");
        RemoteGroup group = new RemoteGroup(groupName, new RemoteUser[0]);
        RemoteUser user = new RemoteUser(null, null, userName);
        this.getJiraSoapService().addUserToGroup(this.getToken(), group, user);
    }

    public void testRemoveUserFromGroup(String groupName, String userName) throws RemoteException {
        System.out.println("Testing removing user from group..");
        RemoteGroup group = new RemoteGroup(groupName, new RemoteUser[0]);
        RemoteUser user = new RemoteUser(null, null, userName);
        this.getJiraSoapService().removeUserFromGroup(this.getToken(), group, user);
    }

    public void testDeleteUser(String username) throws RemoteException {
        System.out.println("Testing user delete..");
        this.getJiraSoapService().deleteUser(this.getToken(), username);
    }

    public void testUpdateGroup(String groupName, String[] userNames) throws RemoteException {
        System.out.println("Testing group update..");
        RemoteUser[] remoteUsers = new RemoteUser[userNames.length];
        for (int i = 0; i < userNames.length; ++i) {
            remoteUsers[i] = new RemoteUser(null, null, userNames[i]);
            System.out.println("newUser.getName() = " + remoteUsers[i].getName());
            System.out.println("newUser.getFullname() = " + remoteUsers[i].getFullname());
        }
        RemoteGroup group = new RemoteGroup(groupName, remoteUsers);
        System.out.println("Updating group: " + group.getName());
        System.out.println("group.getUsers(): " + group.getUsers().length);
        this.getJiraSoapService().updateGroup(this.getToken(), group);
        group = this.getJiraSoapService().getGroup(this.getToken(), "jira-developers");
        System.out.println("group: " + group);
        System.out.println("group.getUsers(): " + group.getUsers().length);
    }

    public RemoteProjectRole[] testGetProjectRoles() throws RemoteException {
        return this.getJiraSoapService().getProjectRoles(this.getToken());
    }

    public RemoteProjectRole testGetProjectRole() throws RemoteException {
        return this.getJiraSoapService().getProjectRole(this.getToken(), Long.parseLong(ExerciserClientConstants.USER_PROJECT_ROLE_ID));
    }

    public RemoteProjectRole testCreateRole(String roleName) throws RemoteException {
        RemoteProjectRole projectRole = new RemoteProjectRole();
        projectRole.setName(roleName);
        return this.getJiraSoapService().createProjectRole(this.getToken(), projectRole);
    }

    public boolean testIsRoleNameUnique(String roleName) throws RemoteException {
        return this.getJiraSoapService().isProjectRoleNameUnique(this.getToken(), roleName);
    }

    public void testDeleteRole(RemoteProjectRole remoteProjectRole) throws RemoteException {
        this.getJiraSoapService().deleteProjectRole(this.getToken(), remoteProjectRole, true);
    }

    public void testAddDefaultActorsToProjectRole(RemoteProjectRole projectRole, String actorName, String type) throws RemoteException {
        this.getJiraSoapService().addDefaultActorsToProjectRole(this.getToken(), new String[]{actorName}, projectRole, type);
    }

    public void testRemoveDefaultActorsFromProjectRole(RemoteProjectRole projectRole, String actorName, String type) throws RemoteException {
        this.getJiraSoapService().removeDefaultActorsFromProjectRole(this.getToken(), new String[]{actorName}, projectRole, type);
    }

    public void testRemoveAllRoleActorsByNameAndType(String name, String type) throws RemoteException {
        this.getJiraSoapService().removeAllRoleActorsByNameAndType(this.getToken(), name, type);
    }

    public void testRemoveAllRoleActorsByProject(RemoteProject remoteProject) throws RemoteException {
        this.getJiraSoapService().removeAllRoleActorsByProject(this.getToken(), remoteProject);
    }

    public void testAddActorsToProjectRole(RemoteProjectRole projectRole, RemoteProject remoteProject, String actor, String actorType) throws RemoteException {
        this.getJiraSoapService().addActorsToProjectRole(this.getToken(), new String[]{actor}, projectRole, remoteProject, actorType);
    }

    public void testRemoveActorsFromProjectRole(RemoteProjectRole projectRole, RemoteProject remoteProject, String actor, String actorType) throws RemoteException {
        this.getJiraSoapService().removeActorsFromProjectRole(this.getToken(), new String[]{actor}, projectRole, remoteProject, actorType);
    }

    public RemoteProjectRoleActors testGetProjectRoleActors(Long projectRoleId) throws RemoteException {
        RemoteProjectRole projectRole = this.getJiraSoapService().getProjectRole(this.getToken(), projectRoleId);
        RemoteProject remoteProject = new RemoteProject();
        remoteProject.setId("10001");
        remoteProject.setName("monkey");
        remoteProject.setKey("MKY");
        return this.getJiraSoapService().getProjectRoleActors(this.getToken(), projectRole, remoteProject);
    }

    public void testUpdateRole(Long projectRoleId, String description) throws RemoteException {
        RemoteProjectRole projectRole = this.getJiraSoapService().getProjectRole(this.getToken(), projectRoleId);
        projectRole.setDescription(description);
        this.getJiraSoapService().updateProjectRole(this.getToken(), projectRole);
    }

    public RemoteRoleActors testGetDefaultRoleActors(Long projectRoleId) throws RemoteException {
        RemoteProjectRole projectRole = this.getJiraSoapService().getProjectRole(this.getToken(), projectRoleId);
        return this.getJiraSoapService().getDefaultRoleActors(this.getToken(), projectRole);
    }
}

